/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.formatting2;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.AbstractJavaFormatter;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.ComponentType;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.Extension;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeLabel;
import org.etsi.mts.tdl.services.TDLtxGrammarAccess;
import org.etsi.mts.tdl.structuredobjectives.Content;
import org.etsi.mts.tdl.structuredobjectives.EntityReference;
import org.etsi.mts.tdl.structuredobjectives.EventOccurrence;
import org.etsi.mts.tdl.structuredobjectives.EventReference;
import org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour;
import org.etsi.mts.tdl.structuredobjectives.FinalConditions;
import org.etsi.mts.tdl.structuredobjectives.InitialConditions;
import org.etsi.mts.tdl.structuredobjectives.LiteralValue;
import org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective;
import org.etsi.mts.tdl.tdlPackage;

public class TDLtxFormatter
extends AbstractJavaFormatter {
    @Inject
    private TDLtxGrammarAccess _grammarAccess;

    protected void format(Block e, IFormattableDocument doc) {
        for (EObject m : e.eContents()) {
            if (!(m instanceof Annotation) && !(m instanceof LocalExpression)) {
                doc.prepend(m, this.newLine());
                doc.surround(m, this.indent());
                doc.append(m, this.newLine());
            } else if (m instanceof Annotation) {
                doc.append(m, this.newLine());
            }
            doc.format((Object)m);
        }
    }

    protected void format(LiteralValue e, IFormattableDocument doc) {
        List keywords = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{","});
        for (ISemanticRegion f : keywords) {
            doc.surround(f, this.indent());
        }
        for (EObject m : e.eContents()) {
            if (m instanceof Content) {
                doc.prepend(m, this.newLine());
            }
            doc.format((Object)m);
        }
    }

    protected void format(Content e, IFormattableDocument doc) {
        doc.surround((EObject)e, this.indent());
        List keywords = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{","});
        for (ISemanticRegion f : keywords) {
            doc.surround(f, this.indent());
        }
        for (EObject m : e.eContents()) {
            if (m instanceof Content) {
                doc.prepend(m, this.newLine());
                if (!((Content)m).getContent().isEmpty() || ((Content)m).getValue() != null && !((LiteralValue)((Content)m).getValue()).getContent().isEmpty()) {
                    doc.append(m, this.newLine());
                }
            }
            doc.format((Object)m);
        }
    }

    protected void format(Element e, IFormattableDocument doc) {
        List open = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getBEGINRule()});
        List close = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getENDRule()});
        if (!open.isEmpty()) {
            doc.append((ISemanticRegion)open.get(0), this.newLine());
            doc.interior((ISemanticRegion)open.get(0), (ISemanticRegion)close.get(0), this.indent());
        }
        if (e instanceof Behaviour) {
            List features = this.textRegionExtensions.regionFor((EObject)e).features(new EStructuralFeature[]{tdlPackage.Literals.BEHAVIOUR__TEST_OBJECTIVE});
            for (ISemanticRegion f : features) {
                doc.prepend(f.getPreviousSemanticRegion(), this.newLine());
                doc.append(f, this.newLine());
            }
        }
        if (e instanceof Connection) {
            doc.prepend((EObject)e, this.newLine());
        }
        if (e instanceof EventOccurrence) {
            doc.prepend((EObject)e, this.newLine());
            doc.surround((EObject)e, this.indent());
            doc.append((EObject)e, this.newLine());
        }
        boolean cfr_ignored_0 = e instanceof ExpectedBehaviour;
        for (EObject m : e.eContents()) {
            if (m instanceof TimeLabel || m instanceof TimeConstraint) {
                doc.append(m, this.newLine());
            } else if (m instanceof Annotation || m instanceof Comment) {
                if (!(e instanceof EntityReference) && !(e instanceof EventReference)) {
                    doc.prepend(m, this.newLine());
                    doc.append(m, this.newLine());
                }
            } else if (m instanceof EntityReference) {
                doc.prepend(m, this.newLine());
            } else if (m instanceof EventOccurrence) {
                doc.prepend(m, this.newLine());
                doc.append(m, this.newLine());
            } else if (m instanceof Annotation || m instanceof Comment || m instanceof TestObjective || m instanceof ExceptionalBehaviour || m instanceof PeriodicBehaviour) {
                doc.prepend(m, this.newLine());
                doc.surround(m, this.indent());
                doc.append(m, this.newLine());
            }
            doc.format((Object)m);
        }
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> indent() {
        Procedures.Procedure1 indent = p -> p.indent();
        return indent;
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> noSpace() {
        Procedures.Procedure1 indent = p -> p.noSpace();
        return indent;
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> setSpace(String space) {
        Procedures.Procedure1 indent = p -> p.setSpace(space);
        return indent;
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> noIndentation() {
        Procedures.Procedure1 indent = p -> p.noIndentation();
        return indent;
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> setNewLines(int lines) {
        Procedures.Procedure1 indent = p -> p.setNewLines(lines);
        return indent;
    }

    public Procedures.Procedure1<? super IHiddenRegionFormatter> newLine() {
        Procedures.Procedure1 newLine = p -> p.newLine();
        return newLine;
    }

    protected void format(NamedElement e, IFormattableDocument doc) {
        ISemanticRegion atKeyword;
        ISemanticRegion noteKeyword;
        ISemanticRegion withKeyword;
        int i;
        int size;
        doc.prepend((EObject)e, this.newLine());
        if (e instanceof StructuredDataType) {
            ((StructuredDataType)e).getMember().isEmpty();
            size = ((StructuredDataType)e).getMember().size();
            i = 0;
            for (Iterator m : ((StructuredDataType)e).getMember()) {
                doc.prepend((EObject)m, this.newLine());
                doc.surround((EObject)m, this.indent());
                if (++i == size) {
                    doc.append((EObject)m, this.newLine());
                }
                doc.format((Object)m);
            }
        }
        if (e instanceof StructuredDataInstance) {
            size = ((StructuredDataInstance)e).getMemberAssignment().size();
            i = 0;
            for (Iterator m : ((StructuredDataInstance)e).getMemberAssignment()) {
                doc.prepend((EObject)m, this.newLine());
                doc.surround((EObject)m, this.indent());
                if (++i == size) {
                    doc.append((EObject)m, this.newLine());
                }
                doc.format((Object)m);
            }
        }
        if (e instanceof EnumDataType) {
            size = ((EnumDataType)e).getValue().size();
            i = 0;
            for (Iterator m : ((EnumDataType)e).getValue()) {
                doc.prepend((EObject)m, this.newLine());
                doc.surround((EObject)m, this.indent());
                if (++i == size) {
                    doc.append((EObject)m, this.newLine());
                }
                doc.format((Object)m);
            }
        }
        if (e instanceof ComponentType || e instanceof TestConfiguration || e instanceof TestDescription) {
            int i2 = 0;
            for (EObject m : e.eContents()) {
                ++i2;
                if (!(m instanceof Annotation || m instanceof Extension || m instanceof FormalParameter)) {
                    doc.prepend(m, this.newLine());
                    doc.surround(m, this.indent());
                    doc.format((Object)m);
                }
                if (i2 != e.eContents().size()) continue;
                doc.append(m, this.newLine());
            }
        }
        if (e instanceof TestDescription) {
            for (TestObjective o : ((TestDescription)e).getTestObjective()) {
                doc.prepend((EObject)o, this.newLine());
                doc.format((Object)o);
            }
        }
        if (e instanceof DataElementMapping) {
            for (ParameterMapping m : ((DataElementMapping)e).getParameterMapping()) {
                doc.prepend((EObject)m, this.newLine());
                doc.surround((EObject)m, this.indent());
                doc.format((Object)m);
            }
            List close = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getENDRule()});
            if (!close.isEmpty()) {
                doc.prepend((ISemanticRegion)close.get(0), this.newLine());
            }
        }
        if (e instanceof TestObjective) {
            doc.interior((EObject)e, this.indent());
            List features = this.textRegionExtensions.regionFor((EObject)e).features(new EStructuralFeature[]{tdlPackage.Literals.TEST_OBJECTIVE__DESCRIPTION, tdlPackage.Literals.TEST_OBJECTIVE__OBJECTIVE_URI});
            for (ISemanticRegion f : features) {
                doc.append(f, this.newLine());
            }
            List baseKeywords = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{"Description", "References"});
            for (ISemanticRegion f : baseKeywords) {
                doc.prepend(f, this.newLine());
            }
            if (e instanceof StructuredTestObjective) {
                List keywords = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{"Configuration:", "PICS:"});
                for (ISemanticRegion f : keywords) {
                    doc.prepend(f, this.newLine());
                    doc.surround(f, this.indent());
                }
                InitialConditions ic = ((StructuredTestObjective)e).getInitialConditions();
                doc.prepend((EObject)ic, this.newLine());
                doc.surround((EObject)ic, this.indent());
                doc.append((EObject)ic, this.newLine());
                doc.format((Object)ic);
                Iterator eb = ((StructuredTestObjective)e).getExpectedBehaviour();
                doc.prepend((EObject)eb, this.newLine());
                doc.surround((EObject)eb, this.indent());
                doc.append((EObject)eb, this.newLine());
                doc.format((Object)eb);
                FinalConditions fc = ((StructuredTestObjective)e).getFinalConditions();
                doc.prepend((EObject)fc, this.newLine());
                doc.surround((EObject)fc, this.indent());
                doc.append((EObject)fc, this.newLine());
                doc.format((Object)fc);
            }
        }
        if ((withKeyword = this.textRegionExtensions.regionFor((EObject)e).keyword("with")) != null) {
            doc.surround(withKeyword, this.newLine());
            doc.append(withKeyword, this.indent());
        }
        if ((noteKeyword = this.textRegionExtensions.regionFor((EObject)e).keyword("Note")) != null) {
            doc.prepend(noteKeyword, this.newLine());
        }
        if ((atKeyword = this.textRegionExtensions.regionFor((EObject)e).keyword("@")) != null) {
            doc.prepend(atKeyword, this.newLine());
        }
        for (Comment c : e.getComment()) {
            if (e.getComment().size() > 1) {
                doc.prepend((EObject)c, this.newLine());
                doc.surround((EObject)c, this.indent());
            } else {
                if (!(e instanceof Member)) {
                    doc.surround((EObject)c, this.indent());
                }
                if (!(e instanceof EntityReference)) {
                    doc.append((EObject)c, this.newLine());
                }
            }
            doc.format((Object)c);
        }
        for (Annotation a : e.getAnnotation()) {
            if (e.getAnnotation().size() > 1) {
                doc.prepend((EObject)a, this.newLine());
                doc.surround((EObject)a, this.indent());
            } else {
                doc.append((EObject)a, this.newLine());
            }
            doc.format((Object)a);
        }
        List closeItems = this.textRegionExtensions.allRegionsFor((EObject)e).keywords(new String[]{"]"});
        for (ISemanticRegion r : closeItems) {
            doc.surround(r, this.newLine());
        }
    }

    protected void format(TestDescription e, IFormattableDocument doc) {
        for (Annotation a : e.getAnnotation()) {
            doc.surround((EObject)a, this.newLine());
            doc.format((Object)a);
        }
        for (Annotation a : e.getTestObjective()) {
            doc.format((Object)a);
            doc.append((EObject)a, this.newLine());
        }
        for (Comment c : e.getComment()) {
            doc.append((EObject)c, this.newLine());
            doc.format((Object)c);
        }
        doc.prepend((EObject)e, this.newLine());
        for (EObject m : e.eContents()) {
            doc.format((Object)m);
        }
        List keywords = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{"Test"});
        for (ISemanticRegion f : keywords) {
            doc.prepend(f, this.newLine());
        }
    }

    protected void format(DataUse e, IFormattableDocument doc) {
        List closeItems;
        List closeParen;
        for (ParameterBinding m : e.getArgument()) {
            doc.prepend((EObject)m, this.newLine());
            doc.surround((EObject)m, this.indent());
            doc.format((Object)m);
        }
        if (e instanceof DataElementUse) {
            for (ParameterBinding m : ((DataElementUse)e).getItem()) {
                doc.prepend((EObject)m, this.newLine());
                doc.surround((EObject)m, this.indent());
                doc.format((Object)m);
            }
        }
        if (!(closeParen = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getRParenRule()})).isEmpty()) {
            doc.prepend((ISemanticRegion)closeParen.get(0), this.newLine());
        }
        if (!(closeItems = this.textRegionExtensions.regionFor((EObject)e).keywords(new String[]{"]"})).isEmpty()) {
            doc.prepend((ISemanticRegion)closeItems.get(0), this.newLine());
        }
    }

    protected void format(Package _package, IFormattableDocument doc) {
        if (this.getPreferences() instanceof MapBasedPreferenceValues) {
            MapBasedPreferenceValues preferences = (MapBasedPreferenceValues)this.getPreferences();
            preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.indentation, (Object)"    ");
        }
        Package e = _package;
        for (Annotation a : e.getAnnotation()) {
            doc.append((EObject)a, this.newLine());
            doc.append((EObject)a, this.noIndentation());
            doc.format((Object)a);
        }
        for (Comment c : e.getComment()) {
            doc.append((EObject)c, this.newLine());
            doc.append((EObject)c, this.noIndentation());
            doc.format((Object)c);
        }
        doc.interior((EObject)_package, this.indent());
        List dots = this.textRegionExtensions.allRegionsFor((EObject)e).keywords(new String[]{".", "@", ",", "::"});
        for (ISemanticRegion dot : dots) {
            doc.surround(dot, this.noSpace());
        }
        List colon = this.textRegionExtensions.allRegionsFor((EObject)e).keywords(new String[]{":"});
        Iterator iterator = colon.iterator();
        while (iterator.hasNext()) {
            ISemanticRegion cfr_ignored_0 = (ISemanticRegion)iterator.next();
        }
        for (ElementImport elementImport : _package.getImport()) {
            doc.surround((EObject)elementImport, this.setNewLines(1));
            doc.format((Object)elementImport);
        }
        for (PackageableElement packageableElement : _package.getPackagedElement()) {
            doc.surround((EObject)packageableElement, this.setNewLines(1));
            doc.format((Object)packageableElement);
        }
        for (Package __package : _package.getNestedPackage()) {
            doc.surround((EObject)__package, this.setNewLines(1));
            doc.format((Object)__package);
        }
    }
}

