package org.etsi.mts.tdl.ttcn3.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.etsi.mts.tdl.ttcn3.Transform;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 */
public class TransformationHandler extends AbstractHandler {
	@Inject Injector injector;
	@Inject Provider<ResourceSet> rsp;
	@Inject Provider<XtextResourceSet> xrsp;

	
	@Inject IResourceSetProvider resourceSetProvider;

	 private IWorkbenchWindow window;

	/**
	 * The constructor.
	 */
	public TransformationHandler() {
	}
	
	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		IEditorInput input = HandlerUtil.getActiveEditorInput(event);
		IFile file = null;
		if (input != null && input instanceof FileEditorInput) {
			file = ((FileEditorInput) input).getFile();
		} else if (selection !=null && selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			Object firstElement = structuredSelection.getFirstElement();
			if (firstElement instanceof IFile) {
				file = (IFile) firstElement;
			}
		}
		try {
			if (file !=null) {
				injector = Guice.createInjector();
				URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
				XtextResourceSet rs = injector.getInstance(XtextResourceSet.class);
				Resource r = rs.getResource(uri, true);
				EcoreUtil.resolveAll(r); //This is important otherwise weird problems occur if unresolved imported definitions are encountered
				if (file.getName().endsWith(".tdl")
						|| file.getName().endsWith(".tdlan2")
						|| file.getName().endsWith(".tdltx")
						|| file.getName().endsWith(".tdltxi")) {
					Transform transformer = new Transform();
					
					URI interimURI = URI.createURI(uri.toString()+"-generated.ttcn3m");
					Resource ir = rs.createResource(interimURI);
					transformer.transform(r, ir);
					//This is important otherwise ghost references may occur
					ir.unload();
					URI targetURI = URI.createURI(uri.toString()+"-generated.ttcn3");
					//				URI targetURI = URI.createPlatformResourceURI(file.getFullPath().toString()+".ttcn3", true);
					//				Injector injector = Guice.createInjector(new de.ugoe.cs.swe.TTCN3RuntimeModule());
					//				XtextResourceSet resourceSet = injector.getInstance(XtextResourceSet.class);
					//				Resource tr = resourceSet.createResource(targetURI);
					Resource tr = rs.createResource(targetURI);
					transformer.transform(r, tr);
				} else if (file.getName().endsWith(".ttcn3")) {
					URI targetURI = URI.createURI(uri.toString()+".ttcn3m");
					Resource tr = rs.createResource(targetURI);
					tr.getContents().addAll(EcoreUtil.copyAll(r.getContents()));
					tr.save(null);
				} else if (file.getName().endsWith(".ttcn3m")) {
					URI targetURI = URI.createURI(uri.toString()+".ttcn3");
					Resource tr = rs.createResource(targetURI);
					tr.getContents().addAll(EcoreUtil.copyAll(r.getContents()));
					tr.save(null);
				}
				
			}
		} catch (Exception e) {
			System.err.println("  Transformation: "+e.getMessage());
			//TODO: add dialog
		}
		return null;
	}
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}
}
