/**
 */
package org.etsi.mts.tdl.structuredobjectives;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Event Occurrence Specification</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEntityReference <em>Entity Reference</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventReference <em>Event Reference</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getOppositeEntityReference <em>Opposite Entity Reference</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventArgument <em>Event Argument</em>}</li>
 * </ul>
 *
 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage#getEventOccurrenceSpecification()
 * @model
 * @generated
 */
public interface EventOccurrenceSpecification extends EventOccurrence, Element
{
	/**
	 * Returns the value of the '<em><b>Entity Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Entity Reference</em>' containment reference.
	 * @see #setEntityReference(EntityReference)
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage#getEventOccurrenceSpecification_EntityReference()
	 * @model containment="true"
	 * @generated
	 */
	EntityReference getEntityReference();

	/**
	 * Sets the value of the '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEntityReference <em>Entity Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entity Reference</em>' containment reference.
	 * @see #getEntityReference()
	 * @generated
	 */
	void setEntityReference(EntityReference value);

	/**
	 * Returns the value of the '<em><b>Event Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Event Reference</em>' containment reference.
	 * @see #setEventReference(EventReference)
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage#getEventOccurrenceSpecification_EventReference()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EventReference getEventReference();

	/**
	 * Sets the value of the '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventReference <em>Event Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Event Reference</em>' containment reference.
	 * @see #getEventReference()
	 * @generated
	 */
	void setEventReference(EventReference value);

	/**
	 * Returns the value of the '<em><b>Opposite Entity Reference</b></em>' containment reference list.
	 * The list contents are of type {@link org.etsi.mts.tdl.structuredobjectives.EntityReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Opposite Entity Reference</em>' containment reference list.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage#getEventOccurrenceSpecification_OppositeEntityReference()
	 * @model containment="true"
	 * @generated
	 */
	EList<EntityReference> getOppositeEntityReference();

	/**
	 * Returns the value of the '<em><b>Event Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Event Argument</em>' containment reference.
	 * @see #setEventArgument(Value)
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage#getEventOccurrenceSpecification_EventArgument()
	 * @model containment="true"
	 * @generated
	 */
	Value getEventArgument();

	/**
	 * Sets the value of the '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventArgument <em>Event Argument</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Event Argument</em>' containment reference.
	 * @see #getEventArgument()
	 * @generated
	 */
	void setEventArgument(Value value);

} // EventOccurrenceSpecification
