package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.etsi.mts.tdl.execution.java.tri.Data;
import org.etsi.mts.tdl.execution.java.tri.Mapping;
import org.etsi.mts.tdl.execution.java.tri.Type;
import org.etsi.mts.tdl.execution.java.tri.Value;

public class ValueImpl extends NamedElementImpl implements Value, TriImpl<ValueImpl, Data<Type, Value>> {
	private TypeImpl type;

	private boolean collection = false;
	private boolean structure = false;

	private Object value = null;
	private Map<String, Data<Type, Value>> parameters = new Hashtable<String, Data<Type, Value>>();
	private List<Data<Type, Value>> items = new ArrayList<Data<Type, Value>>();

	private MappingImpl mapping;

	public ValueImpl() {
	}

	public ValueImpl(TypeImpl type) {
		this.type = type;
	}

	public ValueImpl setType(TypeImpl type) {
		this.type = type;
		return this;
	}

	public ValueImpl setIsCollection(boolean collection) {
		this.collection = collection;
		return this;
	}

	public ValueImpl setIsStructure(boolean structure) {
		this.structure = structure;
		return this;
	}

	@Override
	public boolean isCollection() {
		return this.collection;
	}

	@Override
	public boolean isStructure() {
		return this.structure;
	}

	public ValueImpl setMapping(Mapping mapping) {
		this.mapping = (MappingImpl) mapping;
		return this;
	}

	@Override
	public MappingImpl getMapping() {
		return mapping;
	}

	@Override
	public Object getValue() {
		return this.value;
	}

	public ValueImpl setValue(Object value) {
		this.value = value;
		return this;
	}

	@Override
	public Collection<String> getParameters() {
		return this.parameters.keySet();
	}

	@Override
	public Data<Type, Value> getParameter(String name) {
		return this.parameters.get(name);
	}

	@Override
	public ValueImpl setParameter(String name, Data<Type, Value> value) {
		this.parameters.put(name, value);
		return this;
	}

	@Override
	public List<Data<Type, Value>> getItems() {
		return this.items;
	}

	public ValueImpl addItem(Data<Type, Value> item) {
		this.items.add(item);
		return this;
	}

	public ValueImpl setItems(List<Data<Type, Value>> items) {
		this.items = items;
		return this;
	}

	@Override
	public ValueImpl setName(String name, String qualifiedName) {
		this.name = name;
		this.setQualifiedName(qualifiedName);
		return this;
	}

	@Override
	public ValueImpl addAnnotation(String key, String value) {
		super.addAnnotation(key, value);
		return this;
	}

	public Data<Type, Value> asData() {
		return new DataImpl<Type, Value>(type, this);
	}

}
