package org.etsi.mts.tdl.execution.java.rt.core;

import org.etsi.mts.tdl.execution.java.tri.ComponentInstanceRole;
import org.etsi.mts.tdl.execution.java.tri.Element;
import org.etsi.mts.tdl.execution.java.tri.GateReference;
import org.etsi.mts.tdl.execution.java.tri.GateTypeKind;
import org.etsi.mts.tdl.execution.java.tri.NamedElement;

/**
 * Encapsulation of a connection end-point specification. It's an aggregation of
 * following TDL model elements:
 * <ul>
 * <li>GateInstance</li>
 * <li>GateType</li>
 * <li>ComponentInstance</li>
 * <li>ComponentType</li>
 * <li>ComponentInstanceRole</li>
 * </ul>
 *
 */
public class GateReferenceImpl implements GateReference {
	private Element gate;
	private NamedElement gateType;
	private GateTypeKind gateTypeKind;
	private Element component;
	private NamedElement componentType;
	private ComponentInstanceRole role;

	public GateReferenceImpl(Element gate, NamedElement gateType, GateTypeKind gateTypeKind, Element component, NamedElement componentType,
			ComponentInstanceRole role) {
		this.gate = gate;
		this.gateType = gateType;
		this.gateTypeKind = gateTypeKind;
		this.component = component;
		this.componentType = componentType;
		this.role = role;
	}
	
	@Override
	public Element getGate() {
		return gate;
	}

	@Override
	public NamedElement getGateType() {
		return gateType;
	}

	@Override
	public GateTypeKind getGateTypeKind() {
		return gateTypeKind;
	}

	@Override
	public Element getComponent() {
		return component;
	}

	@Override
	public NamedElement getComponentType() {
		return componentType;
	}

	@Override
	public ComponentInstanceRole getComponentRole() {
		return role;
	}

	@Override
	public int hashCode() {
		return gate.hashCode() << 8 + gateType.hashCode() << 6 + component.hashCode() << 4
				+ componentType.hashCode() << 2 + role.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof GateReferenceImpl) {
			GateReferenceImpl gr = (GateReferenceImpl) obj;
			return gate.equals(gr.gate) && gateType.equals(gr.gateType) && component.equals(gr.component)
					&& componentType.equals(gr.componentType) && role.equals(gr.role);
		}
		return super.equals(obj);
	}

}