/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.FontRel;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontTablePart
extends JaxbXmlPart<Fonts> {
    private static Logger log = LoggerFactory.getLogger(FontTablePart.class);

    public FontTablePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public FontTablePart() throws InvalidFormatException {
        super(new PartName("/word/fontTable.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable");
    }

    public Object unmarshalDefaultFonts() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.openpackaging.parts.WordprocessingML.FontTablePart.DefaultFonts", "org/docx4j/openpackaging/parts/WordprocessingML/fontTable.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    public void processEmbeddings() {
        Fonts fonts = (Fonts)this.getJaxbElement();
        for (Fonts.Font font : fonts.getFont()) {
            String fontName = font.getName();
            FontRel embedRegular = font.getEmbedRegular();
            FontRel embedBold = font.getEmbedBold();
            FontRel embedBoldItalic = font.getEmbedBoldItalic();
            FontRel embedItalic = font.getEmbedItalic();
            this.getObfuscatedFontFromRelationship(fontName, embedRegular);
            this.getObfuscatedFontFromRelationship(fontName, embedBold);
            this.getObfuscatedFontFromRelationship(fontName, embedBoldItalic);
            this.getObfuscatedFontFromRelationship(fontName, embedItalic);
        }
    }

    private void getObfuscatedFontFromRelationship(String fontName, FontRel fontRel) {
        if (fontRel == null) {
            return;
        }
        String id = fontRel.getId();
        String fontKey = fontRel.getFontKey();
        ObfuscatedFontPart obfuscatedFont = (ObfuscatedFontPart)this.getRelationshipsPart().getPart(id);
        if (obfuscatedFont != null) {
            obfuscatedFont.deObfuscate(fontName, fontKey);
        } else {
            log.error("Couldn't find ObfuscatedFontPart with id: " + id);
        }
    }

    public static void main(String[] args) throws Exception {
        String filepath = System.getProperty("user.dir") + "/sample-docs/word/FontEmbedded.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(filepath));
        wordMLPackage.getMainDocumentPart().getFontTablePart().processEmbeddings();
    }
}

