/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.config.WhiteSpaceProcessing;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.CharactersEvent;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.load.text.TextTokenizer;
import com.topologi.diffx.load.text.TokenizerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenizerByText
implements TextTokenizer {
    private final WhiteSpaceProcessing whitespace;

    public TokenizerByText(WhiteSpaceProcessing whitespace) {
        if (whitespace == null) {
            throw new NullPointerException("the white space processing must be specified.");
        }
        this.whitespace = whitespace;
    }

    @Override
    public List<TextEvent> tokenize(CharSequence seq) {
        if (seq == null) {
            return null;
        }
        if (seq.length() == 0) {
            return Collections.emptyList();
        }
        int x = TokenizerUtils.getLeadingWhiteSpace(seq);
        int y = TokenizerUtils.getTrailingWhiteSpace(seq);
        if (x == 0 && y == 0) {
            CharactersEvent e = new CharactersEvent(seq);
            return Collections.singletonList(e);
        }
        if (x == seq.length()) {
            switch (this.whitespace) {
                case COMPARE: {
                    return Collections.singletonList(SpaceEvent.getInstance(seq.toString()));
                }
                case PRESERVE: {
                    return Collections.singletonList(new IgnorableSpaceEvent(seq.toString()));
                }
                case IGNORE: {
                    return Collections.emptyList();
                }
            }
            CharactersEvent e = new CharactersEvent(seq);
            return Collections.singletonList(e);
        }
        List<Object> events = null;
        switch (this.whitespace) {
            case COMPARE: {
                events = new ArrayList(1 + (x > 0 ? 1 : 0) + (y > 0 ? 1 : 0));
                if (x > 0) {
                    events.add(SpaceEvent.getInstance(seq.subSequence(0, x)));
                }
                events.add(new CharactersEvent(seq.subSequence(x, seq.length() - y)));
                if (y <= 0) break;
                events.add(SpaceEvent.getInstance(seq.subSequence(seq.length() - y, seq.length())));
                break;
            }
            case PRESERVE: {
                events = new ArrayList(1 + (x > 0 ? 1 : 0) + (y > 0 ? 1 : 0));
                if (x > 0) {
                    events.add(new IgnorableSpaceEvent(seq.subSequence(0, x)));
                }
                events.add(new CharactersEvent(seq.subSequence(x, seq.length() - y)));
                if (y <= 0) break;
                events.add(new IgnorableSpaceEvent(seq.subSequence(seq.length() - y, seq.length())));
                break;
            }
            case IGNORE: {
                CharactersEvent e = new CharactersEvent(seq.subSequence(x, seq.length() - y));
                events = Collections.singletonList(e);
                break;
            }
        }
        return events;
    }

    @Override
    public TextGranularity granurality() {
        return TextGranularity.TEXT;
    }
}

