package org.etsi.mts.tdl.execution.java.tri;

/**
 * Encapsulation of type and value. The objects are resolved using TDL data
 * mappings.
 * <p>
 * In Java environment the <code>type</code> is a Java class and
 * <code>value</code> is an object of that class or a lambda expression that
 * returns such object.
 */
public class Data<T, V> {

	/**
	 * The type information in environment specific form that can be used to decode
	 * incoming data. For example, an annotated class.
	 */
	private T type;

	/**
	 * The decoded value of the data that matches the type.
	 */
	private V value;

	public Data(T type, V value) {
		this.type = type;
		this.value = value;
	}

	/**
	 * @see #value
	 */
	public V getValue() {
		return value;
	}

	/**
	 * @see #type
	 */
	public T getType() {
		return type;
	}

}
