package org.etsi.mts.tdl.execution.java.tri;

/**
 * Encapsulation of connected <code>GateReference</code>s.
 *
 */
public class Connection extends Element {

	/**
	 * The end-points of this connection as specified in TDL model.
	 */
	public final GateReference[] endPoints = new GateReference[2];

	public Connection(String name, GateReference sourceGate, GateReference targetGate) {
		super(name);
		endPoints[0] = sourceGate;
		endPoints[1] = targetGate;
	}
	
	@Override
	public String toString() {
		if (name != null)
			return name;
		return endPoints[0].toString() + " :: " + endPoints[1].toString();
	}
}
