/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;

@Beta
@NonNullByDefault
public final class SingletonSpliterators {
    private SingletonSpliterators() {
    }

    public static <T> Spliterator<T> immutableOf(T element) {
        return new ImmutableNonNull<T>(element);
    }

    public static <T> Spliterator<T> immutableOfNull() {
        return new ImmutableNull();
    }

    private static final class ImmutableNonNull<T>
    implements Mutable,
    Spliterator<T> {
        private final T element;
        private boolean consumed;

        private ImmutableNonNull(T element) {
            this.element = Objects.requireNonNull(element);
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.consumed) {
                return false;
            }
            action.accept(this.element);
            this.consumed = true;
            return true;
        }

        @Override
        public @Nullable Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.consumed ? 0L : 1L;
        }

        @Override
        public int characteristics() {
            return 17745;
        }
    }

    private static final class ImmutableNull<@Nullable E>
    implements Mutable,
    Spliterator<E> {
        private boolean consumed;

        private ImmutableNull() {
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (this.consumed) {
                return false;
            }
            action.accept(null);
            this.consumed = true;
            return true;
        }

        @Override
        public @Nullable Spliterator<E> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.consumed ? 0L : 1L;
        }

        @Override
        public int characteristics() {
            return 17489;
        }
    }
}

