/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

@Beta
public enum YangVersion {
    VERSION_1("1", "RFC6020"),
    VERSION_1_1("1.1", "RFC7950");

    private static final Map<String, YangVersion> YANG_VERSION_MAP;
    private final @NonNull String str;
    private final @NonNull String reference;

    private YangVersion(String str, String reference) {
        this.str = Objects.requireNonNull(str);
        this.reference = Objects.requireNonNull(reference);
    }

    public static Optional<YangVersion> parse(@NonNull String str) {
        return Optional.ofNullable(YANG_VERSION_MAP.get(Objects.requireNonNull(str)));
    }

    public @NonNull String getReference() {
        return this.reference;
    }

    public @NonNull String toString() {
        return this.str;
    }

    static {
        YANG_VERSION_MAP = Maps.uniqueIndex(Arrays.asList(YangVersion.values()), YangVersion::toString);
    }
}

