/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBinaryType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBitsType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBooleanType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedDecimalType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedEmptyType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedEnumerationType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedIdentityrefType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInstanceIdentifierType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt16Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt32Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt64Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt8Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedLeafrefType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedStringType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint16Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint32Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint64Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint8Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUnionType;

@Beta
@NonNullByDefault
public final class ConcreteTypes {
    private ConcreteTypes() {
    }

    public static ConcreteTypeBuilder<?> concreteTypeBuilder(TypeDefinition<?> baseType, QName qname) {
        if (baseType instanceof BinaryTypeDefinition) {
            return ConcreteTypes.concreteBinaryBuilder((BinaryTypeDefinition)baseType, qname);
        }
        if (baseType instanceof BitsTypeDefinition) {
            return ConcreteTypes.concreteBitsBuilder((BitsTypeDefinition)baseType, qname);
        }
        if (baseType instanceof BooleanTypeDefinition) {
            return ConcreteTypes.concreteBooleanBuilder((BooleanTypeDefinition)baseType, qname);
        }
        if (baseType instanceof DecimalTypeDefinition) {
            return ConcreteTypes.concreteDecimalBuilder((DecimalTypeDefinition)baseType, qname);
        }
        if (baseType instanceof EmptyTypeDefinition) {
            return ConcreteTypes.concreteEmptyBuilder((EmptyTypeDefinition)baseType, qname);
        }
        if (baseType instanceof EnumTypeDefinition) {
            return ConcreteTypes.concreteEnumerationBuilder((EnumTypeDefinition)baseType, qname);
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            return ConcreteTypes.concreteIdentityrefBuilder((IdentityrefTypeDefinition)baseType, qname);
        }
        if (baseType instanceof InstanceIdentifierTypeDefinition) {
            return ConcreteTypes.concreteInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)baseType, qname);
        }
        if (baseType instanceof Int8TypeDefinition) {
            return ConcreteTypes.concreteInt8Builder((Int8TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Int16TypeDefinition) {
            return ConcreteTypes.concreteInt16Builder((Int16TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Int32TypeDefinition) {
            return ConcreteTypes.concreteInt32Builder((Int32TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Int64TypeDefinition) {
            return ConcreteTypes.concreteInt64Builder((Int64TypeDefinition)baseType, qname);
        }
        if (baseType instanceof LeafrefTypeDefinition) {
            return ConcreteTypes.concreteLeafrefBuilder((LeafrefTypeDefinition)baseType, qname);
        }
        if (baseType instanceof StringTypeDefinition) {
            return ConcreteTypes.concreteStringBuilder((StringTypeDefinition)baseType, qname);
        }
        if (baseType instanceof UnionTypeDefinition) {
            return ConcreteTypes.concreteUnionBuilder((UnionTypeDefinition)baseType, qname);
        }
        if (baseType instanceof Uint8TypeDefinition) {
            return ConcreteTypes.concreteUint8Builder((Uint8TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Uint16TypeDefinition) {
            return ConcreteTypes.concreteUint16Builder((Uint16TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Uint32TypeDefinition) {
            return ConcreteTypes.concreteUint32Builder((Uint32TypeDefinition)baseType, qname);
        }
        if (baseType instanceof Uint64TypeDefinition) {
            return ConcreteTypes.concreteUint64Builder((Uint64TypeDefinition)baseType, qname);
        }
        throw new IllegalArgumentException("Unhandled type definition class " + baseType.getClass());
    }

    public static TypeDefinition<?> typeOf(LeafEffectiveStatement leaf) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)leaf.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).orElseThrow();
        ConcreteTypeBuilder<?> builder = ConcreteTypes.concreteTypeBuilder(typeStmt.getTypeDefinition(), (QName)leaf.argument());
        for (EffectiveStatement stmt : leaf.effectiveSubstatements()) {
            if (stmt instanceof DefaultEffectiveStatement) {
                builder.setDefaultValue(((DefaultEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (!(stmt instanceof UnitsEffectiveStatement)) continue;
            builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
        }
        return builder.build();
    }

    public static TypeDefinition<?> typeOf(LeafListEffectiveStatement leafList) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)leafList.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).get();
        ConcreteTypeBuilder<?> builder = ConcreteTypes.concreteTypeBuilder(typeStmt.getTypeDefinition(), (QName)leafList.argument());
        for (EffectiveStatement stmt : leafList.effectiveSubstatements()) {
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (!(stmt instanceof UnitsEffectiveStatement)) continue;
            builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
        }
        return builder.build();
    }

    private static ConcreteTypeBuilder<BinaryTypeDefinition> concreteBinaryBuilder(BinaryTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BinaryTypeDefinition>(baseType, qname){

            @Override
            public BinaryTypeDefinition buildType() {
                return new DerivedBinaryType((BinaryTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BitsTypeDefinition> concreteBitsBuilder(BitsTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BitsTypeDefinition>(baseType, qname){

            @Override
            public BitsTypeDefinition buildType() {
                return new DerivedBitsType((BitsTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BooleanTypeDefinition> concreteBooleanBuilder(BooleanTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BooleanTypeDefinition>(baseType, qname){

            @Override
            public BooleanTypeDefinition buildType() {
                return new DerivedBooleanType((BooleanTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<DecimalTypeDefinition> concreteDecimalBuilder(DecimalTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<DecimalTypeDefinition>(baseType, qname){

            @Override
            public DecimalTypeDefinition buildType() {
                return new DerivedDecimalType((DecimalTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EmptyTypeDefinition> concreteEmptyBuilder(EmptyTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<EmptyTypeDefinition>(baseType, qname){

            @Override
            public EmptyTypeDefinition buildType() {
                return new DerivedEmptyType((EmptyTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EnumTypeDefinition> concreteEnumerationBuilder(EnumTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<EnumTypeDefinition>(baseType, qname){

            @Override
            public EnumTypeDefinition buildType() {
                return new DerivedEnumerationType((EnumTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<IdentityrefTypeDefinition> concreteIdentityrefBuilder(IdentityrefTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<IdentityrefTypeDefinition>(baseType, qname){

            @Override
            public IdentityrefTypeDefinition buildType() {
                return new DerivedIdentityrefType((IdentityrefTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<InstanceIdentifierTypeDefinition> concreteInstanceIdentifierBuilder(final InstanceIdentifierTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<InstanceIdentifierTypeDefinition>(baseType, qname){

            @Override
            public InstanceIdentifierTypeDefinition buildType() {
                return new DerivedInstanceIdentifierType((InstanceIdentifierTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes(), baseType.requireInstance());
            }
        };
    }

    private static ConcreteTypeBuilder<Int8TypeDefinition> concreteInt8Builder(Int8TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int8TypeDefinition>(baseType, qname){

            @Override
            public Int8TypeDefinition buildType() {
                return new DerivedInt8Type((Int8TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int16TypeDefinition> concreteInt16Builder(Int16TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int16TypeDefinition>(baseType, qname){

            @Override
            public Int16TypeDefinition buildType() {
                return new DerivedInt16Type((Int16TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int32TypeDefinition> concreteInt32Builder(Int32TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int32TypeDefinition>(baseType, qname){

            @Override
            public Int32TypeDefinition buildType() {
                return new DerivedInt32Type((Int32TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int64TypeDefinition> concreteInt64Builder(Int64TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int64TypeDefinition>(baseType, qname){

            @Override
            public Int64TypeDefinition buildType() {
                return new DerivedInt64Type((Int64TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<LeafrefTypeDefinition> concreteLeafrefBuilder(LeafrefTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<LeafrefTypeDefinition>(baseType, qname){

            @Override
            public LeafrefTypeDefinition buildType() {
                return new DerivedLeafrefType((LeafrefTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<StringTypeDefinition> concreteStringBuilder(StringTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<StringTypeDefinition>(baseType, qname){

            @Override
            public StringTypeDefinition buildType() {
                return new DerivedStringType((StringTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<UnionTypeDefinition> concreteUnionBuilder(UnionTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<UnionTypeDefinition>(baseType, qname){

            @Override
            public DerivedUnionType buildType() {
                return new DerivedUnionType((UnionTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint8TypeDefinition> concreteUint8Builder(Uint8TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint8TypeDefinition>(baseType, qname){

            @Override
            public Uint8TypeDefinition buildType() {
                return new DerivedUint8Type((Uint8TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint16TypeDefinition> concreteUint16Builder(Uint16TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint16TypeDefinition>(baseType, qname){

            @Override
            public Uint16TypeDefinition buildType() {
                return new DerivedUint16Type((Uint16TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint32TypeDefinition> concreteUint32Builder(Uint32TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint32TypeDefinition>(baseType, qname){

            @Override
            public Uint32TypeDefinition buildType() {
                return new DerivedUint32Type((Uint32TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint64TypeDefinition> concreteUint64Builder(Uint64TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint64TypeDefinition>(baseType, qname){

            @Override
            public Uint64TypeDefinition buildType() {
                return new DerivedUint64Type((Uint64TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }
}

