/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SweptNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NamespaceStorageSupport
implements NamespaceBehaviour.NamespaceStorageNode {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceStorageSupport.class);
    private Map<ParserNamespace<?, ?>, Map<?, ?>> namespaces = ImmutableMap.of();

    NamespaceStorageSupport() {
    }

    public abstract NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage();

    public abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NamespaceBehaviour.Registry getBehaviourRegistry();

    final void checkLocalNamespaceAllowed(ParserNamespace<?, ?> type) {
    }

    protected <K, V> void onNamespaceElementAdded(ParserNamespace<K, V> type, K key, V value) {
    }

    public final <K, V> Optional<Map.Entry<K, V>> getFromNamespace(ParserNamespace<K, V> type, NamespaceKeyCriterion<K> criterion) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, criterion);
    }

    public final <K, V> Map<K, V> getNamespace(ParserNamespace<K, V> type) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getAllFrom((NamespaceBehaviour.NamespaceStorageNode)this);
    }

    final <K, V> Map<K, V> getLocalNamespace(ParserNamespace<K, V> type) {
        return this.accessNamespaces().get(type);
    }

    final <K, V, T extends K, U extends V> void addToNamespace(ParserNamespace<K, V> type, T key, U value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    final <K, V, T extends K, U extends V> void addToNamespace(ParserNamespace<K, V> type, Map<T, U> map) {
        NamespaceBehaviour behavior = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        for (Map.Entry<T, U> validationBundle : map.entrySet()) {
            behavior.addTo((NamespaceBehaviour.NamespaceStorageNode)this, validationBundle.getKey(), validationBundle.getValue());
        }
    }

    public final <K, C extends StmtContext<?, ?, ?>> void addContextToNamespace(ParserNamespace<K, ? super C> type, K key, C value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    public <K, V> V getFromLocalStorage(ParserNamespace<K, V> type, K key) {
        Map<?, ?> localNamespace = this.accessNamespaces().get(type);
        return localNamespace == null ? null : (V)localNamespace.get(key);
    }

    public <K, V> Map<K, V> getAllFromLocalStorage(ParserNamespace<K, V> type) {
        Map<?, ?> localNamespace = this.accessNamespaces().get(type);
        return localNamespace;
    }

    public <K, V> V putToLocalStorage(ParserNamespace<K, V> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).put(key, value);
        this.onNamespaceElementAdded(type, key, value);
        return ret;
    }

    public <K, V> V putToLocalStorageIfAbsent(ParserNamespace<K, V> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).putIfAbsent(key, value);
        if (ret == null) {
            this.onNamespaceElementAdded(type, key, value);
        }
        return ret;
    }

    void sweepNamespaces() {
        this.namespaces = null;
        LOG.trace("Swept namespace storages of {}", (Object)this);
    }

    void sweepNamespaces(Map<ParserNamespace<?, ?>, SweptNamespace> toWipe) {
        switch (this.namespaces.size()) {
            case 0: {
                this.namespaces = ImmutableMap.copyOf(toWipe);
                return;
            }
            case 1: {
                this.namespaces = new HashMap(this.namespaces);
                break;
            }
        }
        this.namespaces.putAll(toWipe);
        LOG.trace("Trimmed namespace storages of {} to {}", (Object)this, this.namespaces.keySet());
    }

    private Map<ParserNamespace<?, ?>, Map<?, ?>> accessNamespaces() {
        return (Map)Verify.verifyNotNull(this.namespaces, (String)"Attempted to access swept namespaces of %s", (Object[])new Object[]{this});
    }

    private <K, V> Map<K, V> ensureLocalNamespace(ParserNamespace<K, V> type) {
        Map<?, ?> ret = this.accessNamespaces().get(type);
        if (ret == null) {
            this.checkLocalNamespaceAllowed(type);
            ret = new HashMap(1);
            switch (this.namespaces.size()) {
                case 0: {
                    this.namespaces = ImmutableMap.of(type, ret);
                    break;
                }
                case 1: {
                    HashMap newNamespaces = new HashMap(4);
                    Map.Entry<ParserNamespace<?, ?>, Map<?, ?>> entry = this.namespaces.entrySet().iterator().next();
                    newNamespaces.put(entry.getKey(), entry.getValue());
                    this.namespaces = newNamespaces;
                }
                default: {
                    this.namespaces.put(type, ret);
                }
            }
        }
        return ret;
    }
}

