package org.etsi.mts.tdl.execution.java.tri;

/**
 * Encapsulation of a connection end-point specification. It's an aggregation of
 * following TDL model elements:
 * <ul>
 * <li>GateInstance</li>
 * <li>GateType</li>
 * <li>ComponentInstance</li>
 * <li>ComponentType</li>
 * <li>ComponentInstanceRole</li>
 * </ul>
 *
 */
public interface GateReference {

	Element getGate();

	NamedElement getGateType();
	
	GateTypeKind getGateTypeKind();

	Element getComponent();

	NamedElement getComponentType();

	ComponentInstanceRole getComponentRole();

}