/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.util;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LocaleUtil;

public final class SystemTimeUtils {
    public static Date getDate(byte[] data) {
        return SystemTimeUtils.getDate(data, 0);
    }

    public static Date getDate(byte[] data, int offset) {
        Calendar cal = LocaleUtil.getLocaleCalendar();
        cal.set(1, LittleEndian.getShort((byte[])data, (int)offset));
        cal.set(2, LittleEndian.getShort((byte[])data, (int)(offset + 2)) - 1);
        cal.set(5, LittleEndian.getShort((byte[])data, (int)(offset + 6)));
        cal.set(11, LittleEndian.getShort((byte[])data, (int)(offset + 8)));
        cal.set(12, LittleEndian.getShort((byte[])data, (int)(offset + 10)));
        cal.set(13, LittleEndian.getShort((byte[])data, (int)(offset + 12)));
        cal.set(14, LittleEndian.getShort((byte[])data, (int)(offset + 14)));
        return cal.getTime();
    }

    public static void storeDate(Date date, byte[] dest) {
        SystemTimeUtils.storeDate(date, dest, 0);
    }

    public static void storeDate(Date date, byte[] dest, int offset) {
        Calendar cal = LocaleUtil.getLocaleCalendar();
        cal.setTime(date);
        LittleEndian.putShort((byte[])dest, (int)(offset + 0), (short)((short)cal.get(1)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 2), (short)((short)(cal.get(2) + 1)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 4), (short)((short)(cal.get(7) - 1)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 6), (short)((short)cal.get(5)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 8), (short)((short)cal.get(11)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 10), (short)((short)cal.get(12)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 12), (short)((short)cal.get(13)));
        LittleEndian.putShort((byte[])dest, (int)(offset + 14), (short)((short)cal.get(14)));
    }
}

