package org.etsi.mts.tdl.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class TDLPerspectiveFactory implements IPerspectiveFactory {

	@Override
	public void createInitialLayout(IPageLayout layout) {
		// TODO Auto-generated method stub

        layout.addNewWizardShortcut("org.etsi.mts.tdl.ui.wizard.TDLtxNewProjectWizard");
        layout.addNewWizardShortcut("org.eclipse.xtext.ui.wizard.template.TemplateNewFileWizard");
        layout.addNewWizardShortcut("org.etsi.mts.tdl.graphical.viewpoint.projectWizard");
        
        
        layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
        layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
        layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);

        // Editors are placed for free.
        String editorArea = layout.getEditorArea();
        
        IFolderLayout nearLeft = layout.createFolder("nearLeft", IPageLayout.LEFT, 0.25f, editorArea);
        nearLeft.addView(IPageLayout.ID_PROJECT_EXPLORER);
        
        IFolderLayout explorerBottom = layout.createFolder("editorBottom", IPageLayout.BOTTOM, 0.55f, "nearLeft");
        explorerBottom.addView(IPageLayout.ID_OUTLINE);
        
        IFolderLayout editorBottom = layout.createFolder("editorBottom", IPageLayout.BOTTOM, 0.6f, editorArea);
        editorBottom.addView(IPageLayout.ID_PROP_SHEET);
        editorBottom.addView(IPageLayout.ID_PROBLEM_VIEW);
        
        /*
        layout.addNewWizardShortcut(PROJECT_WIZARD);
        layout.addShowViewShortcut(MODEL_VIEW);
        layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
        layout.addShowViewShortcut(IConsoleConstants.ID_CONSOLE_VIEW);

        // Editors are placed for free.
        String editorArea = layout.getEditorArea();
        
        IFolderLayout nearLeft = layout.createFolder("nearLeft", IPageLayout.LEFT, 0.55f, editorArea);
        nearLeft.addView(MODEL_VIEW);
        
        IFolderLayout farLeft = layout.createFolder("farLeft", IPageLayout.LEFT, 0.4f, "nearLeft");
        farLeft.addView(IPageLayout.ID_PROJECT_EXPLORER);
        
        IFolderLayout editorBottom = layout.createFolder("editorBottom", IPageLayout.BOTTOM, 0.6f, editorArea);
        editorBottom.addView(IPageLayout.ID_PROP_SHEET);
        editorBottom.addView(IPageLayout.ID_PROBLEM_VIEW);
        
        IFolderLayout nearBottom = layout.createFolder("nearBottom", IPageLayout.BOTTOM, 0.6f, "nearLeft");
        nearBottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
        */
	}

}
