package org.etsi.mts.tdl.openapi2tdl.next.doc;

import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class TSS extends OpenAPIVisitor  {

	@Override
	public void preamble(OpenAPI model) {
		content.append(String.format("\n## Test Suite Structure\n\n"));
		content.append(String.format("* API: %s\n", model.getInfo().getTitle()));
	}
	@Override
	public void path(String path) {
		String cleanPath = path.toUpperCase()
				.replaceAll("/", "")
				.replaceAll("[\\{\\}]", "_")
				.replaceAll("_$", "");
		content.append(String.format("  * %s\n", cleanPath));

	}

	@Override
	public void operation(String path, String method, Operation op) {
		content.append(String.format("    * %s\n", method.toUpperCase()));
		if (op.getResponses() != null) {
			for (String r : op.getResponses().keySet()) {
				content.append(String.format("      * %s\n", method+"_"+r));
			}
		}
	}

}
