package org.etsi.mts.tdl.openapi2tdl.next.doc;

import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class RQ extends OpenAPIVisitor  {
	int ri = 0;

	@Override
	public void preamble(OpenAPI model) {
		content.append(String.format("\n## Requirements\n"));
		content.append(String.format("\n### API: %s\n\n", model.getInfo().getTitle()));
		String header = 
				"| Identifier | Reference  | Type | Applicability | Requirement  | Context |\n" + 
				"| ---------- | ---------- | ---- | ------------- | ------------ | ------- |\n";
		content.append(header);
	}

	@Override
	public void path(String path) {
		ri = 0;

	}

	@Override
	public void operation(String path, String method, Operation op) {
		String cleanPath = path.toUpperCase()
				.replaceAll("/", "")
				.replaceAll("[\\{\\}]", "_")
				.replaceAll("_$", "");
		ri++;
		String id = "RQ_" + cleanPath + "_" + method
				+ "_" + String.format("%03d", ri);
		String reference = "Path: " + path;
		String type = "M";
		String applicability = cleanPath;
		String requirement = "";
		if (op.getSummary() != null) {
			requirement += op.getSummary() + "; ";
		}
		if (op.getDescription() != null) {
			requirement += op.getDescription();
		}
		String context = op.getOperationId();
		content.append(
				"| " + id + 
				" | " + reference + 
				" | " + type + 
				" | " + applicability + 
				" | " + requirement + 
				" | " + context + 
				" |\n");
	}

	@Override
	public void postamble(OpenAPI model) {
		String footer = 
				"\n[Table X.Y: Extracted requirements]{custom-style=\"FL\"}\n";
		content.append(footer);
	}
}
