package org.etsi.mts.tdl.openapi2tdl.next.doc;

import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class ICSMethod extends OpenAPIVisitor  {
	int ri = 0;
	private String level = "Method";

	@Override
	public void preamble(OpenAPI model) {
		content.append(String.format("\n#### %s\n\n", level));

		String header = 
				"| ID | Resource  | Reference | Method | Type  | Request | Response |\n" + 
				"| -- | --------- | --------- | ------ | ----- | ------- | -------- |\n";
		content.append(header);
	}

	@Override
	public void path(String path) {
	}

	@Override
	public void operation(String path, String method, Operation op) {
		String cleanPath = path
				.replaceAll("/", "")
				.replaceAll("[\\{\\}]", "_")
				.replaceAll("_$", "");
		ri++;
		String type = "M";
		String resource = path;
		String request = "(fill in request)";
		
		String oid = "M"+ri;

		String id = oid;
		
		String reference = "Path: "+path + " : "+op.getOperationId();
		String responses = String.join(",", op.getResponses().keySet());
		
		content.append(String.format(
				   "| " + id
				+ " | " + resource
				+ " | " + reference
				+ " | " + method
				+ " | " + type
				+ " | " + request
				+ " | " + responses
				+ " |\n"));
	}

	@Override
	public void postamble(OpenAPI model) {
		String footer = 
				"\n[Table X.Y: Extracted ICS ("+level+")]{custom-style=\"FL\"}\n";
		content.append(footer);
	}
}
