package org.etsi.mts.tdl.openapi2tdl.next;

import java.io.File;

import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.transform.AbstractTranslator;
import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.InlineModelResolver;
import org.etsi.mts.tdl.Package;

public class ConverterNext {

	public static void main(String[] args) throws Exception {
		String filename = args[0];
		process(filename, filename+"-generated-new.tdltx");
	}

	public static String processToString(String inputPath, String outputPath) {
		return processToString(inputPath, outputPath, "SOURCE_MAPPING", "TARGET_MAPPING");
	}

	public static String processToString(String inputPath, String outputPath, String sourceMapping, String targetMapping) {
		return processToString(inputPath, outputPath, sourceMapping, targetMapping, false);
	}
	
	public static String getTargetPackageName(String inputPath) {
		return AbstractTranslator.cleanName(new File(inputPath).getName());
	}
	
	public static String processToString(String inputPath, String outputPath, String sourceMapping, String targetMapping, boolean inline) {
//		OpenAPI spec = parseSpec(inputPath);
		System.out.println("Exporting: "+outputPath+ " : "+ new File(outputPath).getAbsolutePath());
		OpenAPI2TDLTranslatorNext translator = new OpenAPI2TDLTranslatorNext();
		String content = "Package imported {}";
		try {
			Resource tr = TDLHelper.create(outputPath);
			translator.setTargetResource(tr);
			translator.initTargetResource(getTargetPackageName(inputPath));
			translator.translate(inputPath, sourceMapping, targetMapping, inline);
			content = TDLHelper.getText(tr);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return content;
	}


	public static String process(String inputPath, String outputPath) {
		OpenAPI spec = parseSpec(inputPath);
		AbstractTranslator translator = new OpenAPI2TDLTranslatorNext();
		String name = "imported";
		try {
			Resource tr = TDLHelper.create(outputPath);
			translator.setTargetResource(tr);
			translator.initTargetResource(translator.getCleanName(new File(inputPath).getName()));
			translator.translate(inputPath);
			name = ((Package) tr.getContents().get(0)).getName();
			TDLHelper.store(tr, true);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return name;
	}

	
	
	/**
     * Helper method for parsing specs into an intermediary OpenAPI structure for pre-processing.
     *
     * Use this method only for tests targeting processing helpers such as {@link org.openapitools.codegen.utils.ModelUtils}
     * or {@link InlineModelResolver}. Using this for testing generators will mean you're not testing the OpenAPI document
     * in a state the generator will be presented at runtime.
     *
     * @param specFilePath The path to the specification file
     * @return A "raw" OpenAPI document
     */
    public static OpenAPI parseSpec(String specFilePath) {
        OpenAPI openAPI = new OpenAPIParser().readLocation(specFilePath, null, new ParseOptions()).getOpenAPI();
        // Invoke helper function to get the original swagger version.
        // See https://github.com/swagger-api/swagger-parser/pull/1374
        // Also see https://github.com/swagger-api/swagger-parser/issues/1369.
        ModelUtils.getOpenApiVersion(openAPI, specFilePath, null);
        
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(openAPI);
        return openAPI;
    }
}
