/**
 */
package org.etsi.mts.tdl.structuredobjectives.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.TestObjective;

import org.etsi.mts.tdl.structuredobjectives.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage
 * @generated
 */
public class StructuredObjectivesSwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static StructuredObjectivesPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StructuredObjectivesSwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = StructuredObjectivesPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
			case StructuredObjectivesPackage.ELEMENT:
			{
				Element element = (Element)theEObject;
				T result = caseElement(element);
				if (result == null) result = casetdl_Element(element);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.STRUCTURED_TEST_OBJECTIVE:
			{
				StructuredTestObjective structuredTestObjective = (StructuredTestObjective)theEObject;
				T result = caseStructuredTestObjective(structuredTestObjective);
				if (result == null) result = caseTestObjective(structuredTestObjective);
				if (result == null) result = caseElement(structuredTestObjective);
				if (result == null) result = casePackageableElement(structuredTestObjective);
				if (result == null) result = caseNamedElement(structuredTestObjective);
				if (result == null) result = casetdl_Element(structuredTestObjective);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.INITIAL_CONDITIONS:
			{
				InitialConditions initialConditions = (InitialConditions)theEObject;
				T result = caseInitialConditions(initialConditions);
				if (result == null) result = caseElement(initialConditions);
				if (result == null) result = casetdl_Element(initialConditions);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_SEQUENCE:
			{
				EventSequence eventSequence = (EventSequence)theEObject;
				T result = caseEventSequence(eventSequence);
				if (result == null) result = caseElement(eventSequence);
				if (result == null) result = casetdl_Element(eventSequence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_OCCURRENCE:
			{
				EventOccurrence eventOccurrence = (EventOccurrence)theEObject;
				T result = caseEventOccurrence(eventOccurrence);
				if (result == null) result = caseElement(eventOccurrence);
				if (result == null) result = casetdl_Element(eventOccurrence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EXPECTED_BEHAVIOUR:
			{
				ExpectedBehaviour expectedBehaviour = (ExpectedBehaviour)theEObject;
				T result = caseExpectedBehaviour(expectedBehaviour);
				if (result == null) result = caseElement(expectedBehaviour);
				if (result == null) result = casetdl_Element(expectedBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.FINAL_CONDITIONS:
			{
				FinalConditions finalConditions = (FinalConditions)theEObject;
				T result = caseFinalConditions(finalConditions);
				if (result == null) result = caseElement(finalConditions);
				if (result == null) result = casetdl_Element(finalConditions);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.PICS_REFERENCE:
			{
				PICSReference picsReference = (PICSReference)theEObject;
				T result = casePICSReference(picsReference);
				if (result == null) result = caseElement(picsReference);
				if (result == null) result = casetdl_Element(picsReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.PICS:
			{
				PICS pics = (PICS)theEObject;
				T result = casePICS(pics);
				if (result == null) result = casePackageableElement(pics);
				if (result == null) result = caseElement(pics);
				if (result == null) result = caseNamedElement(pics);
				if (result == null) result = casetdl_Element(pics);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.ENTITY:
			{
				Entity entity = (Entity)theEObject;
				T result = caseEntity(entity);
				if (result == null) result = casePackageableElement(entity);
				if (result == null) result = caseElement(entity);
				if (result == null) result = caseNamedElement(entity);
				if (result == null) result = casetdl_Element(entity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT:
			{
				Event event = (Event)theEObject;
				T result = caseEvent(event);
				if (result == null) result = casePackageableElement(event);
				if (result == null) result = caseElement(event);
				if (result == null) result = caseNamedElement(event);
				if (result == null) result = casetdl_Element(event);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_OCCURRENCE_SPECIFICATION:
			{
				EventOccurrenceSpecification eventOccurrenceSpecification = (EventOccurrenceSpecification)theEObject;
				T result = caseEventOccurrenceSpecification(eventOccurrenceSpecification);
				if (result == null) result = caseEventOccurrence(eventOccurrenceSpecification);
				if (result == null) result = caseElement(eventOccurrenceSpecification);
				if (result == null) result = casetdl_Element(eventOccurrenceSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.ENTITY_REFERENCE:
			{
				EntityReference entityReference = (EntityReference)theEObject;
				T result = caseEntityReference(entityReference);
				if (result == null) result = caseElement(entityReference);
				if (result == null) result = casetdl_Element(entityReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_REFERENCE:
			{
				EventReference eventReference = (EventReference)theEObject;
				T result = caseEventReference(eventReference);
				if (result == null) result = caseElement(eventReference);
				if (result == null) result = casetdl_Element(eventReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.VALUE:
			{
				Value value = (Value)theEObject;
				T result = caseValue(value);
				if (result == null) result = caseElement(value);
				if (result == null) result = casetdl_Element(value);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_ARGUMENT:
			{
				EventArgument eventArgument = (EventArgument)theEObject;
				T result = caseEventArgument(eventArgument);
				if (result == null) result = caseElement(eventArgument);
				if (result == null) result = casetdl_Element(eventArgument);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.DATA_REFERENCE:
			{
				DataReference dataReference = (DataReference)theEObject;
				T result = caseDataReference(dataReference);
				if (result == null) result = caseValue(dataReference);
				if (result == null) result = caseElement(dataReference);
				if (result == null) result = casetdl_Element(dataReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.CONTENT:
			{
				Content content = (Content)theEObject;
				T result = caseContent(content);
				if (result == null) result = caseElement(content);
				if (result == null) result = casetdl_Element(content);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.LITERAL_VALUE:
			{
				LiteralValue literalValue = (LiteralValue)theEObject;
				T result = caseLiteralValue(literalValue);
				if (result == null) result = caseValue(literalValue);
				if (result == null) result = caseElement(literalValue);
				if (result == null) result = casetdl_Element(literalValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.CONTENT_REFERENCE:
			{
				ContentReference contentReference = (ContentReference)theEObject;
				T result = caseContentReference(contentReference);
				if (result == null) result = caseValue(contentReference);
				if (result == null) result = caseElement(contentReference);
				if (result == null) result = casetdl_Element(contentReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.LITERAL_VALUE_REFERENCE:
			{
				LiteralValueReference literalValueReference = (LiteralValueReference)theEObject;
				T result = caseLiteralValueReference(literalValueReference);
				if (result == null) result = caseValue(literalValueReference);
				if (result == null) result = caseElement(literalValueReference);
				if (result == null) result = casetdl_Element(literalValueReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.REPEATED_EVENT_SEQUENCE:
			{
				RepeatedEventSequence repeatedEventSequence = (RepeatedEventSequence)theEObject;
				T result = caseRepeatedEventSequence(repeatedEventSequence);
				if (result == null) result = caseEventSequence(repeatedEventSequence);
				if (result == null) result = caseElement(repeatedEventSequence);
				if (result == null) result = casetdl_Element(repeatedEventSequence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_TEMPLATE_OCCURRENCE:
			{
				EventTemplateOccurrence eventTemplateOccurrence = (EventTemplateOccurrence)theEObject;
				T result = caseEventTemplateOccurrence(eventTemplateOccurrence);
				if (result == null) result = caseEventOccurrence(eventTemplateOccurrence);
				if (result == null) result = caseElement(eventTemplateOccurrence);
				if (result == null) result = casetdl_Element(eventTemplateOccurrence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.EVENT_SPECIFICATION_TEMPLATE:
			{
				EventSpecificationTemplate eventSpecificationTemplate = (EventSpecificationTemplate)theEObject;
				T result = caseEventSpecificationTemplate(eventSpecificationTemplate);
				if (result == null) result = casePackageableElement(eventSpecificationTemplate);
				if (result == null) result = caseElement(eventSpecificationTemplate);
				if (result == null) result = caseNamedElement(eventSpecificationTemplate);
				if (result == null) result = casetdl_Element(eventSpecificationTemplate);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.ENTITY_BINDING:
			{
				EntityBinding entityBinding = (EntityBinding)theEObject;
				T result = caseEntityBinding(entityBinding);
				if (result == null) result = caseElement(entityBinding);
				if (result == null) result = casetdl_Element(entityBinding);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.VARIANTS:
			{
				Variants variants = (Variants)theEObject;
				T result = caseVariants(variants);
				if (result == null) result = caseElement(variants);
				if (result == null) result = casetdl_Element(variants);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.TEST_OBJECTIVE_VARIANT:
			{
				TestObjectiveVariant testObjectiveVariant = (TestObjectiveVariant)theEObject;
				T result = caseTestObjectiveVariant(testObjectiveVariant);
				if (result == null) result = caseTestObjective(testObjectiveVariant);
				if (result == null) result = caseElement(testObjectiveVariant);
				if (result == null) result = casePackageableElement(testObjectiveVariant);
				if (result == null) result = caseNamedElement(testObjectiveVariant);
				if (result == null) result = casetdl_Element(testObjectiveVariant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case StructuredObjectivesPackage.VARIANT_BINDING:
			{
				VariantBinding variantBinding = (VariantBinding)theEObject;
				T result = caseVariantBinding(variantBinding);
				if (result == null) result = caseElement(variantBinding);
				if (result == null) result = casetdl_Element(variantBinding);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseElement(Element object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Structured Test Objective</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Structured Test Objective</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStructuredTestObjective(StructuredTestObjective object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Initial Conditions</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Initial Conditions</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInitialConditions(InitialConditions object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Sequence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Sequence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventSequence(EventSequence object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Occurrence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventOccurrence(EventOccurrence object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expected Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expected Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpectedBehaviour(ExpectedBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Final Conditions</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Final Conditions</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFinalConditions(FinalConditions object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PICS Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PICS Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePICSReference(PICSReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PICS</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PICS</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePICS(PICS object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEvent(Event object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Occurrence Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Occurrence Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventOccurrenceSpecification(EventOccurrenceSpecification object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntityReference(EntityReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventReference(EventReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseValue(Value object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Argument</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Argument</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventArgument(EventArgument object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataReference(DataReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Content</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Content</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContent(Content object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteralValue(LiteralValue object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Content Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Content Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContentReference(ContentReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Literal Value Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Literal Value Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteralValueReference(LiteralValueReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Repeated Event Sequence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Repeated Event Sequence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRepeatedEventSequence(RepeatedEventSequence object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Template Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Template Occurrence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventTemplateOccurrence(EventTemplateOccurrence object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Specification Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Specification Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventSpecificationTemplate(EventSpecificationTemplate object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity Binding</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity Binding</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntityBinding(EntityBinding object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variants</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variants</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariants(Variants object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Objective Variant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Objective Variant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestObjectiveVariant(TestObjectiveVariant object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variant Binding</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variant Binding</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariantBinding(VariantBinding object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casetdl_Element(org.etsi.mts.tdl.Element object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedElement(NamedElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Packageable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Packageable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePackageableElement(PackageableElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Objective</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Objective</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestObjective(TestObjective object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //StructuredObjectivesSwitch
