/**
 */
package org.etsi.mts.tdl.extendedconfigurations;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.etsi.mts.tdl.tdlPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedConfigurationsFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import tdl='tdl.ecore#/'"
 * @generated
 */
public interface ExtendedConfigurationsPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "extendedconfigurations";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.etsi.org/spec/TDL/1.3.1/configurations";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "configurations";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ExtendedConfigurationsPackage eINSTANCE = org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedTestConfigurationImpl <em>Extended Test Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedTestConfigurationImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getExtendedTestConfiguration()
	 * @generated
	 */
	int EXTENDED_TEST_CONFIGURATION = 0;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__COMMENT = tdlPackage.TEST_CONFIGURATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__ANNOTATION = tdlPackage.TEST_CONFIGURATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__NAME = tdlPackage.TEST_CONFIGURATION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__QUALIFIED_NAME = tdlPackage.TEST_CONFIGURATION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__COMPONENT_INSTANCE = tdlPackage.TEST_CONFIGURATION__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Connection</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__CONNECTION = tdlPackage.TEST_CONFIGURATION__CONNECTION;

	/**
	 * The feature id for the '<em><b>Configurations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__CONFIGURATIONS = tdlPackage.TEST_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION__OPERATIONS = tdlPackage.TEST_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Extended Test Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION_FEATURE_COUNT = tdlPackage.TEST_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___CONTAINER = tdlPackage.TEST_CONFIGURATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___GET_PARENT_TEST_DESCRIPTION = tdlPackage.TEST_CONFIGURATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___CONFORMS_TO__STRING = tdlPackage.TEST_CONFIGURATION___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___GET_ELEMENT_NAMED__STRING = tdlPackage.TEST_CONFIGURATION___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.TEST_CONFIGURATION___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Compatible With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION___COMPATIBLE_WITH__TESTCONFIGURATION_ELIST = tdlPackage.TEST_CONFIGURATION___COMPATIBLE_WITH__TESTCONFIGURATION_ELIST;

	/**
	 * The number of operations of the '<em>Extended Test Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_TEST_CONFIGURATION_OPERATION_COUNT = tdlPackage.TEST_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationInstanceImpl <em>Test Configuration Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationInstanceImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getTestConfigurationInstance()
	 * @generated
	 */
	int TEST_CONFIGURATION_INSTANCE = 1;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE__COMMENT = tdlPackage.ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE__ANNOTATION = tdlPackage.ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE__NAME = tdlPackage.ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE__CONFIGURATION = tdlPackage.ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Test Configuration Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE_FEATURE_COUNT = tdlPackage.ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE___CONTAINER = tdlPackage.ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE___GET_PARENT_TEST_DESCRIPTION = tdlPackage.ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Test Configuration Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_INSTANCE_OPERATION_COUNT = tdlPackage.ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationOperationImpl <em>Test Configuration Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationOperationImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getTestConfigurationOperation()
	 * @generated
	 */
	int TEST_CONFIGURATION_OPERATION = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION__COMMENT = tdlPackage.ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION__ANNOTATION = tdlPackage.ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION__NAME = tdlPackage.ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION__COMPONENT = tdlPackage.ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Test Configuration Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION_FEATURE_COUNT = tdlPackage.ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION___CONTAINER = tdlPackage.ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION___GET_PARENT_TEST_DESCRIPTION = tdlPackage.ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Test Configuration Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION_OPERATION_COUNT = tdlPackage.ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentReferenceImpl <em>Component Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentReferenceImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentReference()
	 * @generated
	 */
	int COMPONENT_REFERENCE = 3;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE__COMMENT = tdlPackage.ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE__ANNOTATION = tdlPackage.ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE__NAME = tdlPackage.ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE__COMPONENT = tdlPackage.ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE__CONFIGURATION = tdlPackage.ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE_FEATURE_COUNT = tdlPackage.ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE___CONTAINER = tdlPackage.ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE___GET_PARENT_TEST_DESCRIPTION = tdlPackage.ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REFERENCE_OPERATION_COUNT = tdlPackage.ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentMergeImpl <em>Component Merge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentMergeImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentMerge()
	 * @generated
	 */
	int COMPONENT_MERGE = 4;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE__COMMENT = TEST_CONFIGURATION_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE__ANNOTATION = TEST_CONFIGURATION_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE__NAME = TEST_CONFIGURATION_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE__COMPONENT = TEST_CONFIGURATION_OPERATION__COMPONENT;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE__TARGET = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Component Merge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE_FEATURE_COUNT = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE___CONTAINER = TEST_CONFIGURATION_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE___GET_PARENT_TEST_DESCRIPTION = TEST_CONFIGURATION_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Merge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_MERGE_OPERATION_COUNT = TEST_CONFIGURATION_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentHideImpl <em>Component Hide</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentHideImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentHide()
	 * @generated
	 */
	int COMPONENT_HIDE = 5;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE__COMMENT = TEST_CONFIGURATION_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE__ANNOTATION = TEST_CONFIGURATION_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE__NAME = TEST_CONFIGURATION_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE__COMPONENT = TEST_CONFIGURATION_OPERATION__COMPONENT;

	/**
	 * The number of structural features of the '<em>Component Hide</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE_FEATURE_COUNT = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE___CONTAINER = TEST_CONFIGURATION_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE___GET_PARENT_TEST_DESCRIPTION = TEST_CONFIGURATION_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Hide</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_HIDE_OPERATION_COUNT = TEST_CONFIGURATION_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ReassignRoleImpl <em>Reassign Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ReassignRoleImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getReassignRole()
	 * @generated
	 */
	int REASSIGN_ROLE = 6;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE__COMMENT = TEST_CONFIGURATION_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE__ANNOTATION = TEST_CONFIGURATION_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE__NAME = TEST_CONFIGURATION_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE__COMPONENT = TEST_CONFIGURATION_OPERATION__COMPONENT;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE__ROLE = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reassign Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE_FEATURE_COUNT = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE___CONTAINER = TEST_CONFIGURATION_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE___GET_PARENT_TEST_DESCRIPTION = TEST_CONFIGURATION_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Reassign Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REASSIGN_ROLE_OPERATION_COUNT = TEST_CONFIGURATION_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentAliasImpl <em>Component Alias</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentAliasImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentAlias()
	 * @generated
	 */
	int COMPONENT_ALIAS = 7;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS__COMMENT = TEST_CONFIGURATION_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS__ANNOTATION = TEST_CONFIGURATION_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS__NAME = TEST_CONFIGURATION_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS__COMPONENT = TEST_CONFIGURATION_OPERATION__COMPONENT;

	/**
	 * The number of structural features of the '<em>Component Alias</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS_FEATURE_COUNT = TEST_CONFIGURATION_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS___CONTAINER = TEST_CONFIGURATION_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS___GET_PARENT_TEST_DESCRIPTION = TEST_CONFIGURATION_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Alias</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ALIAS_OPERATION_COUNT = TEST_CONFIGURATION_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedGateReferenceImpl <em>Extended Gate Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedGateReferenceImpl
	 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getExtendedGateReference()
	 * @generated
	 */
	int EXTENDED_GATE_REFERENCE = 8;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__COMMENT = tdlPackage.GATE_REFERENCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__ANNOTATION = tdlPackage.GATE_REFERENCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__NAME = tdlPackage.GATE_REFERENCE__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__COMPONENT = tdlPackage.GATE_REFERENCE__COMPONENT;

	/**
	 * The feature id for the '<em><b>Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__GATE = tdlPackage.GATE_REFERENCE__GATE;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE__CONFIGURATION = tdlPackage.GATE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Extended Gate Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE_FEATURE_COUNT = tdlPackage.GATE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE___CONTAINER = tdlPackage.GATE_REFERENCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE___GET_PARENT_TEST_DESCRIPTION = tdlPackage.GATE_REFERENCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Extended Gate Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENDED_GATE_REFERENCE_OPERATION_COUNT = tdlPackage.GATE_REFERENCE_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration <em>Extended Test Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Extended Test Configuration</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration
	 * @generated
	 */
	EClass getExtendedTestConfiguration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Configurations</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration#getConfigurations()
	 * @see #getExtendedTestConfiguration()
	 * @generated
	 */
	EReference getExtendedTestConfiguration_Configurations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedTestConfiguration#getOperations()
	 * @see #getExtendedTestConfiguration()
	 * @generated
	 */
	EReference getExtendedTestConfiguration_Operations();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.TestConfigurationInstance <em>Test Configuration Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Configuration Instance</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.TestConfigurationInstance
	 * @generated
	 */
	EClass getTestConfigurationInstance();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.extendedconfigurations.TestConfigurationInstance#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Configuration</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.TestConfigurationInstance#getConfiguration()
	 * @see #getTestConfigurationInstance()
	 * @generated
	 */
	EReference getTestConfigurationInstance_Configuration();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.TestConfigurationOperation <em>Test Configuration Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Configuration Operation</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.TestConfigurationOperation
	 * @generated
	 */
	EClass getTestConfigurationOperation();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.extendedconfigurations.TestConfigurationOperation#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Component</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.TestConfigurationOperation#getComponent()
	 * @see #getTestConfigurationOperation()
	 * @generated
	 */
	EReference getTestConfigurationOperation_Component();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentReference <em>Component Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Reference</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentReference
	 * @generated
	 */
	EClass getComponentReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentReference#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentReference#getComponent()
	 * @see #getComponentReference()
	 * @generated
	 */
	EReference getComponentReference_Component();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentReference#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Configuration</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentReference#getConfiguration()
	 * @see #getComponentReference()
	 * @generated
	 */
	EReference getComponentReference_Configuration();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentMerge <em>Component Merge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Merge</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentMerge
	 * @generated
	 */
	EClass getComponentMerge();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentMerge#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentMerge#getTarget()
	 * @see #getComponentMerge()
	 * @generated
	 */
	EReference getComponentMerge_Target();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentHide <em>Component Hide</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Hide</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentHide
	 * @generated
	 */
	EClass getComponentHide();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ReassignRole <em>Reassign Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reassign Role</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ReassignRole
	 * @generated
	 */
	EClass getReassignRole();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.extendedconfigurations.ReassignRole#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ReassignRole#getRole()
	 * @see #getReassignRole()
	 * @generated
	 */
	EAttribute getReassignRole_Role();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ComponentAlias <em>Component Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Alias</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ComponentAlias
	 * @generated
	 */
	EClass getComponentAlias();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.extendedconfigurations.ExtendedGateReference <em>Extended Gate Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Extended Gate Reference</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedGateReference
	 * @generated
	 */
	EClass getExtendedGateReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.extendedconfigurations.ExtendedGateReference#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Configuration</em>'.
	 * @see org.etsi.mts.tdl.extendedconfigurations.ExtendedGateReference#getConfiguration()
	 * @see #getExtendedGateReference()
	 * @generated
	 */
	EReference getExtendedGateReference_Configuration();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ExtendedConfigurationsFactory getExtendedConfigurationsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedTestConfigurationImpl <em>Extended Test Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedTestConfigurationImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getExtendedTestConfiguration()
		 * @generated
		 */
		EClass EXTENDED_TEST_CONFIGURATION = eINSTANCE.getExtendedTestConfiguration();

		/**
		 * The meta object literal for the '<em><b>Configurations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTENDED_TEST_CONFIGURATION__CONFIGURATIONS = eINSTANCE.getExtendedTestConfiguration_Configurations();

		/**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTENDED_TEST_CONFIGURATION__OPERATIONS = eINSTANCE.getExtendedTestConfiguration_Operations();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationInstanceImpl <em>Test Configuration Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationInstanceImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getTestConfigurationInstance()
		 * @generated
		 */
		EClass TEST_CONFIGURATION_INSTANCE = eINSTANCE.getTestConfigurationInstance();

		/**
		 * The meta object literal for the '<em><b>Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_CONFIGURATION_INSTANCE__CONFIGURATION = eINSTANCE.getTestConfigurationInstance_Configuration();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationOperationImpl <em>Test Configuration Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.TestConfigurationOperationImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getTestConfigurationOperation()
		 * @generated
		 */
		EClass TEST_CONFIGURATION_OPERATION = eINSTANCE.getTestConfigurationOperation();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_CONFIGURATION_OPERATION__COMPONENT = eINSTANCE.getTestConfigurationOperation_Component();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentReferenceImpl <em>Component Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentReferenceImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentReference()
		 * @generated
		 */
		EClass COMPONENT_REFERENCE = eINSTANCE.getComponentReference();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_REFERENCE__COMPONENT = eINSTANCE.getComponentReference_Component();

		/**
		 * The meta object literal for the '<em><b>Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_REFERENCE__CONFIGURATION = eINSTANCE.getComponentReference_Configuration();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentMergeImpl <em>Component Merge</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentMergeImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentMerge()
		 * @generated
		 */
		EClass COMPONENT_MERGE = eINSTANCE.getComponentMerge();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_MERGE__TARGET = eINSTANCE.getComponentMerge_Target();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentHideImpl <em>Component Hide</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentHideImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentHide()
		 * @generated
		 */
		EClass COMPONENT_HIDE = eINSTANCE.getComponentHide();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ReassignRoleImpl <em>Reassign Role</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ReassignRoleImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getReassignRole()
		 * @generated
		 */
		EClass REASSIGN_ROLE = eINSTANCE.getReassignRole();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REASSIGN_ROLE__ROLE = eINSTANCE.getReassignRole_Role();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ComponentAliasImpl <em>Component Alias</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ComponentAliasImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getComponentAlias()
		 * @generated
		 */
		EClass COMPONENT_ALIAS = eINSTANCE.getComponentAlias();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedGateReferenceImpl <em>Extended Gate Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedGateReferenceImpl
		 * @see org.etsi.mts.tdl.extendedconfigurations.impl.ExtendedConfigurationsPackageImpl#getExtendedGateReference()
		 * @generated
		 */
		EClass EXTENDED_GATE_REFERENCE = eINSTANCE.getExtendedGateReference();

		/**
		 * The meta object literal for the '<em><b>Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTENDED_GATE_REFERENCE__CONFIGURATION = eINSTANCE.getExtendedGateReference_Configuration();

	}

} //ExtendedConfigurationsPackage
