package org.etsi.mts.tdl.execution.java.tri;

/**
 * Interface for providing environment specific test logging functionality.
 */
public interface Reporter {
	/**
	 * Log comments as specified in TDL model. Comments are logged before the
	 * execution of the associated element.
	 */
	void comment(String body);

	/**
	 * Log test objective associated with a behaviour element as specified in TDL
	 * model. Test objectives are logged after the execution of the associated
	 * behaviour.
	 * 
	 * @param uri         URI of the objective.
	 * @param description Description of the objective.
	 */
	void testObjectiveReached(String uri, String description);

	/**
	 * Log the start of a behaviour execution.
	 * 
	 * @param kind       Name of behaviour element meta-class as specified in TDL.
	 * @param id         Locally unique identifier of the behaviour element (to be
	 *                   matched with {@link #behaviourCompleted(String)
	 *                   behaviourCompleted()}).
	 * @param properties Any behaviour specific properties.
	 */
	void behaviourStarted(String kind, String id, Object... properties);

	/**
	 * Log the completion of a behaviour execution.
	 * 
	 * @param id Locally unique identifier of the behaviour element (to be matched
	 *           with {@link #behaviourStarted(String, String, Object...)
	 *           behaviourStarted()}).
	 */
	void behaviourCompleted(String id);

	/**
	 * Log a runtime error. Runtime errors result in the termination of test
	 * execution. Note that it is not the responsibility of the logger to handle the
	 * errors in any way except logging them.
	 * 
	 * @param t The exception that was thrown by the execution engine or any of the
	 *          adapters.
	 */
	void runtimeError(Throwable t);
}
