package org.etsi.mts.tdl.scoping;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.NamedElement;

public class TdlQualifiedNameProvider extends DefaultDeclarativeQualifiedNameProvider {
	@Override
	public QualifiedName getFullyQualifiedName(EObject obj) {
		if (obj instanceof NamedElement) {
			String qNameStr = ((NamedElement) obj).getQualifiedName();
			QualifiedName qName = QualifiedName.create(qNameStr.split("::"));
			return qName;
			
		} else if (obj instanceof Element) {
			String name = ((Element) obj).getName();
			if (name != null)
				return QualifiedName.create(name);
		}
		return super.getFullyQualifiedName(obj);
	}
}
