/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.poi.common.usermodel.fonts.FontGroup;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.PresetColor;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LayoutMode;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFManualLayout;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.text.UnderlineType;
import org.apache.poi.xddf.usermodel.text.XDDFFont;
import org.apache.poi.xddf.usermodel.text.XDDFRunProperties;
import org.apache.poi.xddf.usermodel.text.XDDFTextParagraph;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BarAndLineChart {
    private static final int NUM_OF_ROWS = 7;
    private static final Random RNG = new Random();

    public static void main(String[] args) throws Exception {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XSSFSheet sheet = wb.createSheet("Sheet1");
            XSSFRow row = sheet.createRow(0);
            row.createCell(0);
            row.createCell(1).setCellValue("Bars");
            row.createCell(2).setCellValue("Lines");
            for (int r = 1; r < 7; ++r) {
                row = sheet.createRow(r);
                XSSFCell cell = row.createCell(0);
                cell.setCellValue("C" + r);
                cell = row.createCell(1);
                cell.setCellValue(RNG.nextDouble());
                cell = row.createCell(2);
                cell.setCellValue(RNG.nextDouble() * 10.0);
            }
            XSSFDrawing drawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 4, 0, 11, 15);
            XSSFChart chart = drawing.createChart(anchor);
            chart.setTitleText("This is my title");
            chart.setTitleOverlay(true);
            XDDFRunProperties properties = new XDDFRunProperties();
            properties.setBold(Boolean.valueOf(true));
            properties.setItalic(Boolean.valueOf(true));
            properties.setUnderline(UnderlineType.DOT_DOT_DASH_HEAVY);
            properties.setFontSize(Double.valueOf(22.5));
            XDDFFont[] fonts = new XDDFFont[]{new XDDFFont(FontGroup.LATIN, "Calibri", null, null, null), new XDDFFont(FontGroup.COMPLEX_SCRIPT, "Liberation Sans", null, null, null)};
            properties.setFonts(fonts);
            properties.setLineProperties(BarAndLineChart.solidLine(PresetColor.SIENNA));
            XDDFTextParagraph paragraph = chart.getTitle().getBody().getParagraph(0);
            paragraph.setDefaultRunProperties(properties);
            XDDFCategoryDataSource xs = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 6, 0, 0));
            XDDFNumericalDataSource ys1 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 6, 1, 1));
            XDDFNumericalDataSource ys2 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 6, 2, 2));
            XDDFCategoryAxis barCategories = chart.createCategoryAxis(AxisPosition.BOTTOM);
            XDDFValueAxis leftValues = chart.createValueAxis(AxisPosition.LEFT);
            leftValues.crossAxis((XDDFChartAxis)barCategories);
            barCategories.crossAxis((XDDFChartAxis)leftValues);
            XDDFCategoryAxis lineCategories = chart.createCategoryAxis(AxisPosition.BOTTOM);
            lineCategories.setVisible(false);
            XDDFValueAxis rightValues = chart.createValueAxis(AxisPosition.RIGHT);
            rightValues.setCrosses(AxisCrosses.MAX);
            rightValues.crossAxis((XDDFChartAxis)lineCategories);
            lineCategories.crossAxis((XDDFChartAxis)rightValues);
            XDDFBarChartData bar = (XDDFBarChartData)chart.createData(ChartTypes.BAR, (XDDFChartAxis)lineCategories, rightValues);
            XDDFBarChartData.Series series1 = (XDDFBarChartData.Series)bar.addSeries((XDDFDataSource)xs, ys1);
            series1.setTitle("Bars", new CellReference("Sheet1!$B$1"));
            bar.setVaryColors(true);
            bar.setBarDirection(BarDirection.COL);
            chart.plot((XDDFChartData)bar);
            XDDFLineChartData lines = (XDDFLineChartData)chart.createData(ChartTypes.LINE, (XDDFChartAxis)lineCategories, rightValues);
            XDDFLineChartData.Series series2 = (XDDFLineChartData.Series)lines.addSeries((XDDFDataSource)xs, ys2);
            series2.setTitle("Lines", new CellReference("Sheet1!$C$1"));
            lines.setVaryColors(true);
            chart.plot((XDDFChartData)lines);
            BarAndLineChart.solidFillSeries((XDDFChartData)bar, 0, PresetColor.CHARTREUSE);
            BarAndLineChart.solidLineSeries((XDDFChartData)lines, 0, PresetColor.TURQUOISE);
            XDDFChartLegend legend = chart.getOrAddLegend();
            legend.setPosition(LegendPosition.LEFT);
            legend.setOverlay(false);
            XDDFManualLayout layout = legend.getOrAddManualLayout();
            layout.setXMode(LayoutMode.EDGE);
            layout.setYMode(LayoutMode.EDGE);
            layout.setX(0.0);
            layout.setY(0.25);
            try (FileOutputStream fileOut = new FileOutputStream("BarAndLineChart.xlsx");){
                wb.write((OutputStream)fileOut);
            }
        }
    }

    private static void solidFillSeries(XDDFChartData data, int index, PresetColor color) {
        XDDFSolidFillProperties fill = new XDDFSolidFillProperties(XDDFColor.from((PresetColor)color));
        XDDFChartData.Series series = (XDDFChartData.Series)data.getSeries().get(index);
        XDDFShapeProperties properties = series.getShapeProperties();
        if (properties == null) {
            properties = new XDDFShapeProperties();
        }
        properties.setFillProperties((XDDFFillProperties)fill);
        series.setShapeProperties(properties);
    }

    private static void solidLineSeries(XDDFChartData data, int index, PresetColor color) {
        XDDFLineProperties line = BarAndLineChart.solidLine(color);
        XDDFChartData.Series series = (XDDFChartData.Series)data.getSeries().get(index);
        XDDFShapeProperties properties = series.getShapeProperties();
        if (properties == null) {
            properties = new XDDFShapeProperties();
        }
        properties.setLineProperties(line);
        series.setShapeProperties(properties);
    }

    private static XDDFLineProperties solidLine(PresetColor color) {
        XDDFSolidFillProperties fill = new XDDFSolidFillProperties(XDDFColor.from((PresetColor)color));
        XDDFLineProperties line = new XDDFLineProperties();
        line.setFillProperties((XDDFFillProperties)fill);
        return line;
    }
}

