/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.structure;

import java.math.BigInteger;
import org.docx4j.Docx4jProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.MarginsWellKnown;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDimensions {
    protected static Logger log = LoggerFactory.getLogger(PageDimensions.class);
    private SectPr.PgSz pgSz;
    private SectPr.PgMar pgMar;

    public PageDimensions() {
        this.pgSz = Context.getWmlObjectFactory().createSectPrPgSz();
        this.setPgSize();
        this.pgMar = Context.getWmlObjectFactory().createSectPrPgMar();
        this.setMargins();
    }

    public PageDimensions(SectPr.PgSz pgSz, SectPr.PgMar pgMar) {
        this.init(pgSz, pgMar);
    }

    public PageDimensions(SectPr sectPr) {
        if (sectPr == null) {
            this.init(null, null);
        } else {
            this.init(sectPr.getPgSz(), sectPr.getPgMar());
        }
    }

    private void init(SectPr.PgSz pgSz, SectPr.PgMar pgMar) {
        if (pgSz == null) {
            log.warn("No pgSz in this section; defaulting.");
            this.pgSz = Context.getWmlObjectFactory().createSectPrPgSz();
            this.setPgSize();
        } else {
            this.pgSz = pgSz;
        }
        if (pgMar == null) {
            log.warn("No pgMar in this section; defaulting.");
            this.pgMar = Context.getWmlObjectFactory().createSectPrPgMar();
            this.setMargins();
        } else {
            this.pgMar = pgMar;
        }
    }

    public SectPr.PgSz getPgSz() {
        return this.pgSz;
    }

    public void setPgSz(SectPr.PgSz pgSz) {
        this.pgSz = pgSz;
    }

    @Deprecated
    public SectPr.PgSz createPgSize() {
        return this.pgSz;
    }

    public SectPr.PgMar getPgMar() {
        return this.pgMar;
    }

    public void setPgMar(SectPr.PgMar pgMar) {
        this.pgMar = pgMar;
    }

    @Deprecated
    public SectPr.PgMar createPgMar() {
        return this.pgMar;
    }

    public void setMargins() {
        String margin = Docx4jProperties.getProperties().getProperty("docx4j.PageMargins", "NORMAL");
        this.setMargins(MarginsWellKnown.valueOf(margin));
    }

    public void setMargins(MarginsWellKnown m) {
        if (m.equals((Object)MarginsWellKnown.NORMAL)) {
            this.pgMar.setTop(BigInteger.valueOf(1440L));
            this.pgMar.setBottom(BigInteger.valueOf(1440L));
            this.pgMar.setLeft(BigInteger.valueOf(1440L));
            this.pgMar.setRight(BigInteger.valueOf(1440L));
            return;
        }
        if (m.equals((Object)MarginsWellKnown.NARROW)) {
            this.pgMar.setTop(BigInteger.valueOf(720L));
            this.pgMar.setBottom(BigInteger.valueOf(720L));
            this.pgMar.setLeft(BigInteger.valueOf(720L));
            this.pgMar.setRight(BigInteger.valueOf(720L));
            return;
        }
        if (m.equals((Object)MarginsWellKnown.MODERATE)) {
            this.pgMar.setTop(BigInteger.valueOf(1440L));
            this.pgMar.setBottom(BigInteger.valueOf(1440L));
            this.pgMar.setLeft(BigInteger.valueOf(1080L));
            this.pgMar.setRight(BigInteger.valueOf(1080L));
            return;
        }
        if (m.equals((Object)MarginsWellKnown.WIDE)) {
            this.pgMar.setTop(BigInteger.valueOf(1440L));
            this.pgMar.setBottom(BigInteger.valueOf(1440L));
            this.pgMar.setLeft(BigInteger.valueOf(2880L));
            this.pgMar.setRight(BigInteger.valueOf(2880L));
            return;
        }
    }

    public void setPgSize() {
        String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
        log.info("Using paper size: " + papersize);
        String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
        boolean landscape = Boolean.parseBoolean(landscapeString);
        log.info("Landscape orientation: " + landscape);
        this.setPgSize(PageSizePaper.valueOf(papersize), landscape);
    }

    public void setPgSize(PageSizePaper sz, boolean landscape) {
        if (sz.equals((Object)PageSizePaper.LETTER)) {
            this.pgSz.setCode(BigInteger.valueOf(1L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(15840L));
                this.pgSz.setH(BigInteger.valueOf(12240L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(12240L));
                this.pgSz.setH(BigInteger.valueOf(15840L));
            }
        } else if (sz.equals((Object)PageSizePaper.LEGAL)) {
            this.pgSz.setCode(BigInteger.valueOf(5L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(20160L));
                this.pgSz.setH(BigInteger.valueOf(12240L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(12240L));
                this.pgSz.setH(BigInteger.valueOf(20160L));
            }
        } else if (sz.equals((Object)PageSizePaper.A3)) {
            this.pgSz.setCode(BigInteger.valueOf(8L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(23814L));
                this.pgSz.setH(BigInteger.valueOf(16839L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(16839L));
                this.pgSz.setH(BigInteger.valueOf(23814L));
            }
        } else if (sz.equals((Object)PageSizePaper.A4)) {
            this.pgSz.setCode(BigInteger.valueOf(9L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(16839L));
                this.pgSz.setH(BigInteger.valueOf(11907L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(11907L));
                this.pgSz.setH(BigInteger.valueOf(16839L));
            }
        } else if (sz.equals((Object)PageSizePaper.A5)) {
            this.pgSz.setCode(BigInteger.valueOf(11L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(11907L));
                this.pgSz.setH(BigInteger.valueOf(8391L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(8391L));
                this.pgSz.setH(BigInteger.valueOf(11907L));
            }
        } else if (sz.equals((Object)PageSizePaper.B4JIS)) {
            this.pgSz.setCode(BigInteger.valueOf(12L));
            if (landscape) {
                this.pgSz.setOrient(STPageOrientation.LANDSCAPE);
                this.pgSz.setW(BigInteger.valueOf(20639L));
                this.pgSz.setH(BigInteger.valueOf(14572L));
            } else {
                this.pgSz.setW(BigInteger.valueOf(14572L));
                this.pgSz.setH(BigInteger.valueOf(20639L));
            }
        }
    }

    public int getWritableWidthTwips() {
        int gutter = 0;
        if (this.pgMar.getGutter() != null) {
            gutter = this.pgMar.getGutter().intValue();
        }
        return this.pgSz.getW().intValue() - (gutter + this.pgMar.getLeft().intValue() + this.pgMar.getRight().intValue());
    }

    @Deprecated
    public int getWritableHeightTwips() {
        return this.pgSz.getH().intValue() - (this.pgMar.getTop().intValue() + this.pgMar.getBottom().intValue());
    }

    public int getHeaderMargin() {
        if (this.pgMar.getHeader() == null) {
            return 720;
        }
        return this.pgMar.getHeader().intValue();
    }

    public int getFooterMargin() {
        if (this.pgMar.getFooter() == null) {
            return 720;
        }
        return this.pgMar.getFooter().intValue();
    }
}

