/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.foray.font.format.Panose;

public class EmbedFontInfo
implements Serializable {
    private static final long serialVersionUID = 8755432068669997368L;
    protected Set familyNames;
    protected String metricsFile;
    protected String embedFile;
    protected boolean kerning;
    protected EncodingMode encodingMode = EncodingMode.AUTO;
    protected String postScriptName = null;
    protected String subFontName = null;
    private List fontTriplets = null;
    private transient boolean embedded = true;
    private boolean isEmbeddable = true;
    protected Panose panose = null;

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public void setEmbeddable(boolean isEmbeddable) {
        this.isEmbeddable = isEmbeddable;
    }

    public Panose getPanose() {
        return this.panose;
    }

    public void setPanose(Panose panose) {
        this.panose = panose;
    }

    public EmbedFontInfo(String metricsFile, boolean kerning, List fontTriplets, String embedFile, String subFontName) {
        this.metricsFile = metricsFile;
        this.embedFile = embedFile;
        this.kerning = kerning;
        this.fontTriplets = fontTriplets;
        this.subFontName = subFontName;
    }

    public String getMetricsFile() {
        return this.metricsFile;
    }

    public String getEmbedFile() {
        return this.embedFile;
    }

    public boolean getKerning() {
        return this.kerning;
    }

    public String getSubFontName() {
        return this.subFontName;
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public void setPostScriptName(String postScriptName) {
        this.postScriptName = postScriptName;
    }

    public List getFontTriplets() {
        return this.fontTriplets;
    }

    public boolean isEmbedded() {
        if (this.metricsFile != null && this.embedFile == null) {
            return false;
        }
        return this.embedded;
    }

    public void setEmbedded(boolean value) {
        this.embedded = value;
    }

    public EncodingMode getEncodingMode() {
        return this.encodingMode;
    }

    public void setEncodingMode(EncodingMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        this.encodingMode = mode;
    }

    public Set getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(Set familyNames) {
        this.familyNames = familyNames;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.embedded = true;
    }

    public String toString() {
        return "metrics-url=" + this.metricsFile + ", embed-url=" + this.embedFile + ", kerning=" + this.kerning + ", enc-mode=" + this.encodingMode + ", font-triplet=" + this.fontTriplets + (this.getSubFontName() != null ? ", sub-font=" + this.getSubFontName() : "") + (this.isEmbedded() ? "" : ", NOT embedded");
    }
}

