/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverPageSectPrMover {
    private static Logger log = LoggerFactory.getLogger(CoverPageSectPrMover.class);

    public static void process(WordprocessingMLPackage wmlPackage) {
        Body body = ((Document)wmlPackage.getMainDocumentPart().getJaxbElement()).getBody();
        CoverPageSectPrMover.moveSectPr(body);
    }

    private static void moveSectPr(Body body) {
        SectPr sectPr;
        Object o2;
        if (body == null || body.getContent().size() == 0) {
            log.warn("w:document/w:body null or empty");
            return;
        }
        Object o = body.getContent().get(0);
        if (o instanceof P) {
            SectPr sectPr2 = CoverPageSectPrMover.cutSectPr((P)o);
            if (sectPr2 != null) {
                CoverPageSectPrMover.pasteSectPr(body.getContent(), sectPr2);
                log.info("Moved sectPr to new P");
                return;
            }
        } else if (o instanceof SdtElement && (o2 = ((SdtElement)o).getSdtContent().getContent().get(0)) != null && o2 instanceof P && (sectPr = CoverPageSectPrMover.cutSectPr((P)o2)) != null) {
            CoverPageSectPrMover.pasteSectPr(((SdtElement)o).getSdtContent().getContent(), sectPr);
            log.info("Moved sectPr to new P inside content control");
            return;
        }
        log.info("No need to move sectPr ");
    }

    private static SectPr cutSectPr(P p) {
        if (p.getPPr() != null && p.getPPr().getSectPr() != null) {
            SectPr sectPr = p.getPPr().getSectPr();
            p.getPPr().setSectPr(null);
            return sectPr;
        }
        return null;
    }

    private static void pasteSectPr(List<Object> contentList, SectPr sectPr) {
        P p = new P();
        PPr ppr = Context.getWmlObjectFactory().createPPr();
        p.setPPr(ppr);
        ppr.setSectPr(sectPr);
        contentList.add(1, p);
    }
}

