/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.engio.mbassy.bus.MBassador;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.convert.out.fo.FOExporterVisitor;
import org.docx4j.convert.out.fo.FOExporterXslt;
import org.docx4j.convert.out.html.HTMLExporterVisitor;
import org.docx4j.convert.out.html.HTMLExporterXslt;
import org.docx4j.events.Docx4jEvent;
import org.docx4j.events.EventFinished;
import org.docx4j.events.PackageIdentifier;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownJobTypes;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Docx4J {
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_FO = "application/xml-fo";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_EXPORT_PREFER_XSL = 1;
    public static final int FLAG_EXPORT_PREFER_NONXSL = 2;
    public static final int FLAG_SAVE_ZIP_FILE = 1;
    public static final int FLAG_SAVE_FLAT_XML = 2;
    public static final int FLAG_BIND_INSERT_XML = 1;
    public static final int FLAG_BIND_BIND_XML = 2;
    public static final int FLAG_BIND_REMOVE_SDT = 4;
    public static final int FLAG_BIND_REMOVE_XML = 8;
    private static MBassador<Docx4jEvent> bus;
    protected static final String NS_CONDITIONS = "http://opendope.org/conditions";
    protected static final String NS_XPATHS = "http://opendope.org/xpaths";
    protected static final String NS_QUESTIONS = "http://opendope.org/questions";
    protected static final String NS_COMPONENTS = "http://opendope.org/components";
    protected static final Set<String> PART_TO_REMOVE_SCHEMA_TYPES;

    public static void setEventNotifier(MBassador<Docx4jEvent> eventbus) {
        bus = eventbus;
    }

    public static WordprocessingMLPackage load(File inFile) throws Docx4JException {
        return WordprocessingMLPackage.load(inFile);
    }

    public static WordprocessingMLPackage load(PackageIdentifier pkgIdentifier, File inFile) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(pkgIdentifier, inFile);
    }

    public static WordprocessingMLPackage load(InputStream inStream) throws Docx4JException {
        return WordprocessingMLPackage.load(inStream);
    }

    public static WordprocessingMLPackage load(PackageIdentifier pkgIdentifier, InputStream inStream) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(pkgIdentifier, inStream);
    }

    public static void save(WordprocessingMLPackage wmlPackage, File outFile, int flags) throws Docx4JException {
        wmlPackage.save(outFile, flags);
    }

    public static void save(WordprocessingMLPackage wmlPackage, OutputStream outStream, int flags) throws Docx4JException {
        wmlPackage.save(outStream, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, String xmlDocument, int flags) throws Docx4JException {
        ByteArrayInputStream xmlStream = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((flags & 1) == 1) {
            try {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes());
            }
        }
        Docx4J.bind(wmlPackage, xmlStream, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, InputStream xmlDocument, int flags) throws Docx4JException {
        StartEvent bindJobStartEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage);
        bindJobStartEvent.publish();
        if (flags == 0) {
            flags = 15;
        }
        Document xmlDoc = null;
        if ((flags & 1) == 1) {
            try {
                xmlDoc = XmlUtils.getNewDocumentBuilder().parse(xmlDocument);
            }
            catch (Exception e) {
                throw new Docx4JException("Problems creating a org.w3c.dom.Document for the passed input stream.", e);
            }
        }
        Docx4J.bind(wmlPackage, xmlDoc, flags);
        new EventFinished(bindJobStartEvent).publish();
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Document xmlDocument, int flags) throws Docx4JException {
        StartEvent startEvent;
        OpenDoPEHandler openDoPEHandler = null;
        CustomXmlDataStoragePart customXmlDataStoragePart = null;
        Object removalHandler = null;
        AtomicInteger bookmarkId = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((customXmlDataStoragePart = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart(wmlPackage)) == null) {
            throw new Docx4JException("Couldn't find CustomXmlDataStoragePart! exiting..");
        }
        if ((flags & 1) == 1) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_INSERT_XML);
            startEvent.publish();
            Docx4J.insertXMLData(customXmlDataStoragePart, xmlDocument);
            new EventFinished(startEvent).publish();
        }
        if ((flags & 2) == 2) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML);
            startEvent.publish();
            if (wmlPackage.getMainDocumentPart().getXPathsPart() != null) {
                openDoPEHandler = new OpenDoPEHandler(wmlPackage);
                openDoPEHandler.preprocess();
                bookmarkId = openDoPEHandler.getNextBookmarkId();
            }
            BindingHandler bh = new BindingHandler(wmlPackage);
            bh.setStartingIdForNewBookmarks(bookmarkId);
            bh.applyBindings();
            new EventFinished(startEvent).publish();
        }
        if ((flags & 4) == 4) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_REMOVE_SDT);
            startEvent.publish();
            Docx4J.removeSDTs(wmlPackage);
            new EventFinished(startEvent).publish();
        }
        if ((flags & 8) == 8) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_REMOVE_XML);
            startEvent.publish();
            Docx4J.removeDefinedCustomXmlParts(wmlPackage, customXmlDataStoragePart);
            new EventFinished(startEvent).publish();
        }
    }

    protected static void insertXMLData(CustomXmlDataStoragePart customXmlDataStoragePart, Document xmlDocument) throws Docx4JException {
        customXmlDataStoragePart.getData().setDocument(xmlDocument);
    }

    protected static String findXPathStorageItemIdInContentControls(WordprocessingMLPackage wmlPackage) {
        FindContentControlsVisitor visitor = null;
        if (wmlPackage.getCustomXmlDataStorageParts() != null && !wmlPackage.getCustomXmlDataStorageParts().isEmpty()) {
            try {
                visitor = new FindContentControlsVisitor(wmlPackage.getCustomXmlDataStorageParts().keySet());
                TraversalUtil.visit(wmlPackage, false, visitor);
            }
            catch (FindContentControlsVisitor.BreakException breakException) {
                // empty catch block
            }
        }
        return visitor != null ? visitor.getdefinedStoreItemId() : null;
    }

    protected static void removeSDTs(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        RemovalHandler removalHandler = new RemovalHandler();
        removalHandler.removeSDTs(wmlPackage.getMainDocumentPart(), RemovalHandler.Quantifier.ALL, (String[])null);
        for (Part part : wmlPackage.getParts().getParts().values()) {
            if (part instanceof HeaderPart) {
                removalHandler.removeSDTs((HeaderPart)part, RemovalHandler.Quantifier.ALL, (String[])null);
                continue;
            }
            if (!(part instanceof FooterPart)) continue;
            removalHandler.removeSDTs((FooterPart)part, RemovalHandler.Quantifier.ALL, (String[])null);
        }
    }

    protected static void removeDefinedCustomXmlParts(WordprocessingMLPackage wmlPackage, CustomXmlDataStoragePart customXmlDataStoragePart) {
        ArrayList<PartName> partsToRemove = new ArrayList<PartName>();
        RelationshipsPart relationshipsPart = wmlPackage.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> relationshipsList = relationshipsPart != null && relationshipsPart.getRelationships() != null ? relationshipsPart.getRelationships().getRelationship() : null;
        Part part = null;
        if (relationshipsList != null) {
            for (Relationship relationship : relationshipsList) {
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml".equals(relationship.getType()) || (part = relationshipsPart.getPart(relationship)) != customXmlDataStoragePart) continue;
                partsToRemove.add(part.getPartName());
            }
        }
        if (!partsToRemove.isEmpty()) {
            for (int i = 0; i < partsToRemove.size(); ++i) {
                relationshipsPart.removePart((PartName)partsToRemove.get(i));
            }
        }
    }

    public static WordprocessingMLPackage clone(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        return (WordprocessingMLPackage)PartialDeepCopy.process(wmlPackage, null);
    }

    public static FOSettings createFOSettings() {
        return new FOSettings();
    }

    public static void toFO(FOSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        Exporter<FOSettings> exporter = Docx4J.getFOExporter(flags);
        exporter.export(settings, outputStream);
    }

    public static void toPDF(WordprocessingMLPackage wmlPackage, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(wmlPackage, WellKnownProcessSteps.PDF);
        startEvent.publish();
        FOSettings settings = Docx4J.createFOSettings();
        settings.setWmlPackage(wmlPackage);
        settings.setApacheFopMime(MIME_PDF);
        Docx4J.toFO(settings, outputStream, 0);
        new EventFinished(startEvent).publish();
    }

    protected static Exporter<FOSettings> getFOExporter(int flags) {
        switch (flags) {
            case 2: {
                return FOExporterVisitor.getInstance();
            }
        }
        return FOExporterXslt.getInstance();
    }

    public static HTMLSettings createHTMLSettings() {
        return new HTMLSettings();
    }

    public static void toHTML(HTMLSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        StartEvent startEvent = new StartEvent(settings.getWmlPackage(), WellKnownProcessSteps.HTML_OUT);
        startEvent.publish();
        Exporter<HTMLSettings> exporter = Docx4J.getHTMLExporter(flags);
        exporter.export(settings, outputStream);
        new EventFinished(startEvent).publish();
    }

    public static void toHTML(WordprocessingMLPackage wmlPackage, String imageDirPath, String imageTargetUri, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(wmlPackage, WellKnownProcessSteps.HTML_OUT);
        startEvent.publish();
        HTMLSettings settings = Docx4J.createHTMLSettings();
        settings.setWmlPackage(wmlPackage);
        if (imageDirPath != null) {
            settings.setImageDirPath(imageDirPath);
        }
        if (imageTargetUri != null) {
            settings.setImageTargetUri(imageTargetUri);
        }
        Docx4J.toHTML(settings, outputStream, 0);
        new EventFinished(startEvent).publish();
    }

    protected static Exporter<HTMLSettings> getHTMLExporter(int flags) {
        switch (flags) {
            case 2: {
                return HTMLExporterVisitor.getInstance();
            }
        }
        return HTMLExporterXslt.getInstance();
    }

    static {
        PART_TO_REMOVE_SCHEMA_TYPES = new TreeSet<String>();
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_CONDITIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_XPATHS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_QUESTIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_COMPONENTS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FindContentControlsVisitor
    extends TraversalUtilVisitor<SdtElement> {
        protected Set<String> definedStoreItemIds = null;
        protected String storeItemId = null;

        public FindContentControlsVisitor(Set<String> definedStoreItemIds) {
            this.definedStoreItemIds = definedStoreItemIds;
        }

        @Override
        public void apply(SdtElement element) {
            String tmp;
            SdtPr sdtPr = element.getSdtPr();
            if (sdtPr.getDataBinding() != null && sdtPr.getDataBinding().getStoreItemID() != null && this.definedStoreItemIds.contains(tmp = sdtPr.getDataBinding().getStoreItemID().toLowerCase())) {
                this.storeItemId = tmp;
                throw new BreakException();
            }
        }

        public String getdefinedStoreItemId() {
            return this.storeItemId;
        }

        public static class BreakException
        extends RuntimeException {
        }
    }
}

