/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class TxInteractiveInfoAtom
extends RecordAtom {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private byte[] _header = new byte[8];
    private byte[] _data;

    public TxInteractiveInfoAtom() {
        this._data = new byte[8];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected TxInteractiveInfoAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = IOUtils.safelyAllocate((long)(len - 8), (int)1000000);
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public int getStartIndex() {
        return LittleEndian.getInt((byte[])this._data, (int)0);
    }

    public void setStartIndex(int idx) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)idx);
    }

    public int getEndIndex() {
        return LittleEndian.getInt((byte[])this._data, (int)4);
    }

    public void setEndIndex(int idx) {
        LittleEndian.putInt((byte[])this._data, (int)4, (int)idx);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.TxInteractiveInfoAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

