/**
 */
package org.etsi.mts.tdl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.tdlFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore"
 * @generated
 */
public interface tdlPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "tdl";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.etsi.org/spec/TDL/1.4.1";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "tdl";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	tdlPackage eINSTANCE = org.etsi.mts.tdl.impl.tdlPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ElementImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getElement()
	 * @generated
	 */
	int ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__COMMENT = 0;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__ANNOTATION = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__NAME = 2;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_FEATURE_COUNT = 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___CONTAINER = 0;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___GET_PARENT_TEST_DESCRIPTION = 1;

	/**
	 * The number of operations of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CommentImpl <em>Comment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CommentImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComment()
	 * @generated
	 */
	int COMMENT = 1;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__BODY = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Commented Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__COMMENTED_ELEMENT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Comment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Comment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AnnotationImpl <em>Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AnnotationImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnnotation()
	 * @generated
	 */
	int ANNOTATION = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__VALUE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__KEY = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Annotated Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ANNOTATED_ELEMENT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.NamedElementImpl <em>Named Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.NamedElementImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getNamedElement()
	 * @generated
	 */
	int NAMED_ELEMENT = 5;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__QUALIFIED_NAME = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Named Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Named Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.PackageableElementImpl <em>Packageable Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.PackageableElementImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPackageableElement()
	 * @generated
	 */
	int PACKAGEABLE_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Packageable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING = NAMED_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT = NAMED_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Packageable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGEABLE_ELEMENT_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AnnotationTypeImpl <em>Annotation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AnnotationTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnnotationType()
	 * @generated
	 */
	int ANNOTATION_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE__EXTENSION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Annotation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Annotation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_TYPE_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.PackageImpl <em>Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.PackageImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPackage()
	 * @generated
	 */
	int PACKAGE = 6;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Packaged Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__PACKAGED_ELEMENT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Import</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__IMPORT = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Nested Package</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__NESTED_PACKAGE = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ElementImportImpl <em>Element Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ElementImportImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getElementImport()
	 * @generated
	 */
	int ELEMENT_IMPORT = 7;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Imported Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT__IMPORTED_ELEMENT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Imported Package</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT__IMPORTED_PACKAGE = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Element Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Element Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TestObjectiveImpl <em>Test Objective</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TestObjectiveImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestObjective()
	 * @generated
	 */
	int TEST_OBJECTIVE = 8;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Objective URI</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__OBJECTIVE_URI = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE__DESCRIPTION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Test Objective</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Test Objective</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MappableDataElementImpl <em>Mappable Data Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MappableDataElementImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMappableDataElement()
	 * @generated
	 */
	int MAPPABLE_DATA_ELEMENT = 10;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Mappable Data Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Mappable Data Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPABLE_DATA_ELEMENT_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataInstanceImpl <em>Data Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataInstance()
	 * @generated
	 */
	int DATA_INSTANCE = 9;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE__COMMENT = MAPPABLE_DATA_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE__ANNOTATION = MAPPABLE_DATA_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE__NAME = MAPPABLE_DATA_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE__QUALIFIED_NAME = MAPPABLE_DATA_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE__DATA_TYPE = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_FEATURE_COUNT = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE___CONTAINER = MAPPABLE_DATA_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION = MAPPABLE_DATA_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE___CONFORMS_TO__STRING = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE___GET_ELEMENT_NAMED__STRING = MAPPABLE_DATA_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_OPERATION_COUNT = MAPPABLE_DATA_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataTypeImpl <em>Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataType()
	 * @generated
	 */
	int DATA_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE__COMMENT = MAPPABLE_DATA_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE__ANNOTATION = MAPPABLE_DATA_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE__NAME = MAPPABLE_DATA_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE__QUALIFIED_NAME = MAPPABLE_DATA_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE__CONSTRAINT = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_FEATURE_COUNT = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___CONTAINER = MAPPABLE_DATA_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___GET_PARENT_TEST_DESCRIPTION = MAPPABLE_DATA_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___CONFORMS_TO__STRING = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___GET_ELEMENT_NAMED__STRING = MAPPABLE_DATA_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE___ALL_CONSTRAINTS = MAPPABLE_DATA_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_OPERATION_COUNT = MAPPABLE_DATA_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataResourceMappingImpl <em>Data Resource Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataResourceMappingImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataResourceMapping()
	 * @generated
	 */
	int DATA_RESOURCE_MAPPING = 12;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Resource URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING__RESOURCE_URI = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Resource Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Data Resource Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RESOURCE_MAPPING_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataElementMappingImpl <em>Data Element Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataElementMappingImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataElementMapping()
	 * @generated
	 */
	int DATA_ELEMENT_MAPPING = 13;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Mappable Data Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__MAPPABLE_DATA_ELEMENT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Element URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__ELEMENT_URI = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Resource Mapping</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__DATA_RESOURCE_MAPPING = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Parameter Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING__PARAMETER_MAPPING = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Data Element Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Data Element Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_MAPPING_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ParameterMappingImpl <em>Parameter Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ParameterMappingImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterMapping()
	 * @generated
	 */
	int PARAMETER_MAPPING = 14;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parameter URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING__PARAMETER_URI = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING__PARAMETER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Parameter Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Parameter Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_MAPPING_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ParameterImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 15;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__DATA_TYPE = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.SimpleDataTypeImpl <em>Simple Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.SimpleDataTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSimpleDataType()
	 * @generated
	 */
	int SIMPLE_DATA_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__COMMENT = DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__ANNOTATION = DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__NAME = DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__QUALIFIED_NAME = DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__CONSTRAINT = DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE__EXTENSION = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Simple Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___CONTAINER = DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION = DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___CONFORMS_TO__STRING = DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___GET_ELEMENT_NAMED__STRING = DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE___ALL_CONSTRAINTS = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Simple Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_TYPE_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.SimpleDataInstanceImpl <em>Simple Data Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.SimpleDataInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSimpleDataInstance()
	 * @generated
	 */
	int SIMPLE_DATA_INSTANCE = 17;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE__COMMENT = DATA_INSTANCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE__ANNOTATION = DATA_INSTANCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE__NAME = DATA_INSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE__QUALIFIED_NAME = DATA_INSTANCE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE__DATA_TYPE = DATA_INSTANCE__DATA_TYPE;

	/**
	 * The number of structural features of the '<em>Simple Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE_FEATURE_COUNT = DATA_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE___CONTAINER = DATA_INSTANCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION = DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE___CONFORMS_TO__STRING = DATA_INSTANCE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE___GET_ELEMENT_NAMED__STRING = DATA_INSTANCE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Simple Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_DATA_INSTANCE_OPERATION_COUNT = DATA_INSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.StructuredDataTypeImpl <em>Structured Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.StructuredDataTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStructuredDataType()
	 * @generated
	 */
	int STRUCTURED_DATA_TYPE = 18;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__COMMENT = DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__ANNOTATION = DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__NAME = DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__QUALIFIED_NAME = DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__CONSTRAINT = DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__EXTENSION = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE__MEMBER = DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Structured Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___CONTAINER = DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION = DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___CONFORMS_TO__STRING = DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___GET_ELEMENT_NAMED__STRING = DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___ALL_MEMBERS = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE___ALL_CONSTRAINTS = DATA_TYPE_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Structured Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_TYPE_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MemberImpl <em>Member</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MemberImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMember()
	 * @generated
	 */
	int MEMBER = 19;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__COMMENT = PARAMETER__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__ANNOTATION = PARAMETER__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__NAME = PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__QUALIFIED_NAME = PARAMETER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__DATA_TYPE = PARAMETER__DATA_TYPE;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__IS_OPTIONAL = PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__CONSTRAINT = PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_FEATURE_COUNT = PARAMETER_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER___CONTAINER = PARAMETER___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER___GET_PARENT_TEST_DESCRIPTION = PARAMETER___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OPERATION_COUNT = PARAMETER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.StructuredDataInstanceImpl <em>Structured Data Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.StructuredDataInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStructuredDataInstance()
	 * @generated
	 */
	int STRUCTURED_DATA_INSTANCE = 20;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__COMMENT = DATA_INSTANCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__ANNOTATION = DATA_INSTANCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__NAME = DATA_INSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__QUALIFIED_NAME = DATA_INSTANCE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__DATA_TYPE = DATA_INSTANCE__DATA_TYPE;

	/**
	 * The feature id for the '<em><b>Member Assignment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__MEMBER_ASSIGNMENT = DATA_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unassigned Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE__UNASSIGNED_MEMBER = DATA_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Structured Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE_FEATURE_COUNT = DATA_INSTANCE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE___CONTAINER = DATA_INSTANCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION = DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE___CONFORMS_TO__STRING = DATA_INSTANCE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE___GET_ELEMENT_NAMED__STRING = DATA_INSTANCE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Structured Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_DATA_INSTANCE_OPERATION_COUNT = DATA_INSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MemberAssignmentImpl <em>Member Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MemberAssignmentImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMemberAssignment()
	 * @generated
	 */
	int MEMBER_ASSIGNMENT = 21;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT__MEMBER = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Member Spec</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT__MEMBER_SPEC = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Member Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Member Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ASSIGNMENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataUseImpl <em>Data Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataUse()
	 * @generated
	 */
	int DATA_USE = 23;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE__ARGUMENT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE__REDUCTION = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE___RESOLVE_DATA_TYPE = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE___IS_EFFECTIVELY_STATIC = ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_USE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.StaticDataUseImpl <em>Static Data Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.StaticDataUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStaticDataUse()
	 * @generated
	 */
	int STATIC_DATA_USE = 22;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE__COMMENT = DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE__ANNOTATION = DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE__NAME = DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE__ARGUMENT = DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE__REDUCTION = DATA_USE__REDUCTION;

	/**
	 * The number of structural features of the '<em>Static Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE_FEATURE_COUNT = DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE___CONTAINER = DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION = DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE___RESOLVE_DATA_TYPE = DATA_USE___RESOLVE_DATA_TYPE;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE___IS_EFFECTIVELY_STATIC = DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The number of operations of the '<em>Static Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_DATA_USE_OPERATION_COUNT = DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ParameterBindingImpl <em>Parameter Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ParameterBindingImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterBinding()
	 * @generated
	 */
	int PARAMETER_BINDING = 24;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Data Use</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__DATA_USE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__PARAMETER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING__REDUCTION = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Parameter Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Resolve Parameter Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING___RESOLVE_PARAMETER_TYPE = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Parameter Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_BINDING_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ActionImpl <em>Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ActionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAction()
	 * @generated
	 */
	int ACTION = 25;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__COMMENT = MAPPABLE_DATA_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__ANNOTATION = MAPPABLE_DATA_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__NAME = MAPPABLE_DATA_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__QUALIFIED_NAME = MAPPABLE_DATA_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__BODY = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Formal Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__FORMAL_PARAMETER = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_FEATURE_COUNT = MAPPABLE_DATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION___CONTAINER = MAPPABLE_DATA_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION___GET_PARENT_TEST_DESCRIPTION = MAPPABLE_DATA_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION___CONFORMS_TO__STRING = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION___GET_ELEMENT_NAMED__STRING = MAPPABLE_DATA_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION___CONFORMS_TO__PACKAGEABLEELEMENT = MAPPABLE_DATA_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_OPERATION_COUNT = MAPPABLE_DATA_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.FormalParameterImpl <em>Formal Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.FormalParameterImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFormalParameter()
	 * @generated
	 */
	int FORMAL_PARAMETER = 26;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER__COMMENT = PARAMETER__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER__ANNOTATION = PARAMETER__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER__NAME = PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER__QUALIFIED_NAME = PARAMETER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER__DATA_TYPE = PARAMETER__DATA_TYPE;

	/**
	 * The number of structural features of the '<em>Formal Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_FEATURE_COUNT = PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER___CONTAINER = PARAMETER___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER___GET_PARENT_TEST_DESCRIPTION = PARAMETER___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Formal Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_OPERATION_COUNT = PARAMETER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.FunctionImpl <em>Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.FunctionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFunction()
	 * @generated
	 */
	int FUNCTION = 27;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__COMMENT = ACTION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ANNOTATION = ACTION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NAME = ACTION__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__QUALIFIED_NAME = ACTION__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__BODY = ACTION__BODY;

	/**
	 * The feature id for the '<em><b>Formal Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__FORMAL_PARAMETER = ACTION__FORMAL_PARAMETER;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__RETURN_TYPE = ACTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_FEATURE_COUNT = ACTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION___CONTAINER = ACTION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION___GET_PARENT_TEST_DESCRIPTION = ACTION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION___CONFORMS_TO__STRING = ACTION___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION___GET_ELEMENT_NAMED__STRING = ACTION___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION___CONFORMS_TO__PACKAGEABLEELEMENT = ACTION___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_OPERATION_COUNT = ACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DynamicDataUseImpl <em>Dynamic Data Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DynamicDataUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDynamicDataUse()
	 * @generated
	 */
	int DYNAMIC_DATA_USE = 29;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE__COMMENT = DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE__ANNOTATION = DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE__NAME = DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE__ARGUMENT = DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE__REDUCTION = DATA_USE__REDUCTION;

	/**
	 * The number of structural features of the '<em>Dynamic Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE_FEATURE_COUNT = DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE___CONTAINER = DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION = DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE___RESOLVE_DATA_TYPE = DATA_USE___RESOLVE_DATA_TYPE;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC = DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The number of operations of the '<em>Dynamic Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_DATA_USE_OPERATION_COUNT = DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.FormalParameterUseImpl <em>Formal Parameter Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.FormalParameterUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFormalParameterUse()
	 * @generated
	 */
	int FORMAL_PARAMETER_USE = 28;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__COMMENT = DYNAMIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__ANNOTATION = DYNAMIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__NAME = DYNAMIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__ARGUMENT = DYNAMIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__REDUCTION = DYNAMIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE__PARAMETER = DYNAMIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Formal Parameter Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE_FEATURE_COUNT = DYNAMIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE___CONTAINER = DYNAMIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE___GET_PARENT_TEST_DESCRIPTION = DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE___IS_EFFECTIVELY_STATIC = DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE___RESOLVE_DATA_TYPE = DYNAMIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Formal Parameter Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PARAMETER_USE_OPERATION_COUNT = DYNAMIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.VariableImpl <em>Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.VariableImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE = 30;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__DATA_TYPE = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.FunctionCallImpl <em>Function Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.FunctionCallImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFunctionCall()
	 * @generated
	 */
	int FUNCTION_CALL = 31;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__COMMENT = DYNAMIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ANNOTATION = DYNAMIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__NAME = DYNAMIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ARGUMENT = DYNAMIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__REDUCTION = DYNAMIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__FUNCTION = DYNAMIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_FEATURE_COUNT = DYNAMIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL___CONTAINER = DYNAMIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL___GET_PARENT_TEST_DESCRIPTION = DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL___IS_EFFECTIVELY_STATIC = DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL___RESOLVE_DATA_TYPE = DYNAMIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_OPERATION_COUNT = DYNAMIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.VariableUseImpl <em>Variable Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.VariableUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVariableUse()
	 * @generated
	 */
	int VARIABLE_USE = 32;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__COMMENT = DYNAMIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__ANNOTATION = DYNAMIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__NAME = DYNAMIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__ARGUMENT = DYNAMIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__REDUCTION = DYNAMIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__COMPONENT_INSTANCE = DYNAMIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE__VARIABLE = DYNAMIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE_FEATURE_COUNT = DYNAMIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE___CONTAINER = DYNAMIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE___GET_PARENT_TEST_DESCRIPTION = DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE___IS_EFFECTIVELY_STATIC = DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE___RESOLVE_DATA_TYPE = DYNAMIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Variable Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_USE_OPERATION_COUNT = DYNAMIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ComponentInstanceImpl <em>Component Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ComponentInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstance()
	 * @generated
	 */
	int COMPONENT_INSTANCE = 33;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__TYPE = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__ROLE = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ComponentTypeImpl <em>Component Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ComponentTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentType()
	 * @generated
	 */
	int COMPONENT_TYPE = 34;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Gate Instance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__GATE_INSTANCE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Timer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__TIMER = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__VARIABLE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__EXTENSION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Component Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Gates</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___ALL_GATES = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>All Timers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___ALL_TIMERS = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>All Variables</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE___ALL_VARIABLES = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Component Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.GateInstanceImpl <em>Gate Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.GateInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateInstance()
	 * @generated
	 */
	int GATE_INSTANCE = 35;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE__TYPE = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Gate Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Gate Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_INSTANCE_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.GateTypeImpl <em>Gate Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.GateTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateType()
	 * @generated
	 */
	int GATE_TYPE = 36;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__DATA_TYPE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__KIND = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE__EXTENSION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Gate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Data Types</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE___ALL_DATA_TYPES = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Gate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_TYPE_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimerImpl <em>Timer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimerImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimer()
	 * @generated
	 */
	int TIMER = 37;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Timer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Timer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.SpecialValueUseImpl <em>Special Value Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.SpecialValueUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSpecialValueUse()
	 * @generated
	 */
	int SPECIAL_VALUE_USE = 39;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE__COMMENT = STATIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE__ANNOTATION = STATIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE__NAME = STATIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE__ARGUMENT = STATIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE__REDUCTION = STATIC_DATA_USE__REDUCTION;

	/**
	 * The number of structural features of the '<em>Special Value Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE_FEATURE_COUNT = STATIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE___CONTAINER = STATIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE___GET_PARENT_TEST_DESCRIPTION = STATIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE___IS_EFFECTIVELY_STATIC = STATIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE___RESOLVE_DATA_TYPE = STATIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Special Value Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIAL_VALUE_USE_OPERATION_COUNT = STATIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.OmitValueImpl <em>Omit Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.OmitValueImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getOmitValue()
	 * @generated
	 */
	int OMIT_VALUE = 38;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE__COMMENT = SPECIAL_VALUE_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE__ANNOTATION = SPECIAL_VALUE_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE__NAME = SPECIAL_VALUE_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE__ARGUMENT = SPECIAL_VALUE_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE__REDUCTION = SPECIAL_VALUE_USE__REDUCTION;

	/**
	 * The number of structural features of the '<em>Omit Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE_FEATURE_COUNT = SPECIAL_VALUE_USE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE___CONTAINER = SPECIAL_VALUE_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE___GET_PARENT_TEST_DESCRIPTION = SPECIAL_VALUE_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE___IS_EFFECTIVELY_STATIC = SPECIAL_VALUE_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE___RESOLVE_DATA_TYPE = SPECIAL_VALUE_USE___RESOLVE_DATA_TYPE;

	/**
	 * The number of operations of the '<em>Omit Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OMIT_VALUE_OPERATION_COUNT = SPECIAL_VALUE_USE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AnyValueImpl <em>Any Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AnyValueImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnyValue()
	 * @generated
	 */
	int ANY_VALUE = 40;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__COMMENT = SPECIAL_VALUE_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__ANNOTATION = SPECIAL_VALUE_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__NAME = SPECIAL_VALUE_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__ARGUMENT = SPECIAL_VALUE_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__REDUCTION = SPECIAL_VALUE_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE__DATA_TYPE = SPECIAL_VALUE_USE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Any Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_FEATURE_COUNT = SPECIAL_VALUE_USE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE___CONTAINER = SPECIAL_VALUE_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE___GET_PARENT_TEST_DESCRIPTION = SPECIAL_VALUE_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE___IS_EFFECTIVELY_STATIC = SPECIAL_VALUE_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE___RESOLVE_DATA_TYPE = SPECIAL_VALUE_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Any Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OPERATION_COUNT = SPECIAL_VALUE_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AnyValueOrOmitImpl <em>Any Value Or Omit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AnyValueOrOmitImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnyValueOrOmit()
	 * @generated
	 */
	int ANY_VALUE_OR_OMIT = 41;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT__COMMENT = SPECIAL_VALUE_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT__ANNOTATION = SPECIAL_VALUE_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT__NAME = SPECIAL_VALUE_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT__ARGUMENT = SPECIAL_VALUE_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT__REDUCTION = SPECIAL_VALUE_USE__REDUCTION;

	/**
	 * The number of structural features of the '<em>Any Value Or Omit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT_FEATURE_COUNT = SPECIAL_VALUE_USE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT___CONTAINER = SPECIAL_VALUE_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT___GET_PARENT_TEST_DESCRIPTION = SPECIAL_VALUE_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT___IS_EFFECTIVELY_STATIC = SPECIAL_VALUE_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT___RESOLVE_DATA_TYPE = SPECIAL_VALUE_USE___RESOLVE_DATA_TYPE;

	/**
	 * The number of operations of the '<em>Any Value Or Omit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_VALUE_OR_OMIT_OPERATION_COUNT = SPECIAL_VALUE_USE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataInstanceUseImpl <em>Data Instance Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataInstanceUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataInstanceUse()
	 * @generated
	 */
	int DATA_INSTANCE_USE = 42;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__COMMENT = STATIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__ANNOTATION = STATIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__NAME = STATIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__ARGUMENT = STATIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__REDUCTION = STATIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Data Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__DATA_INSTANCE = STATIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unassigned Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__UNASSIGNED_MEMBER = STATIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__DATA_TYPE = STATIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Item</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE__ITEM = STATIC_DATA_USE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Data Instance Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE_FEATURE_COUNT = STATIC_DATA_USE_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE___CONTAINER = STATIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE___GET_PARENT_TEST_DESCRIPTION = STATIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE___IS_EFFECTIVELY_STATIC = STATIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE___RESOLVE_DATA_TYPE = STATIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Data Instance Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_INSTANCE_USE_OPERATION_COUNT = STATIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeImpl <em>Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTime()
	 * @generated
	 */
	int TIME = 43;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__COMMENT = SIMPLE_DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__ANNOTATION = SIMPLE_DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__NAME = SIMPLE_DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__QUALIFIED_NAME = SIMPLE_DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__CONSTRAINT = SIMPLE_DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__EXTENSION = SIMPLE_DATA_TYPE__EXTENSION;

	/**
	 * The number of structural features of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_FEATURE_COUNT = SIMPLE_DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___CONTAINER = SIMPLE_DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___GET_PARENT_TEST_DESCRIPTION = SIMPLE_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___CONFORMS_TO__STRING = SIMPLE_DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___GET_ELEMENT_NAMED__STRING = SIMPLE_DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___CONFORMS_TO__PACKAGEABLEELEMENT = SIMPLE_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___ALL_CONSTRAINTS = SIMPLE_DATA_TYPE___ALL_CONSTRAINTS;

	/**
	 * The number of operations of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION_COUNT = SIMPLE_DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeLabelImpl <em>Time Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeLabelImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabel()
	 * @generated
	 */
	int TIME_LABEL = 44;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL__COMMENT = NAMED_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL__ANNOTATION = NAMED_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL__QUALIFIED_NAME = NAMED_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Time Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL___CONTAINER = NAMED_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL___GET_PARENT_TEST_DESCRIPTION = NAMED_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Time Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_OPERATION_COUNT = NAMED_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.BehaviourImpl <em>Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.BehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBehaviour()
	 * @generated
	 */
	int BEHAVIOUR = 47;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__TEST_OBJECTIVE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR___IS_TESTER_INPUT_EVENT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AtomicBehaviourImpl <em>Atomic Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AtomicBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAtomicBehaviour()
	 * @generated
	 */
	int ATOMIC_BEHAVIOUR = 46;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__COMMENT = BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__ANNOTATION = BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__TEST_OBJECTIVE = BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__TIME_CONSTRAINT = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR__TIME_LABEL = BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Atomic Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR___CONTAINER = BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT = BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Atomic Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOMIC_BEHAVIOUR_OPERATION_COUNT = BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimerOperationImpl <em>Timer Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimerOperationImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerOperation()
	 * @generated
	 */
	int TIMER_OPERATION = 45;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Timer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__TIMER = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION__COMPONENT_INSTANCE = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Timer Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Timer Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_OPERATION_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeConstraintImpl <em>Time Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeConstraintImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeConstraint()
	 * @generated
	 */
	int TIME_CONSTRAINT = 48;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Time Constraint Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT__TIME_CONSTRAINT_EXPRESSION = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Time Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTRAINT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimerStartImpl <em>Timer Start</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimerStartImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerStart()
	 * @generated
	 */
	int TIMER_START = 49;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__COMMENT = TIMER_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__ANNOTATION = TIMER_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__NAME = TIMER_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__TEST_OBJECTIVE = TIMER_OPERATION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__TIME_CONSTRAINT = TIMER_OPERATION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__TIME_LABEL = TIMER_OPERATION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Timer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__TIMER = TIMER_OPERATION__TIMER;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__COMPONENT_INSTANCE = TIMER_OPERATION__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START__PERIOD = TIMER_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Timer Start</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START_FEATURE_COUNT = TIMER_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START___CONTAINER = TIMER_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START___GET_PARENT_TEST_DESCRIPTION = TIMER_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START___IS_TESTER_INPUT_EVENT = TIMER_OPERATION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START___GET_PARTICIPATING_COMPONENTS = TIMER_OPERATION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Timer Start</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_START_OPERATION_COUNT = TIMER_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimerStopImpl <em>Timer Stop</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimerStopImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerStop()
	 * @generated
	 */
	int TIMER_STOP = 50;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__COMMENT = TIMER_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__ANNOTATION = TIMER_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__NAME = TIMER_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__TEST_OBJECTIVE = TIMER_OPERATION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__TIME_CONSTRAINT = TIMER_OPERATION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__TIME_LABEL = TIMER_OPERATION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Timer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__TIMER = TIMER_OPERATION__TIMER;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP__COMPONENT_INSTANCE = TIMER_OPERATION__COMPONENT_INSTANCE;

	/**
	 * The number of structural features of the '<em>Timer Stop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP_FEATURE_COUNT = TIMER_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP___CONTAINER = TIMER_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP___GET_PARENT_TEST_DESCRIPTION = TIMER_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP___IS_TESTER_INPUT_EVENT = TIMER_OPERATION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP___GET_PARTICIPATING_COMPONENTS = TIMER_OPERATION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Timer Stop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMER_STOP_OPERATION_COUNT = TIMER_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeOutImpl <em>Time Out</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeOutImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeOut()
	 * @generated
	 */
	int TIME_OUT = 51;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__COMMENT = TIMER_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__ANNOTATION = TIMER_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__NAME = TIMER_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__TEST_OBJECTIVE = TIMER_OPERATION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__TIME_CONSTRAINT = TIMER_OPERATION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__TIME_LABEL = TIMER_OPERATION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Timer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__TIMER = TIMER_OPERATION__TIMER;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT__COMPONENT_INSTANCE = TIMER_OPERATION__COMPONENT_INSTANCE;

	/**
	 * The number of structural features of the '<em>Time Out</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT_FEATURE_COUNT = TIMER_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT___CONTAINER = TIMER_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT___GET_PARENT_TEST_DESCRIPTION = TIMER_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT___IS_TESTER_INPUT_EVENT = TIMER_OPERATION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT___GET_PARTICIPATING_COMPONENTS = TIMER_OPERATION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Time Out</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OUT_OPERATION_COUNT = TIMER_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeOperationImpl <em>Time Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeOperationImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeOperation()
	 * @generated
	 */
	int TIME_OPERATION = 52;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__COMPONENT_INSTANCE = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION__PERIOD = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.WaitImpl <em>Wait</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.WaitImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getWait()
	 * @generated
	 */
	int WAIT = 53;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__COMMENT = TIME_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__ANNOTATION = TIME_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__NAME = TIME_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__TEST_OBJECTIVE = TIME_OPERATION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__TIME_CONSTRAINT = TIME_OPERATION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__TIME_LABEL = TIME_OPERATION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__COMPONENT_INSTANCE = TIME_OPERATION__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT__PERIOD = TIME_OPERATION__PERIOD;

	/**
	 * The number of structural features of the '<em>Wait</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_FEATURE_COUNT = TIME_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT___CONTAINER = TIME_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT___GET_PARENT_TEST_DESCRIPTION = TIME_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT___IS_TESTER_INPUT_EVENT = TIME_OPERATION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT___GET_PARTICIPATING_COMPONENTS = TIME_OPERATION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Wait</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_OPERATION_COUNT = TIME_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.QuiescenceImpl <em>Quiescence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.QuiescenceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getQuiescence()
	 * @generated
	 */
	int QUIESCENCE = 54;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__COMMENT = TIME_OPERATION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__ANNOTATION = TIME_OPERATION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__NAME = TIME_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__TEST_OBJECTIVE = TIME_OPERATION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__TIME_CONSTRAINT = TIME_OPERATION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__TIME_LABEL = TIME_OPERATION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__COMPONENT_INSTANCE = TIME_OPERATION__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__PERIOD = TIME_OPERATION__PERIOD;

	/**
	 * The feature id for the '<em><b>Gate Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE__GATE_REFERENCE = TIME_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Quiescence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE_FEATURE_COUNT = TIME_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE___CONTAINER = TIME_OPERATION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE___GET_PARENT_TEST_DESCRIPTION = TIME_OPERATION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE___IS_TESTER_INPUT_EVENT = TIME_OPERATION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE___GET_PARTICIPATING_COMPONENTS = TIME_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Quiescence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUIESCENCE_OPERATION_COUNT = TIME_OPERATION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.GateReferenceImpl <em>Gate Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.GateReferenceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateReference()
	 * @generated
	 */
	int GATE_REFERENCE = 55;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE__COMPONENT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE__GATE = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Gate Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Gate Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATE_REFERENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TimeLabelUseImpl <em>Time Label Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TimeLabelUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabelUse()
	 * @generated
	 */
	int TIME_LABEL_USE = 56;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__COMMENT = DYNAMIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__ANNOTATION = DYNAMIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__NAME = DYNAMIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__ARGUMENT = DYNAMIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__REDUCTION = DYNAMIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__TIME_LABEL = DYNAMIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE__KIND = DYNAMIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Label Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE_FEATURE_COUNT = DYNAMIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE___CONTAINER = DYNAMIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE___GET_PARENT_TEST_DESCRIPTION = DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE___IS_EFFECTIVELY_STATIC = DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE___RESOLVE_DATA_TYPE = DYNAMIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Label Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_LABEL_USE_OPERATION_COUNT = DYNAMIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TestConfigurationImpl <em>Test Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TestConfigurationImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestConfiguration()
	 * @generated
	 */
	int TEST_CONFIGURATION = 57;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__COMPONENT_INSTANCE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connection</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION__CONNECTION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Test Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Compatible With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION___COMPATIBLE_WITH__TESTCONFIGURATION_ELIST = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Test Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_CONFIGURATION_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ConnectionImpl <em>Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ConnectionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConnection()
	 * @generated
	 */
	int CONNECTION = 58;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>End Point</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION__END_POINT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TestDescriptionImpl <em>Test Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TestDescriptionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestDescription()
	 * @generated
	 */
	int TEST_DESCRIPTION = 59;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Test Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__TEST_CONFIGURATION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Formal Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__FORMAL_PARAMETER = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Behaviour Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__TEST_OBJECTIVE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Locally Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION__IS_LOCALLY_ORDERED = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Test Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Test Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.BehaviourDescriptionImpl <em>Behaviour Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.BehaviourDescriptionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBehaviourDescription()
	 * @generated
	 */
	int BEHAVIOUR_DESCRIPTION = 60;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION__BEHAVIOUR = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Behaviour Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Behaviour Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_DESCRIPTION_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.BlockImpl <em>Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.BlockImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBlock()
	 * @generated
	 */
	int BLOCK = 61;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Behaviour</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK__BEHAVIOUR = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Guard</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK__GUARD = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK___GET_PARTICIPATING_COMPONENTS = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Participating Components Excluding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK___GET_PARTICIPATING_COMPONENTS_EXCLUDING__BEHAVIOUR = ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CombinedBehaviourImpl <em>Combined Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CombinedBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCombinedBehaviour()
	 * @generated
	 */
	int COMBINED_BEHAVIOUR = 62;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__COMMENT = BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__ANNOTATION = BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__TEST_OBJECTIVE = BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__PERIODIC = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR__EXCEPTIONAL = BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR___CONTAINER = BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT = BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_BEHAVIOUR_OPERATION_COUNT = BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.PeriodicBehaviourImpl <em>Periodic Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.PeriodicBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPeriodicBehaviour()
	 * @generated
	 */
	int PERIODIC_BEHAVIOUR = 63;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__COMMENT = BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__ANNOTATION = BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__TEST_OBJECTIVE = BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__BLOCK = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR__PERIOD = BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Periodic Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR___CONTAINER = BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT = BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Periodic Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BEHAVIOUR_OPERATION_COUNT = BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ExceptionalBehaviourImpl <em>Exceptional Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ExceptionalBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getExceptionalBehaviour()
	 * @generated
	 */
	int EXCEPTIONAL_BEHAVIOUR = 64;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__COMMENT = BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__ANNOTATION = BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__TEST_OBJECTIVE = BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__BLOCK = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Guarded Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR__GUARDED_COMPONENT = BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Exceptional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR___CONTAINER = BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR___IS_TESTER_INPUT_EVENT = BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Exceptional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTIONAL_BEHAVIOUR_OPERATION_COUNT = BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MultipleCombinedBehaviourImpl <em>Multiple Combined Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MultipleCombinedBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMultipleCombinedBehaviour()
	 * @generated
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR = 66;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__COMMENT = COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__ANNOTATION = COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__NAME = COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE = COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__PERIODIC = COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__EXCEPTIONAL = COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR__BLOCK = COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Multiple Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR_FEATURE_COUNT = COMBINED_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR___CONTAINER = COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT = COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Multiple Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_COMBINED_BEHAVIOUR_OPERATION_COUNT = COMBINED_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AlternativeBehaviourImpl <em>Alternative Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AlternativeBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAlternativeBehaviour()
	 * @generated
	 */
	int ALTERNATIVE_BEHAVIOUR = 65;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__COMMENT = MULTIPLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__ANNOTATION = MULTIPLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__NAME = MULTIPLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__TEST_OBJECTIVE = MULTIPLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__PERIODIC = MULTIPLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__EXCEPTIONAL = MULTIPLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR__BLOCK = MULTIPLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Alternative Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR_FEATURE_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR___CONTAINER = MULTIPLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR___IS_TESTER_INPUT_EVENT = MULTIPLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Alternative Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_BEHAVIOUR_OPERATION_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ParallelBehaviourImpl <em>Parallel Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ParallelBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParallelBehaviour()
	 * @generated
	 */
	int PARALLEL_BEHAVIOUR = 67;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__COMMENT = MULTIPLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__ANNOTATION = MULTIPLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__NAME = MULTIPLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__TEST_OBJECTIVE = MULTIPLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__PERIODIC = MULTIPLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__EXCEPTIONAL = MULTIPLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR__BLOCK = MULTIPLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Parallel Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR_FEATURE_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR___CONTAINER = MULTIPLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR___IS_TESTER_INPUT_EVENT = MULTIPLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Parallel Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARALLEL_BEHAVIOUR_OPERATION_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.SingleCombinedBehaviourImpl <em>Single Combined Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.SingleCombinedBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSingleCombinedBehaviour()
	 * @generated
	 */
	int SINGLE_COMBINED_BEHAVIOUR = 69;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__COMMENT = COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__ANNOTATION = COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__NAME = COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE = COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__PERIODIC = COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__EXCEPTIONAL = COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR__BLOCK = COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT = COMBINED_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR___CONTAINER = COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT = COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Single Combined Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_COMBINED_BEHAVIOUR_OPERATION_COUNT = COMBINED_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.BoundedLoopBehaviourImpl <em>Bounded Loop Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.BoundedLoopBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBoundedLoopBehaviour()
	 * @generated
	 */
	int BOUNDED_LOOP_BEHAVIOUR = 68;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__COMMENT = SINGLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__ANNOTATION = SINGLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__NAME = SINGLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__TEST_OBJECTIVE = SINGLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__PERIODIC = SINGLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__EXCEPTIONAL = SINGLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__BLOCK = SINGLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The feature id for the '<em><b>Num Iteration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR__NUM_ITERATION = SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Bounded Loop Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR_FEATURE_COUNT = SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR___CONTAINER = SINGLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = SINGLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR___IS_TESTER_INPUT_EVENT = SINGLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Bounded Loop Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_LOOP_BEHAVIOUR_OPERATION_COUNT = SINGLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.OptionalBehaviourImpl <em>Optional Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.OptionalBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getOptionalBehaviour()
	 * @generated
	 */
	int OPTIONAL_BEHAVIOUR = 70;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__COMMENT = SINGLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__ANNOTATION = SINGLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__NAME = SINGLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__TEST_OBJECTIVE = SINGLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__PERIODIC = SINGLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__EXCEPTIONAL = SINGLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR__BLOCK = SINGLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Optional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR_FEATURE_COUNT = SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR___CONTAINER = SINGLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = SINGLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR___IS_TESTER_INPUT_EVENT = SINGLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Optional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_BEHAVIOUR_OPERATION_COUNT = SINGLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.UnboundedLoopBehaviourImpl <em>Unbounded Loop Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.UnboundedLoopBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getUnboundedLoopBehaviour()
	 * @generated
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR = 71;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__COMMENT = SINGLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__ANNOTATION = SINGLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__NAME = SINGLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__TEST_OBJECTIVE = SINGLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__PERIODIC = SINGLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__EXCEPTIONAL = SINGLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR__BLOCK = SINGLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Unbounded Loop Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR_FEATURE_COUNT = SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR___CONTAINER = SINGLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = SINGLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR___IS_TESTER_INPUT_EVENT = SINGLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Unbounded Loop Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNBOUNDED_LOOP_BEHAVIOUR_OPERATION_COUNT = SINGLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ConditionalBehaviourImpl <em>Conditional Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ConditionalBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConditionalBehaviour()
	 * @generated
	 */
	int CONDITIONAL_BEHAVIOUR = 72;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__COMMENT = MULTIPLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__ANNOTATION = MULTIPLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__NAME = MULTIPLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__TEST_OBJECTIVE = MULTIPLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__PERIODIC = MULTIPLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__EXCEPTIONAL = MULTIPLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR__BLOCK = MULTIPLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Conditional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR_FEATURE_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR___CONTAINER = MULTIPLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR___IS_TESTER_INPUT_EVENT = MULTIPLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = MULTIPLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Conditional Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_BEHAVIOUR_OPERATION_COUNT = MULTIPLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CompoundBehaviourImpl <em>Compound Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CompoundBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCompoundBehaviour()
	 * @generated
	 */
	int COMPOUND_BEHAVIOUR = 73;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__COMMENT = SINGLE_COMBINED_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__ANNOTATION = SINGLE_COMBINED_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__NAME = SINGLE_COMBINED_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__TEST_OBJECTIVE = SINGLE_COMBINED_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Periodic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__PERIODIC = SINGLE_COMBINED_BEHAVIOUR__PERIODIC;

	/**
	 * The feature id for the '<em><b>Exceptional</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__EXCEPTIONAL = SINGLE_COMBINED_BEHAVIOUR__EXCEPTIONAL;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR__BLOCK = SINGLE_COMBINED_BEHAVIOUR__BLOCK;

	/**
	 * The number of structural features of the '<em>Compound Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR_FEATURE_COUNT = SINGLE_COMBINED_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR___CONTAINER = SINGLE_COMBINED_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = SINGLE_COMBINED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR___IS_TESTER_INPUT_EVENT = SINGLE_COMBINED_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Compound Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_BEHAVIOUR_OPERATION_COUNT = SINGLE_COMBINED_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DefaultBehaviourImpl <em>Default Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DefaultBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDefaultBehaviour()
	 * @generated
	 */
	int DEFAULT_BEHAVIOUR = 74;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__COMMENT = EXCEPTIONAL_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__ANNOTATION = EXCEPTIONAL_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__NAME = EXCEPTIONAL_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__TEST_OBJECTIVE = EXCEPTIONAL_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__BLOCK = EXCEPTIONAL_BEHAVIOUR__BLOCK;

	/**
	 * The feature id for the '<em><b>Guarded Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR__GUARDED_COMPONENT = EXCEPTIONAL_BEHAVIOUR__GUARDED_COMPONENT;

	/**
	 * The number of structural features of the '<em>Default Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR_FEATURE_COUNT = EXCEPTIONAL_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR___CONTAINER = EXCEPTIONAL_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = EXCEPTIONAL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR___IS_TESTER_INPUT_EVENT = EXCEPTIONAL_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = EXCEPTIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Default Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_BEHAVIOUR_OPERATION_COUNT = EXCEPTIONAL_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.InterruptBehaviourImpl <em>Interrupt Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.InterruptBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInterruptBehaviour()
	 * @generated
	 */
	int INTERRUPT_BEHAVIOUR = 75;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__COMMENT = EXCEPTIONAL_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__ANNOTATION = EXCEPTIONAL_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__NAME = EXCEPTIONAL_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__TEST_OBJECTIVE = EXCEPTIONAL_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__BLOCK = EXCEPTIONAL_BEHAVIOUR__BLOCK;

	/**
	 * The feature id for the '<em><b>Guarded Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR__GUARDED_COMPONENT = EXCEPTIONAL_BEHAVIOUR__GUARDED_COMPONENT;

	/**
	 * The number of structural features of the '<em>Interrupt Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR_FEATURE_COUNT = EXCEPTIONAL_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR___CONTAINER = EXCEPTIONAL_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = EXCEPTIONAL_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR___IS_TESTER_INPUT_EVENT = EXCEPTIONAL_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = EXCEPTIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Interrupt Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_BEHAVIOUR_OPERATION_COUNT = EXCEPTIONAL_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TargetImpl <em>Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TargetImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTarget()
	 * @generated
	 */
	int TARGET = 76;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Target Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__TARGET_GATE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value Assignment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__VALUE_ASSIGNMENT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.VerdictAssignmentImpl <em>Verdict Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.VerdictAssignmentImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVerdictAssignment()
	 * @generated
	 */
	int VERDICT_ASSIGNMENT = 77;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Verdict</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT__VERDICT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Verdict Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Verdict Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERDICT_ASSIGNMENT_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ActionBehaviourImpl <em>Action Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ActionBehaviourImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getActionBehaviour()
	 * @generated
	 */
	int ACTION_BEHAVIOUR = 82;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR__COMPONENT_INSTANCE = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Action Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Action Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_BEHAVIOUR_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AssertionImpl <em>Assertion</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AssertionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAssertion()
	 * @generated
	 */
	int ASSERTION = 78;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__COMMENT = ACTION_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__ANNOTATION = ACTION_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__NAME = ACTION_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__TEST_OBJECTIVE = ACTION_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__TIME_CONSTRAINT = ACTION_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__TIME_LABEL = ACTION_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__COMPONENT_INSTANCE = ACTION_BEHAVIOUR__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Otherwise</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__OTHERWISE = ACTION_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION__CONDITION = ACTION_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Assertion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION_FEATURE_COUNT = ACTION_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION___CONTAINER = ACTION_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION___GET_PARENT_TEST_DESCRIPTION = ACTION_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION___IS_TESTER_INPUT_EVENT = ACTION_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION___GET_PARTICIPATING_COMPONENTS = ACTION_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Assertion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERTION_OPERATION_COUNT = ACTION_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.StopImpl <em>Stop</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.StopImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStop()
	 * @generated
	 */
	int STOP = 79;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The number of structural features of the '<em>Stop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Stop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.BreakImpl <em>Break</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.BreakImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBreak()
	 * @generated
	 */
	int BREAK = 80;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The number of structural features of the '<em>Break</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Break</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BREAK_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.AssignmentImpl <em>Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.AssignmentImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT = 81;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__VARIABLE = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__EXPRESSION = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.InlineActionImpl <em>Inline Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.InlineActionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInlineAction()
	 * @generated
	 */
	int INLINE_ACTION = 83;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__COMMENT = ACTION_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__ANNOTATION = ACTION_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__NAME = ACTION_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__TEST_OBJECTIVE = ACTION_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__TIME_CONSTRAINT = ACTION_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__TIME_LABEL = ACTION_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__COMPONENT_INSTANCE = ACTION_BEHAVIOUR__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION__BODY = ACTION_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Inline Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION_FEATURE_COUNT = ACTION_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION___CONTAINER = ACTION_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION___GET_PARENT_TEST_DESCRIPTION = ACTION_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION___IS_TESTER_INPUT_EVENT = ACTION_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION___GET_PARTICIPATING_COMPONENTS = ACTION_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Inline Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_ACTION_OPERATION_COUNT = ACTION_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ActionReferenceImpl <em>Action Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ActionReferenceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getActionReference()
	 * @generated
	 */
	int ACTION_REFERENCE = 84;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__COMMENT = ACTION_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__ANNOTATION = ACTION_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__NAME = ACTION_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__TEST_OBJECTIVE = ACTION_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__TIME_CONSTRAINT = ACTION_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__TIME_LABEL = ACTION_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__COMPONENT_INSTANCE = ACTION_BEHAVIOUR__COMPONENT_INSTANCE;

	/**
	 * The feature id for the '<em><b>Action</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__ACTION = ACTION_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE__ARGUMENT = ACTION_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Action Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE_FEATURE_COUNT = ACTION_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE___CONTAINER = ACTION_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ACTION_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE___IS_TESTER_INPUT_EVENT = ACTION_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE___GET_PARTICIPATING_COMPONENTS = ACTION_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Action Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_REFERENCE_OPERATION_COUNT = ACTION_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.TestDescriptionReferenceImpl <em>Test Description Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.TestDescriptionReferenceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestDescriptionReference()
	 * @generated
	 */
	int TEST_DESCRIPTION_REFERENCE = 85;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Test Description</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__TEST_DESCRIPTION = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Instance Binding</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__COMPONENT_INSTANCE_BINDING = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE__ARGUMENT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Test Description Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Test Description Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_DESCRIPTION_REFERENCE_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ComponentInstanceBindingImpl <em>Component Instance Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ComponentInstanceBindingImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstanceBinding()
	 * @generated
	 */
	int COMPONENT_INSTANCE_BINDING = 86;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Formal Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING__FORMAL_COMPONENT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Actual Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING__ACTUAL_COMPONENT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Instance Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Component Instance Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_BINDING_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.InteractionImpl <em>Interaction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.InteractionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInteraction()
	 * @generated
	 */
	int INTERACTION = 87;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__COMMENT = ATOMIC_BEHAVIOUR__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__ANNOTATION = ATOMIC_BEHAVIOUR__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__NAME = ATOMIC_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__TEST_OBJECTIVE = ATOMIC_BEHAVIOUR__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__TIME_CONSTRAINT = ATOMIC_BEHAVIOUR__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__TIME_LABEL = ATOMIC_BEHAVIOUR__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Source Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__SOURCE_GATE = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION__TARGET = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FEATURE_COUNT = ATOMIC_BEHAVIOUR_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION___CONTAINER = ATOMIC_BEHAVIOUR___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION___GET_PARENT_TEST_DESCRIPTION = ATOMIC_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION___IS_TESTER_INPUT_EVENT = ATOMIC_BEHAVIOUR___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION___GET_PARTICIPATING_COMPONENTS = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Interaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION_OPERATION_COUNT = ATOMIC_BEHAVIOUR_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MessageImpl <em>Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MessageImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMessage()
	 * @generated
	 */
	int MESSAGE = 88;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__COMMENT = INTERACTION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ANNOTATION = INTERACTION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__NAME = INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__TEST_OBJECTIVE = INTERACTION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__TIME_CONSTRAINT = INTERACTION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__TIME_LABEL = INTERACTION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Source Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__SOURCE_GATE = INTERACTION__SOURCE_GATE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__TARGET = INTERACTION__TARGET;

	/**
	 * The feature id for the '<em><b>Is Trigger</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__IS_TRIGGER = INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ARGUMENT = INTERACTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FEATURE_COUNT = INTERACTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE___CONTAINER = INTERACTION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE___GET_PARENT_TEST_DESCRIPTION = INTERACTION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE___IS_TESTER_INPUT_EVENT = INTERACTION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE___GET_PARTICIPATING_COMPONENTS = INTERACTION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_OPERATION_COUNT = INTERACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.PredefinedFunctionImpl <em>Predefined Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.PredefinedFunctionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPredefinedFunction()
	 * @generated
	 */
	int PREDEFINED_FUNCTION = 89;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION__RETURN_TYPE = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Predefined Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Predefined Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.MemberReferenceImpl <em>Member Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.MemberReferenceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMemberReference()
	 * @generated
	 */
	int MEMBER_REFERENCE = 90;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE__MEMBER = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Collection Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE__COLLECTION_INDEX = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Member Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Member Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_REFERENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.PredefinedFunctionCallImpl <em>Predefined Function Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.PredefinedFunctionCallImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPredefinedFunctionCall()
	 * @generated
	 */
	int PREDEFINED_FUNCTION_CALL = 91;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__COMMENT = DYNAMIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__ANNOTATION = DYNAMIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__NAME = DYNAMIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__ARGUMENT = DYNAMIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__REDUCTION = DYNAMIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__FUNCTION = DYNAMIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Actual Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL__ACTUAL_PARAMETERS = DYNAMIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Predefined Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL_FEATURE_COUNT = DYNAMIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL___CONTAINER = DYNAMIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL___GET_PARENT_TEST_DESCRIPTION = DYNAMIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL___IS_EFFECTIVELY_STATIC = DYNAMIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL___RESOLVE_DATA_TYPE = DYNAMIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Predefined Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_FUNCTION_CALL_OPERATION_COUNT = DYNAMIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.LocalExpressionImpl <em>Local Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.LocalExpressionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getLocalExpression()
	 * @generated
	 */
	int LOCAL_EXPRESSION = 92;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION__EXPRESSION = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION__COMPONENT_INSTANCE = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Local Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Local Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_EXPRESSION_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ValueAssignmentImpl <em>Value Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ValueAssignmentImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getValueAssignment()
	 * @generated
	 */
	int VALUE_ASSIGNMENT = 93;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT__VARIABLE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT__PARAMETER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Value Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Value Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_ASSIGNMENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ProcedureCallImpl <em>Procedure Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ProcedureCallImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureCall()
	 * @generated
	 */
	int PROCEDURE_CALL = 94;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__COMMENT = INTERACTION__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__ANNOTATION = INTERACTION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__NAME = INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Test Objective</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__TEST_OBJECTIVE = INTERACTION__TEST_OBJECTIVE;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__TIME_CONSTRAINT = INTERACTION__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__TIME_LABEL = INTERACTION__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Source Gate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__SOURCE_GATE = INTERACTION__SOURCE_GATE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__TARGET = INTERACTION__TARGET;

	/**
	 * The feature id for the '<em><b>Signature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__SIGNATURE = INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__ARGUMENT = INTERACTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reply To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL__REPLY_TO = INTERACTION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Procedure Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL_FEATURE_COUNT = INTERACTION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL___CONTAINER = INTERACTION___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL___GET_PARENT_TEST_DESCRIPTION = INTERACTION___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Tester Input Event</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL___IS_TESTER_INPUT_EVENT = INTERACTION___IS_TESTER_INPUT_EVENT;

	/**
	 * The operation id for the '<em>Get Participating Components</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL___GET_PARTICIPATING_COMPONENTS = INTERACTION___GET_PARTICIPATING_COMPONENTS;

	/**
	 * The number of operations of the '<em>Procedure Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_CALL_OPERATION_COUNT = INTERACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ProcedureSignatureImpl <em>Procedure Signature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ProcedureSignatureImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureSignature()
	 * @generated
	 */
	int PROCEDURE_SIGNATURE = 95;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__COMMENT = DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__ANNOTATION = DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__NAME = DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__QUALIFIED_NAME = DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__CONSTRAINT = DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE__PARAMETER = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Procedure Signature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___CONTAINER = DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___GET_PARENT_TEST_DESCRIPTION = DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___CONFORMS_TO__STRING = DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___GET_ELEMENT_NAMED__STRING = DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE___ALL_CONSTRAINTS = DATA_TYPE___ALL_CONSTRAINTS;

	/**
	 * The number of operations of the '<em>Procedure Signature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_SIGNATURE_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ProcedureParameterImpl <em>Procedure Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ProcedureParameterImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureParameter()
	 * @generated
	 */
	int PROCEDURE_PARAMETER = 96;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__COMMENT = PARAMETER__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__ANNOTATION = PARAMETER__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__NAME = PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__QUALIFIED_NAME = PARAMETER__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__DATA_TYPE = PARAMETER__DATA_TYPE;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER__KIND = PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Procedure Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER_FEATURE_COUNT = PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER___CONTAINER = PARAMETER___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER___GET_PARENT_TEST_DESCRIPTION = PARAMETER___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Procedure Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PARAMETER_OPERATION_COUNT = PARAMETER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CollectionDataTypeImpl <em>Collection Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CollectionDataTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCollectionDataType()
	 * @generated
	 */
	int COLLECTION_DATA_TYPE = 97;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__COMMENT = DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__ANNOTATION = DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__NAME = DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__QUALIFIED_NAME = DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__CONSTRAINT = DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Item Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE__ITEM_TYPE = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Collection Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___CONTAINER = DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION = DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___CONFORMS_TO__STRING = DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___GET_ELEMENT_NAMED__STRING = DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE___ALL_CONSTRAINTS = DATA_TYPE___ALL_CONSTRAINTS;

	/**
	 * The number of operations of the '<em>Collection Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_TYPE_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CollectionDataInstanceImpl <em>Collection Data Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CollectionDataInstanceImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCollectionDataInstance()
	 * @generated
	 */
	int COLLECTION_DATA_INSTANCE = 98;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__COMMENT = DATA_INSTANCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__ANNOTATION = DATA_INSTANCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__NAME = DATA_INSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__QUALIFIED_NAME = DATA_INSTANCE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__DATA_TYPE = DATA_INSTANCE__DATA_TYPE;

	/**
	 * The feature id for the '<em><b>Item</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__ITEM = DATA_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unassigned Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE__UNASSIGNED_MEMBER = DATA_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Collection Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE_FEATURE_COUNT = DATA_INSTANCE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE___CONTAINER = DATA_INSTANCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION = DATA_INSTANCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE___CONFORMS_TO__STRING = DATA_INSTANCE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE___GET_ELEMENT_NAMED__STRING = DATA_INSTANCE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT = DATA_INSTANCE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Collection Data Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_DATA_INSTANCE_OPERATION_COUNT = DATA_INSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ExtensionImpl <em>Extension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ExtensionImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getExtension()
	 * @generated
	 */
	int EXTENSION = 99;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Extending</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION__EXTENDING = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Transitive Extending</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION___TRANSITIVE_EXTENDING = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Extending</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION___IS_EXTENDING__PACKAGEABLEELEMENT = ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENSION_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.LiteralValueUseImpl <em>Literal Value Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.LiteralValueUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getLiteralValueUse()
	 * @generated
	 */
	int LITERAL_VALUE_USE = 100;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__COMMENT = STATIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__ANNOTATION = STATIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__NAME = STATIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__ARGUMENT = STATIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__REDUCTION = STATIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__VALUE = STATIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Int Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__INT_VALUE = STATIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bool Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__BOOL_VALUE = STATIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE__DATA_TYPE = STATIC_DATA_USE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Literal Value Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE_FEATURE_COUNT = STATIC_DATA_USE_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE___CONTAINER = STATIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE___GET_PARENT_TEST_DESCRIPTION = STATIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE___IS_EFFECTIVELY_STATIC = STATIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE___RESOLVE_DATA_TYPE = STATIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Literal Value Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_USE_OPERATION_COUNT = STATIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ConstraintTypeImpl <em>Constraint Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ConstraintTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConstraintType()
	 * @generated
	 */
	int CONSTRAINT_TYPE = 101;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE__COMMENT = PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE__ANNOTATION = PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE__NAME = PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE__QUALIFIED_NAME = PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Constraint Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE_FEATURE_COUNT = PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE___CONTAINER = PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE___GET_PARENT_TEST_DESCRIPTION = PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE___CONFORMS_TO__STRING = PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE___GET_ELEMENT_NAMED__STRING = PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The number of operations of the '<em>Constraint Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_TYPE_OPERATION_COUNT = PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.ConstraintImpl <em>Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.ConstraintImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConstraint()
	 * @generated
	 */
	int CONSTRAINT = 102;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT__TYPE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Quantifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT__QUANTIFIER = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The number of operations of the '<em>Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.EnumDataTypeImpl <em>Enum Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.EnumDataTypeImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getEnumDataType()
	 * @generated
	 */
	int ENUM_DATA_TYPE = 103;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__COMMENT = SIMPLE_DATA_TYPE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__ANNOTATION = SIMPLE_DATA_TYPE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__NAME = SIMPLE_DATA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__QUALIFIED_NAME = SIMPLE_DATA_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__CONSTRAINT = SIMPLE_DATA_TYPE__CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Extension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__EXTENSION = SIMPLE_DATA_TYPE__EXTENSION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE__VALUE = SIMPLE_DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enum Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE_FEATURE_COUNT = SIMPLE_DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___CONTAINER = SIMPLE_DATA_TYPE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION = SIMPLE_DATA_TYPE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___CONFORMS_TO__STRING = SIMPLE_DATA_TYPE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___GET_ELEMENT_NAMED__STRING = SIMPLE_DATA_TYPE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT = SIMPLE_DATA_TYPE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>All Constraints</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE___ALL_CONSTRAINTS = SIMPLE_DATA_TYPE___ALL_CONSTRAINTS;

	/**
	 * The number of operations of the '<em>Enum Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_DATA_TYPE_OPERATION_COUNT = SIMPLE_DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.DataElementUseImpl <em>Data Element Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.DataElementUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataElementUse()
	 * @generated
	 */
	int DATA_ELEMENT_USE = 104;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__COMMENT = DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__ANNOTATION = DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__NAME = DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__ARGUMENT = DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__REDUCTION = DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Unassigned Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__UNASSIGNED_MEMBER = DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__DATA_ELEMENT = DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Item</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE__ITEM = DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Data Element Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE_FEATURE_COUNT = DATA_USE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE___CONTAINER = DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE___GET_PARENT_TEST_DESCRIPTION = DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE___IS_EFFECTIVELY_STATIC = DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE___RESOLVE_DATA_TYPE = DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Data Element Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_ELEMENT_USE_OPERATION_COUNT = DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.impl.CastDataUseImpl <em>Cast Data Use</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.impl.CastDataUseImpl
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCastDataUse()
	 * @generated
	 */
	int CAST_DATA_USE = 105;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__COMMENT = STATIC_DATA_USE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__ANNOTATION = STATIC_DATA_USE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__NAME = STATIC_DATA_USE__NAME;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__ARGUMENT = STATIC_DATA_USE__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Reduction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__REDUCTION = STATIC_DATA_USE__REDUCTION;

	/**
	 * The feature id for the '<em><b>Data Use</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__DATA_USE = STATIC_DATA_USE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE__DATA_TYPE = STATIC_DATA_USE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Cast Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE_FEATURE_COUNT = STATIC_DATA_USE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE___CONTAINER = STATIC_DATA_USE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE___GET_PARENT_TEST_DESCRIPTION = STATIC_DATA_USE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Is Effectively Static</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE___IS_EFFECTIVELY_STATIC = STATIC_DATA_USE___IS_EFFECTIVELY_STATIC;

	/**
	 * The operation id for the '<em>Resolve Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE___RESOLVE_DATA_TYPE = STATIC_DATA_USE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Cast Data Use</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_DATA_USE_OPERATION_COUNT = STATIC_DATA_USE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.UnassignedMemberTreatment <em>Unassigned Member Treatment</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.UnassignedMemberTreatment
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getUnassignedMemberTreatment()
	 * @generated
	 */
	int UNASSIGNED_MEMBER_TREATMENT = 106;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.ComponentInstanceRole <em>Component Instance Role</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.ComponentInstanceRole
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstanceRole()
	 * @generated
	 */
	int COMPONENT_INSTANCE_ROLE = 107;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.GateTypeKind <em>Gate Type Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.GateTypeKind
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateTypeKind()
	 * @generated
	 */
	int GATE_TYPE_KIND = 108;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.TimeLabelUseKind <em>Time Label Use Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.TimeLabelUseKind
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabelUseKind()
	 * @generated
	 */
	int TIME_LABEL_USE_KIND = 109;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.ParameterKind <em>Parameter Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.ParameterKind
	 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterKind()
	 * @generated
	 */
	int PARAMETER_KIND = 110;


	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Element <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see org.etsi.mts.tdl.Element
	 * @generated
	 */
	EClass getElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Element#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Comment</em>'.
	 * @see org.etsi.mts.tdl.Element#getComment()
	 * @see #getElement()
	 * @generated
	 */
	EReference getElement_Comment();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Element#getAnnotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotation</em>'.
	 * @see org.etsi.mts.tdl.Element#getAnnotation()
	 * @see #getElement()
	 * @generated
	 */
	EReference getElement_Annotation();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Element#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.etsi.mts.tdl.Element#getName()
	 * @see #getElement()
	 * @generated
	 */
	EAttribute getElement_Name();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Element#container() <em>Container</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Container</em>' operation.
	 * @see org.etsi.mts.tdl.Element#container()
	 * @generated
	 */
	EOperation getElement__Container();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Element#getParentTestDescription() <em>Get Parent Test Description</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Parent Test Description</em>' operation.
	 * @see org.etsi.mts.tdl.Element#getParentTestDescription()
	 * @generated
	 */
	EOperation getElement__GetParentTestDescription();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Comment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comment</em>'.
	 * @see org.etsi.mts.tdl.Comment
	 * @generated
	 */
	EClass getComment();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Comment#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body</em>'.
	 * @see org.etsi.mts.tdl.Comment#getBody()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_Body();

	/**
	 * Returns the meta object for the container reference '{@link org.etsi.mts.tdl.Comment#getCommentedElement <em>Commented Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Commented Element</em>'.
	 * @see org.etsi.mts.tdl.Comment#getCommentedElement()
	 * @see #getComment()
	 * @generated
	 */
	EReference getComment_CommentedElement();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation</em>'.
	 * @see org.etsi.mts.tdl.Annotation
	 * @generated
	 */
	EClass getAnnotation();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Annotation#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.Annotation#getValue()
	 * @see #getAnnotation()
	 * @generated
	 */
	EAttribute getAnnotation_Value();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Annotation#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see org.etsi.mts.tdl.Annotation#getKey()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Key();

	/**
	 * Returns the meta object for the container reference '{@link org.etsi.mts.tdl.Annotation#getAnnotatedElement <em>Annotated Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Annotated Element</em>'.
	 * @see org.etsi.mts.tdl.Annotation#getAnnotatedElement()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_AnnotatedElement();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.AnnotationType <em>Annotation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation Type</em>'.
	 * @see org.etsi.mts.tdl.AnnotationType
	 * @generated
	 */
	EClass getAnnotationType();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.AnnotationType#getExtension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.AnnotationType#getExtension()
	 * @see #getAnnotationType()
	 * @generated
	 */
	EReference getAnnotationType_Extension();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.PackageableElement <em>Packageable Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Packageable Element</em>'.
	 * @see org.etsi.mts.tdl.PackageableElement
	 * @generated
	 */
	EClass getPackageableElement();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.PackageableElement#conformsTo(java.lang.String) <em>Conforms To</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Conforms To</em>' operation.
	 * @see org.etsi.mts.tdl.PackageableElement#conformsTo(java.lang.String)
	 * @generated
	 */
	EOperation getPackageableElement__ConformsTo__String();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.PackageableElement#getElementNamed(java.lang.String) <em>Get Element Named</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Element Named</em>' operation.
	 * @see org.etsi.mts.tdl.PackageableElement#getElementNamed(java.lang.String)
	 * @generated
	 */
	EOperation getPackageableElement__GetElementNamed__String();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.PackageableElement#conformsTo(org.etsi.mts.tdl.PackageableElement) <em>Conforms To</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Conforms To</em>' operation.
	 * @see org.etsi.mts.tdl.PackageableElement#conformsTo(org.etsi.mts.tdl.PackageableElement)
	 * @generated
	 */
	EOperation getPackageableElement__ConformsTo__PackageableElement();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.NamedElement <em>Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Named Element</em>'.
	 * @see org.etsi.mts.tdl.NamedElement
	 * @generated
	 */
	EClass getNamedElement();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.NamedElement#getQualifiedName <em>Qualified Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qualified Name</em>'.
	 * @see org.etsi.mts.tdl.NamedElement#getQualifiedName()
	 * @see #getNamedElement()
	 * @generated
	 */
	EAttribute getNamedElement_QualifiedName();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Package <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package</em>'.
	 * @see org.etsi.mts.tdl.Package
	 * @generated
	 */
	EClass getPackage();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Package#getPackagedElement <em>Packaged Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Packaged Element</em>'.
	 * @see org.etsi.mts.tdl.Package#getPackagedElement()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_PackagedElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Package#getImport <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Import</em>'.
	 * @see org.etsi.mts.tdl.Package#getImport()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Import();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Package#getNestedPackage <em>Nested Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nested Package</em>'.
	 * @see org.etsi.mts.tdl.Package#getNestedPackage()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_NestedPackage();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ElementImport <em>Element Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element Import</em>'.
	 * @see org.etsi.mts.tdl.ElementImport
	 * @generated
	 */
	EClass getElementImport();

	/**
	 * Returns the meta object for the reference list '{@link org.etsi.mts.tdl.ElementImport#getImportedElement <em>Imported Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Imported Element</em>'.
	 * @see org.etsi.mts.tdl.ElementImport#getImportedElement()
	 * @see #getElementImport()
	 * @generated
	 */
	EReference getElementImport_ImportedElement();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ElementImport#getImportedPackage <em>Imported Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Imported Package</em>'.
	 * @see org.etsi.mts.tdl.ElementImport#getImportedPackage()
	 * @see #getElementImport()
	 * @generated
	 */
	EReference getElementImport_ImportedPackage();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TestObjective <em>Test Objective</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Objective</em>'.
	 * @see org.etsi.mts.tdl.TestObjective
	 * @generated
	 */
	EClass getTestObjective();

	/**
	 * Returns the meta object for the attribute list '{@link org.etsi.mts.tdl.TestObjective#getObjectiveURI <em>Objective URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Objective URI</em>'.
	 * @see org.etsi.mts.tdl.TestObjective#getObjectiveURI()
	 * @see #getTestObjective()
	 * @generated
	 */
	EAttribute getTestObjective_ObjectiveURI();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.TestObjective#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.etsi.mts.tdl.TestObjective#getDescription()
	 * @see #getTestObjective()
	 * @generated
	 */
	EAttribute getTestObjective_Description();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataInstance <em>Data Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Instance</em>'.
	 * @see org.etsi.mts.tdl.DataInstance
	 * @generated
	 */
	EClass getDataInstance();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataInstance#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.DataInstance#getDataType()
	 * @see #getDataInstance()
	 * @generated
	 */
	EReference getDataInstance_DataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.MappableDataElement <em>Mappable Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mappable Data Element</em>'.
	 * @see org.etsi.mts.tdl.MappableDataElement
	 * @generated
	 */
	EClass getMappableDataElement();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.DataType
	 * @generated
	 */
	EClass getDataType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataType#getConstraint <em>Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraint</em>'.
	 * @see org.etsi.mts.tdl.DataType#getConstraint()
	 * @see #getDataType()
	 * @generated
	 */
	EReference getDataType_Constraint();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.DataType#allConstraints() <em>All Constraints</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Constraints</em>' operation.
	 * @see org.etsi.mts.tdl.DataType#allConstraints()
	 * @generated
	 */
	EOperation getDataType__AllConstraints();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataResourceMapping <em>Data Resource Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Resource Mapping</em>'.
	 * @see org.etsi.mts.tdl.DataResourceMapping
	 * @generated
	 */
	EClass getDataResourceMapping();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.DataResourceMapping#getResourceURI <em>Resource URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Resource URI</em>'.
	 * @see org.etsi.mts.tdl.DataResourceMapping#getResourceURI()
	 * @see #getDataResourceMapping()
	 * @generated
	 */
	EAttribute getDataResourceMapping_ResourceURI();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataElementMapping <em>Data Element Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Element Mapping</em>'.
	 * @see org.etsi.mts.tdl.DataElementMapping
	 * @generated
	 */
	EClass getDataElementMapping();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataElementMapping#getMappableDataElement <em>Mappable Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Mappable Data Element</em>'.
	 * @see org.etsi.mts.tdl.DataElementMapping#getMappableDataElement()
	 * @see #getDataElementMapping()
	 * @generated
	 */
	EReference getDataElementMapping_MappableDataElement();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.DataElementMapping#getElementURI <em>Element URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Element URI</em>'.
	 * @see org.etsi.mts.tdl.DataElementMapping#getElementURI()
	 * @see #getDataElementMapping()
	 * @generated
	 */
	EAttribute getDataElementMapping_ElementURI();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataElementMapping#getDataResourceMapping <em>Data Resource Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Resource Mapping</em>'.
	 * @see org.etsi.mts.tdl.DataElementMapping#getDataResourceMapping()
	 * @see #getDataElementMapping()
	 * @generated
	 */
	EReference getDataElementMapping_DataResourceMapping();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataElementMapping#getParameterMapping <em>Parameter Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameter Mapping</em>'.
	 * @see org.etsi.mts.tdl.DataElementMapping#getParameterMapping()
	 * @see #getDataElementMapping()
	 * @generated
	 */
	EReference getDataElementMapping_ParameterMapping();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ParameterMapping <em>Parameter Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter Mapping</em>'.
	 * @see org.etsi.mts.tdl.ParameterMapping
	 * @generated
	 */
	EClass getParameterMapping();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.ParameterMapping#getParameterURI <em>Parameter URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parameter URI</em>'.
	 * @see org.etsi.mts.tdl.ParameterMapping#getParameterURI()
	 * @see #getParameterMapping()
	 * @generated
	 */
	EAttribute getParameterMapping_ParameterURI();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ParameterMapping#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.ParameterMapping#getParameter()
	 * @see #getParameterMapping()
	 * @generated
	 */
	EReference getParameterMapping_Parameter();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Parameter#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.Parameter#getDataType()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_DataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.SimpleDataType <em>Simple Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Data Type</em>'.
	 * @see org.etsi.mts.tdl.SimpleDataType
	 * @generated
	 */
	EClass getSimpleDataType();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.SimpleDataType#getExtension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.SimpleDataType#getExtension()
	 * @see #getSimpleDataType()
	 * @generated
	 */
	EReference getSimpleDataType_Extension();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.SimpleDataType#allConstraints() <em>All Constraints</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Constraints</em>' operation.
	 * @see org.etsi.mts.tdl.SimpleDataType#allConstraints()
	 * @generated
	 */
	EOperation getSimpleDataType__AllConstraints();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.SimpleDataInstance <em>Simple Data Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Data Instance</em>'.
	 * @see org.etsi.mts.tdl.SimpleDataInstance
	 * @generated
	 */
	EClass getSimpleDataInstance();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.StructuredDataType <em>Structured Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Structured Data Type</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataType
	 * @generated
	 */
	EClass getStructuredDataType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.StructuredDataType#getExtension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataType#getExtension()
	 * @see #getStructuredDataType()
	 * @generated
	 */
	EReference getStructuredDataType_Extension();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.StructuredDataType#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Member</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataType#getMember()
	 * @see #getStructuredDataType()
	 * @generated
	 */
	EReference getStructuredDataType_Member();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.StructuredDataType#allMembers() <em>All Members</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Members</em>' operation.
	 * @see org.etsi.mts.tdl.StructuredDataType#allMembers()
	 * @generated
	 */
	EOperation getStructuredDataType__AllMembers();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.StructuredDataType#allConstraints() <em>All Constraints</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Constraints</em>' operation.
	 * @see org.etsi.mts.tdl.StructuredDataType#allConstraints()
	 * @generated
	 */
	EOperation getStructuredDataType__AllConstraints();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Member <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member</em>'.
	 * @see org.etsi.mts.tdl.Member
	 * @generated
	 */
	EClass getMember();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Member#isIsOptional <em>Is Optional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Optional</em>'.
	 * @see org.etsi.mts.tdl.Member#isIsOptional()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_IsOptional();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Member#getConstraint <em>Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraint</em>'.
	 * @see org.etsi.mts.tdl.Member#getConstraint()
	 * @see #getMember()
	 * @generated
	 */
	EReference getMember_Constraint();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.StructuredDataInstance <em>Structured Data Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Structured Data Instance</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataInstance
	 * @generated
	 */
	EClass getStructuredDataInstance();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.StructuredDataInstance#getMemberAssignment <em>Member Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Member Assignment</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataInstance#getMemberAssignment()
	 * @see #getStructuredDataInstance()
	 * @generated
	 */
	EReference getStructuredDataInstance_MemberAssignment();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.StructuredDataInstance#getUnassignedMember <em>Unassigned Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unassigned Member</em>'.
	 * @see org.etsi.mts.tdl.StructuredDataInstance#getUnassignedMember()
	 * @see #getStructuredDataInstance()
	 * @generated
	 */
	EAttribute getStructuredDataInstance_UnassignedMember();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.MemberAssignment <em>Member Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member Assignment</em>'.
	 * @see org.etsi.mts.tdl.MemberAssignment
	 * @generated
	 */
	EClass getMemberAssignment();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.MemberAssignment#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Member</em>'.
	 * @see org.etsi.mts.tdl.MemberAssignment#getMember()
	 * @see #getMemberAssignment()
	 * @generated
	 */
	EReference getMemberAssignment_Member();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.MemberAssignment#getMemberSpec <em>Member Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Member Spec</em>'.
	 * @see org.etsi.mts.tdl.MemberAssignment#getMemberSpec()
	 * @see #getMemberAssignment()
	 * @generated
	 */
	EReference getMemberAssignment_MemberSpec();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.StaticDataUse <em>Static Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Static Data Use</em>'.
	 * @see org.etsi.mts.tdl.StaticDataUse
	 * @generated
	 */
	EClass getStaticDataUse();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataUse <em>Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Use</em>'.
	 * @see org.etsi.mts.tdl.DataUse
	 * @generated
	 */
	EClass getDataUse();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataUse#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Argument</em>'.
	 * @see org.etsi.mts.tdl.DataUse#getArgument()
	 * @see #getDataUse()
	 * @generated
	 */
	EReference getDataUse_Argument();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataUse#getReduction <em>Reduction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Reduction</em>'.
	 * @see org.etsi.mts.tdl.DataUse#getReduction()
	 * @see #getDataUse()
	 * @generated
	 */
	EReference getDataUse_Reduction();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.DataUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.DataUse#resolveDataType()
	 * @generated
	 */
	EOperation getDataUse__ResolveDataType();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.DataUse#isEffectivelyStatic() <em>Is Effectively Static</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Is Effectively Static</em>' operation.
	 * @see org.etsi.mts.tdl.DataUse#isEffectivelyStatic()
	 * @generated
	 */
	EOperation getDataUse__IsEffectivelyStatic();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ParameterBinding <em>Parameter Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter Binding</em>'.
	 * @see org.etsi.mts.tdl.ParameterBinding
	 * @generated
	 */
	EClass getParameterBinding();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.ParameterBinding#getDataUse <em>Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Data Use</em>'.
	 * @see org.etsi.mts.tdl.ParameterBinding#getDataUse()
	 * @see #getParameterBinding()
	 * @generated
	 */
	EReference getParameterBinding_DataUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ParameterBinding#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.ParameterBinding#getParameter()
	 * @see #getParameterBinding()
	 * @generated
	 */
	EReference getParameterBinding_Parameter();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ParameterBinding#getReduction <em>Reduction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Reduction</em>'.
	 * @see org.etsi.mts.tdl.ParameterBinding#getReduction()
	 * @see #getParameterBinding()
	 * @generated
	 */
	EReference getParameterBinding_Reduction();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ParameterBinding#resolveParameterType() <em>Resolve Parameter Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Parameter Type</em>' operation.
	 * @see org.etsi.mts.tdl.ParameterBinding#resolveParameterType()
	 * @generated
	 */
	EOperation getParameterBinding__ResolveParameterType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Action <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Action</em>'.
	 * @see org.etsi.mts.tdl.Action
	 * @generated
	 */
	EClass getAction();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Action#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body</em>'.
	 * @see org.etsi.mts.tdl.Action#getBody()
	 * @see #getAction()
	 * @generated
	 */
	EAttribute getAction_Body();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Action#getFormalParameter <em>Formal Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Formal Parameter</em>'.
	 * @see org.etsi.mts.tdl.Action#getFormalParameter()
	 * @see #getAction()
	 * @generated
	 */
	EReference getAction_FormalParameter();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.FormalParameter <em>Formal Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Formal Parameter</em>'.
	 * @see org.etsi.mts.tdl.FormalParameter
	 * @generated
	 */
	EClass getFormalParameter();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function</em>'.
	 * @see org.etsi.mts.tdl.Function
	 * @generated
	 */
	EClass getFunction();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Function#getReturnType <em>Return Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Return Type</em>'.
	 * @see org.etsi.mts.tdl.Function#getReturnType()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_ReturnType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.FormalParameterUse <em>Formal Parameter Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Formal Parameter Use</em>'.
	 * @see org.etsi.mts.tdl.FormalParameterUse
	 * @generated
	 */
	EClass getFormalParameterUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.FormalParameterUse#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.FormalParameterUse#getParameter()
	 * @see #getFormalParameterUse()
	 * @generated
	 */
	EReference getFormalParameterUse_Parameter();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.FormalParameterUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.FormalParameterUse#resolveDataType()
	 * @generated
	 */
	EOperation getFormalParameterUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DynamicDataUse <em>Dynamic Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dynamic Data Use</em>'.
	 * @see org.etsi.mts.tdl.DynamicDataUse
	 * @generated
	 */
	EClass getDynamicDataUse();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see org.etsi.mts.tdl.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Variable#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.Variable#getDataType()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_DataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.FunctionCall <em>Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Call</em>'.
	 * @see org.etsi.mts.tdl.FunctionCall
	 * @generated
	 */
	EClass getFunctionCall();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.FunctionCall#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Function</em>'.
	 * @see org.etsi.mts.tdl.FunctionCall#getFunction()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EReference getFunctionCall_Function();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.FunctionCall#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.FunctionCall#resolveDataType()
	 * @generated
	 */
	EOperation getFunctionCall__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.VariableUse <em>Variable Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable Use</em>'.
	 * @see org.etsi.mts.tdl.VariableUse
	 * @generated
	 */
	EClass getVariableUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.VariableUse#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.VariableUse#getComponentInstance()
	 * @see #getVariableUse()
	 * @generated
	 */
	EReference getVariableUse_ComponentInstance();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.VariableUse#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Variable</em>'.
	 * @see org.etsi.mts.tdl.VariableUse#getVariable()
	 * @see #getVariableUse()
	 * @generated
	 */
	EReference getVariableUse_Variable();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.VariableUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.VariableUse#resolveDataType()
	 * @generated
	 */
	EOperation getVariableUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstance
	 * @generated
	 */
	EClass getComponentInstance();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ComponentInstance#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstance#getType()
	 * @see #getComponentInstance()
	 * @generated
	 */
	EReference getComponentInstance_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.ComponentInstance#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstance#getRole()
	 * @see #getComponentInstance()
	 * @generated
	 */
	EAttribute getComponentInstance_Role();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ComponentType <em>Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Type</em>'.
	 * @see org.etsi.mts.tdl.ComponentType
	 * @generated
	 */
	EClass getComponentType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ComponentType#getGateInstance <em>Gate Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Gate Instance</em>'.
	 * @see org.etsi.mts.tdl.ComponentType#getGateInstance()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_GateInstance();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ComponentType#getTimer <em>Timer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Timer</em>'.
	 * @see org.etsi.mts.tdl.ComponentType#getTimer()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_Timer();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ComponentType#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variable</em>'.
	 * @see org.etsi.mts.tdl.ComponentType#getVariable()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_Variable();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.ComponentType#getExtension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.ComponentType#getExtension()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_Extension();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ComponentType#allGates() <em>All Gates</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Gates</em>' operation.
	 * @see org.etsi.mts.tdl.ComponentType#allGates()
	 * @generated
	 */
	EOperation getComponentType__AllGates();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ComponentType#allTimers() <em>All Timers</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Timers</em>' operation.
	 * @see org.etsi.mts.tdl.ComponentType#allTimers()
	 * @generated
	 */
	EOperation getComponentType__AllTimers();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ComponentType#allVariables() <em>All Variables</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Variables</em>' operation.
	 * @see org.etsi.mts.tdl.ComponentType#allVariables()
	 * @generated
	 */
	EOperation getComponentType__AllVariables();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.GateInstance <em>Gate Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gate Instance</em>'.
	 * @see org.etsi.mts.tdl.GateInstance
	 * @generated
	 */
	EClass getGateInstance();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.GateInstance#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.etsi.mts.tdl.GateInstance#getType()
	 * @see #getGateInstance()
	 * @generated
	 */
	EReference getGateInstance_Type();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.GateType <em>Gate Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gate Type</em>'.
	 * @see org.etsi.mts.tdl.GateType
	 * @generated
	 */
	EClass getGateType();

	/**
	 * Returns the meta object for the reference list '{@link org.etsi.mts.tdl.GateType#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.GateType#getDataType()
	 * @see #getGateType()
	 * @generated
	 */
	EReference getGateType_DataType();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.GateType#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.etsi.mts.tdl.GateType#getKind()
	 * @see #getGateType()
	 * @generated
	 */
	EAttribute getGateType_Kind();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.GateType#getExtension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.GateType#getExtension()
	 * @see #getGateType()
	 * @generated
	 */
	EReference getGateType_Extension();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.GateType#allDataTypes() <em>All Data Types</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>All Data Types</em>' operation.
	 * @see org.etsi.mts.tdl.GateType#allDataTypes()
	 * @generated
	 */
	EOperation getGateType__AllDataTypes();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Timer <em>Timer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Timer</em>'.
	 * @see org.etsi.mts.tdl.Timer
	 * @generated
	 */
	EClass getTimer();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.OmitValue <em>Omit Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Omit Value</em>'.
	 * @see org.etsi.mts.tdl.OmitValue
	 * @generated
	 */
	EClass getOmitValue();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.SpecialValueUse <em>Special Value Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Special Value Use</em>'.
	 * @see org.etsi.mts.tdl.SpecialValueUse
	 * @generated
	 */
	EClass getSpecialValueUse();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.SpecialValueUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.SpecialValueUse#resolveDataType()
	 * @generated
	 */
	EOperation getSpecialValueUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.AnyValue <em>Any Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Any Value</em>'.
	 * @see org.etsi.mts.tdl.AnyValue
	 * @generated
	 */
	EClass getAnyValue();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.AnyValue#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.AnyValue#getDataType()
	 * @see #getAnyValue()
	 * @generated
	 */
	EReference getAnyValue_DataType();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.AnyValue#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.AnyValue#resolveDataType()
	 * @generated
	 */
	EOperation getAnyValue__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.AnyValueOrOmit <em>Any Value Or Omit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Any Value Or Omit</em>'.
	 * @see org.etsi.mts.tdl.AnyValueOrOmit
	 * @generated
	 */
	EClass getAnyValueOrOmit();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataInstanceUse <em>Data Instance Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Instance Use</em>'.
	 * @see org.etsi.mts.tdl.DataInstanceUse
	 * @generated
	 */
	EClass getDataInstanceUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataInstanceUse#getDataInstance <em>Data Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Instance</em>'.
	 * @see org.etsi.mts.tdl.DataInstanceUse#getDataInstance()
	 * @see #getDataInstanceUse()
	 * @generated
	 */
	EReference getDataInstanceUse_DataInstance();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.DataInstanceUse#getUnassignedMember <em>Unassigned Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unassigned Member</em>'.
	 * @see org.etsi.mts.tdl.DataInstanceUse#getUnassignedMember()
	 * @see #getDataInstanceUse()
	 * @generated
	 */
	EAttribute getDataInstanceUse_UnassignedMember();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataInstanceUse#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.DataInstanceUse#getDataType()
	 * @see #getDataInstanceUse()
	 * @generated
	 */
	EReference getDataInstanceUse_DataType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataInstanceUse#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Item</em>'.
	 * @see org.etsi.mts.tdl.DataInstanceUse#getItem()
	 * @see #getDataInstanceUse()
	 * @generated
	 */
	EReference getDataInstanceUse_Item();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.DataInstanceUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.DataInstanceUse#resolveDataType()
	 * @generated
	 */
	EOperation getDataInstanceUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Time <em>Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time</em>'.
	 * @see org.etsi.mts.tdl.Time
	 * @generated
	 */
	EClass getTime();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimeLabel <em>Time Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Label</em>'.
	 * @see org.etsi.mts.tdl.TimeLabel
	 * @generated
	 */
	EClass getTimeLabel();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimerOperation <em>Timer Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Timer Operation</em>'.
	 * @see org.etsi.mts.tdl.TimerOperation
	 * @generated
	 */
	EClass getTimerOperation();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TimerOperation#getTimer <em>Timer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Timer</em>'.
	 * @see org.etsi.mts.tdl.TimerOperation#getTimer()
	 * @see #getTimerOperation()
	 * @generated
	 */
	EReference getTimerOperation_Timer();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TimerOperation#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.TimerOperation#getComponentInstance()
	 * @see #getTimerOperation()
	 * @generated
	 */
	EReference getTimerOperation_ComponentInstance();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.TimerOperation#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.TimerOperation#getParticipatingComponents()
	 * @generated
	 */
	EOperation getTimerOperation__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.AtomicBehaviour <em>Atomic Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Atomic Behaviour</em>'.
	 * @see org.etsi.mts.tdl.AtomicBehaviour
	 * @generated
	 */
	EClass getAtomicBehaviour();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.AtomicBehaviour#getTimeConstraint <em>Time Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Time Constraint</em>'.
	 * @see org.etsi.mts.tdl.AtomicBehaviour#getTimeConstraint()
	 * @see #getAtomicBehaviour()
	 * @generated
	 */
	EReference getAtomicBehaviour_TimeConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.AtomicBehaviour#getTimeLabel <em>Time Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Time Label</em>'.
	 * @see org.etsi.mts.tdl.AtomicBehaviour#getTimeLabel()
	 * @see #getAtomicBehaviour()
	 * @generated
	 */
	EReference getAtomicBehaviour_TimeLabel();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.AtomicBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.AtomicBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getAtomicBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Behaviour <em>Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behaviour</em>'.
	 * @see org.etsi.mts.tdl.Behaviour
	 * @generated
	 */
	EClass getBehaviour();

	/**
	 * Returns the meta object for the reference list '{@link org.etsi.mts.tdl.Behaviour#getTestObjective <em>Test Objective</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Test Objective</em>'.
	 * @see org.etsi.mts.tdl.Behaviour#getTestObjective()
	 * @see #getBehaviour()
	 * @generated
	 */
	EReference getBehaviour_TestObjective();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Behaviour#isTesterInputEvent() <em>Is Tester Input Event</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Is Tester Input Event</em>' operation.
	 * @see org.etsi.mts.tdl.Behaviour#isTesterInputEvent()
	 * @generated
	 */
	EOperation getBehaviour__IsTesterInputEvent();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Behaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.Behaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimeConstraint <em>Time Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Constraint</em>'.
	 * @see org.etsi.mts.tdl.TimeConstraint
	 * @generated
	 */
	EClass getTimeConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.TimeConstraint#getTimeConstraintExpression <em>Time Constraint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Time Constraint Expression</em>'.
	 * @see org.etsi.mts.tdl.TimeConstraint#getTimeConstraintExpression()
	 * @see #getTimeConstraint()
	 * @generated
	 */
	EReference getTimeConstraint_TimeConstraintExpression();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimerStart <em>Timer Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Timer Start</em>'.
	 * @see org.etsi.mts.tdl.TimerStart
	 * @generated
	 */
	EClass getTimerStart();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.TimerStart#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Period</em>'.
	 * @see org.etsi.mts.tdl.TimerStart#getPeriod()
	 * @see #getTimerStart()
	 * @generated
	 */
	EReference getTimerStart_Period();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimerStop <em>Timer Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Timer Stop</em>'.
	 * @see org.etsi.mts.tdl.TimerStop
	 * @generated
	 */
	EClass getTimerStop();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimeOut <em>Time Out</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Out</em>'.
	 * @see org.etsi.mts.tdl.TimeOut
	 * @generated
	 */
	EClass getTimeOut();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimeOperation <em>Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Operation</em>'.
	 * @see org.etsi.mts.tdl.TimeOperation
	 * @generated
	 */
	EClass getTimeOperation();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TimeOperation#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.TimeOperation#getComponentInstance()
	 * @see #getTimeOperation()
	 * @generated
	 */
	EReference getTimeOperation_ComponentInstance();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.TimeOperation#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Period</em>'.
	 * @see org.etsi.mts.tdl.TimeOperation#getPeriod()
	 * @see #getTimeOperation()
	 * @generated
	 */
	EReference getTimeOperation_Period();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.TimeOperation#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.TimeOperation#getParticipatingComponents()
	 * @generated
	 */
	EOperation getTimeOperation__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Wait <em>Wait</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Wait</em>'.
	 * @see org.etsi.mts.tdl.Wait
	 * @generated
	 */
	EClass getWait();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Quiescence <em>Quiescence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Quiescence</em>'.
	 * @see org.etsi.mts.tdl.Quiescence
	 * @generated
	 */
	EClass getQuiescence();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Quiescence#getGateReference <em>Gate Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Gate Reference</em>'.
	 * @see org.etsi.mts.tdl.Quiescence#getGateReference()
	 * @see #getQuiescence()
	 * @generated
	 */
	EReference getQuiescence_GateReference();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Quiescence#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.Quiescence#getParticipatingComponents()
	 * @generated
	 */
	EOperation getQuiescence__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.GateReference <em>Gate Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gate Reference</em>'.
	 * @see org.etsi.mts.tdl.GateReference
	 * @generated
	 */
	EClass getGateReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.GateReference#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component</em>'.
	 * @see org.etsi.mts.tdl.GateReference#getComponent()
	 * @see #getGateReference()
	 * @generated
	 */
	EReference getGateReference_Component();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.GateReference#getGate <em>Gate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Gate</em>'.
	 * @see org.etsi.mts.tdl.GateReference#getGate()
	 * @see #getGateReference()
	 * @generated
	 */
	EReference getGateReference_Gate();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TimeLabelUse <em>Time Label Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Label Use</em>'.
	 * @see org.etsi.mts.tdl.TimeLabelUse
	 * @generated
	 */
	EClass getTimeLabelUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TimeLabelUse#getTimeLabel <em>Time Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Time Label</em>'.
	 * @see org.etsi.mts.tdl.TimeLabelUse#getTimeLabel()
	 * @see #getTimeLabelUse()
	 * @generated
	 */
	EReference getTimeLabelUse_TimeLabel();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.TimeLabelUse#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.etsi.mts.tdl.TimeLabelUse#getKind()
	 * @see #getTimeLabelUse()
	 * @generated
	 */
	EAttribute getTimeLabelUse_Kind();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.TimeLabelUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.TimeLabelUse#resolveDataType()
	 * @generated
	 */
	EOperation getTimeLabelUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TestConfiguration <em>Test Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Configuration</em>'.
	 * @see org.etsi.mts.tdl.TestConfiguration
	 * @generated
	 */
	EClass getTestConfiguration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.TestConfiguration#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.TestConfiguration#getComponentInstance()
	 * @see #getTestConfiguration()
	 * @generated
	 */
	EReference getTestConfiguration_ComponentInstance();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.TestConfiguration#getConnection <em>Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Connection</em>'.
	 * @see org.etsi.mts.tdl.TestConfiguration#getConnection()
	 * @see #getTestConfiguration()
	 * @generated
	 */
	EReference getTestConfiguration_Connection();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.TestConfiguration#compatibleWith(org.etsi.mts.tdl.TestConfiguration, org.eclipse.emf.common.util.EList) <em>Compatible With</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compatible With</em>' operation.
	 * @see org.etsi.mts.tdl.TestConfiguration#compatibleWith(org.etsi.mts.tdl.TestConfiguration, org.eclipse.emf.common.util.EList)
	 * @generated
	 */
	EOperation getTestConfiguration__CompatibleWith__TestConfiguration_EList();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Connection <em>Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Connection</em>'.
	 * @see org.etsi.mts.tdl.Connection
	 * @generated
	 */
	EClass getConnection();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Connection#getEndPoint <em>End Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>End Point</em>'.
	 * @see org.etsi.mts.tdl.Connection#getEndPoint()
	 * @see #getConnection()
	 * @generated
	 */
	EReference getConnection_EndPoint();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TestDescription <em>Test Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Description</em>'.
	 * @see org.etsi.mts.tdl.TestDescription
	 * @generated
	 */
	EClass getTestDescription();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TestDescription#getTestConfiguration <em>Test Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Test Configuration</em>'.
	 * @see org.etsi.mts.tdl.TestDescription#getTestConfiguration()
	 * @see #getTestDescription()
	 * @generated
	 */
	EReference getTestDescription_TestConfiguration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.TestDescription#getFormalParameter <em>Formal Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Formal Parameter</em>'.
	 * @see org.etsi.mts.tdl.TestDescription#getFormalParameter()
	 * @see #getTestDescription()
	 * @generated
	 */
	EReference getTestDescription_FormalParameter();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.TestDescription#getBehaviourDescription <em>Behaviour Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Behaviour Description</em>'.
	 * @see org.etsi.mts.tdl.TestDescription#getBehaviourDescription()
	 * @see #getTestDescription()
	 * @generated
	 */
	EReference getTestDescription_BehaviourDescription();

	/**
	 * Returns the meta object for the reference list '{@link org.etsi.mts.tdl.TestDescription#getTestObjective <em>Test Objective</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Test Objective</em>'.
	 * @see org.etsi.mts.tdl.TestDescription#getTestObjective()
	 * @see #getTestDescription()
	 * @generated
	 */
	EReference getTestDescription_TestObjective();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.TestDescription#isIsLocallyOrdered <em>Is Locally Ordered</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Locally Ordered</em>'.
	 * @see org.etsi.mts.tdl.TestDescription#isIsLocallyOrdered()
	 * @see #getTestDescription()
	 * @generated
	 */
	EAttribute getTestDescription_IsLocallyOrdered();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.BehaviourDescription <em>Behaviour Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behaviour Description</em>'.
	 * @see org.etsi.mts.tdl.BehaviourDescription
	 * @generated
	 */
	EClass getBehaviourDescription();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.BehaviourDescription#getBehaviour <em>Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Behaviour</em>'.
	 * @see org.etsi.mts.tdl.BehaviourDescription#getBehaviour()
	 * @see #getBehaviourDescription()
	 * @generated
	 */
	EReference getBehaviourDescription_Behaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Block <em>Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Block</em>'.
	 * @see org.etsi.mts.tdl.Block
	 * @generated
	 */
	EClass getBlock();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Block#getBehaviour <em>Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Behaviour</em>'.
	 * @see org.etsi.mts.tdl.Block#getBehaviour()
	 * @see #getBlock()
	 * @generated
	 */
	EReference getBlock_Behaviour();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Block#getGuard <em>Guard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Guard</em>'.
	 * @see org.etsi.mts.tdl.Block#getGuard()
	 * @see #getBlock()
	 * @generated
	 */
	EReference getBlock_Guard();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Block#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.Block#getParticipatingComponents()
	 * @generated
	 */
	EOperation getBlock__GetParticipatingComponents();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Block#getParticipatingComponentsExcluding(org.etsi.mts.tdl.Behaviour) <em>Get Participating Components Excluding</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components Excluding</em>' operation.
	 * @see org.etsi.mts.tdl.Block#getParticipatingComponentsExcluding(org.etsi.mts.tdl.Behaviour)
	 * @generated
	 */
	EOperation getBlock__GetParticipatingComponentsExcluding__Behaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.CombinedBehaviour <em>Combined Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Combined Behaviour</em>'.
	 * @see org.etsi.mts.tdl.CombinedBehaviour
	 * @generated
	 */
	EClass getCombinedBehaviour();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.CombinedBehaviour#getPeriodic <em>Periodic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Periodic</em>'.
	 * @see org.etsi.mts.tdl.CombinedBehaviour#getPeriodic()
	 * @see #getCombinedBehaviour()
	 * @generated
	 */
	EReference getCombinedBehaviour_Periodic();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.CombinedBehaviour#getExceptional <em>Exceptional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Exceptional</em>'.
	 * @see org.etsi.mts.tdl.CombinedBehaviour#getExceptional()
	 * @see #getCombinedBehaviour()
	 * @generated
	 */
	EReference getCombinedBehaviour_Exceptional();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.PeriodicBehaviour <em>Periodic Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Periodic Behaviour</em>'.
	 * @see org.etsi.mts.tdl.PeriodicBehaviour
	 * @generated
	 */
	EClass getPeriodicBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.PeriodicBehaviour#getBlock <em>Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Block</em>'.
	 * @see org.etsi.mts.tdl.PeriodicBehaviour#getBlock()
	 * @see #getPeriodicBehaviour()
	 * @generated
	 */
	EReference getPeriodicBehaviour_Block();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.PeriodicBehaviour#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Period</em>'.
	 * @see org.etsi.mts.tdl.PeriodicBehaviour#getPeriod()
	 * @see #getPeriodicBehaviour()
	 * @generated
	 */
	EReference getPeriodicBehaviour_Period();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.PeriodicBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.PeriodicBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getPeriodicBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ExceptionalBehaviour <em>Exceptional Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Exceptional Behaviour</em>'.
	 * @see org.etsi.mts.tdl.ExceptionalBehaviour
	 * @generated
	 */
	EClass getExceptionalBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.ExceptionalBehaviour#getBlock <em>Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Block</em>'.
	 * @see org.etsi.mts.tdl.ExceptionalBehaviour#getBlock()
	 * @see #getExceptionalBehaviour()
	 * @generated
	 */
	EReference getExceptionalBehaviour_Block();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ExceptionalBehaviour#getGuardedComponent <em>Guarded Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Guarded Component</em>'.
	 * @see org.etsi.mts.tdl.ExceptionalBehaviour#getGuardedComponent()
	 * @see #getExceptionalBehaviour()
	 * @generated
	 */
	EReference getExceptionalBehaviour_GuardedComponent();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ExceptionalBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.ExceptionalBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getExceptionalBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.AlternativeBehaviour <em>Alternative Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Alternative Behaviour</em>'.
	 * @see org.etsi.mts.tdl.AlternativeBehaviour
	 * @generated
	 */
	EClass getAlternativeBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.MultipleCombinedBehaviour <em>Multiple Combined Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multiple Combined Behaviour</em>'.
	 * @see org.etsi.mts.tdl.MultipleCombinedBehaviour
	 * @generated
	 */
	EClass getMultipleCombinedBehaviour();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.MultipleCombinedBehaviour#getBlock <em>Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Block</em>'.
	 * @see org.etsi.mts.tdl.MultipleCombinedBehaviour#getBlock()
	 * @see #getMultipleCombinedBehaviour()
	 * @generated
	 */
	EReference getMultipleCombinedBehaviour_Block();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.MultipleCombinedBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.MultipleCombinedBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getMultipleCombinedBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ParallelBehaviour <em>Parallel Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parallel Behaviour</em>'.
	 * @see org.etsi.mts.tdl.ParallelBehaviour
	 * @generated
	 */
	EClass getParallelBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.BoundedLoopBehaviour <em>Bounded Loop Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bounded Loop Behaviour</em>'.
	 * @see org.etsi.mts.tdl.BoundedLoopBehaviour
	 * @generated
	 */
	EClass getBoundedLoopBehaviour();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.BoundedLoopBehaviour#getNumIteration <em>Num Iteration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Num Iteration</em>'.
	 * @see org.etsi.mts.tdl.BoundedLoopBehaviour#getNumIteration()
	 * @see #getBoundedLoopBehaviour()
	 * @generated
	 */
	EReference getBoundedLoopBehaviour_NumIteration();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.SingleCombinedBehaviour <em>Single Combined Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Single Combined Behaviour</em>'.
	 * @see org.etsi.mts.tdl.SingleCombinedBehaviour
	 * @generated
	 */
	EClass getSingleCombinedBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.SingleCombinedBehaviour#getBlock <em>Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Block</em>'.
	 * @see org.etsi.mts.tdl.SingleCombinedBehaviour#getBlock()
	 * @see #getSingleCombinedBehaviour()
	 * @generated
	 */
	EReference getSingleCombinedBehaviour_Block();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.SingleCombinedBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.SingleCombinedBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getSingleCombinedBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.OptionalBehaviour <em>Optional Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Optional Behaviour</em>'.
	 * @see org.etsi.mts.tdl.OptionalBehaviour
	 * @generated
	 */
	EClass getOptionalBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.UnboundedLoopBehaviour <em>Unbounded Loop Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unbounded Loop Behaviour</em>'.
	 * @see org.etsi.mts.tdl.UnboundedLoopBehaviour
	 * @generated
	 */
	EClass getUnboundedLoopBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ConditionalBehaviour <em>Conditional Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Conditional Behaviour</em>'.
	 * @see org.etsi.mts.tdl.ConditionalBehaviour
	 * @generated
	 */
	EClass getConditionalBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.CompoundBehaviour <em>Compound Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compound Behaviour</em>'.
	 * @see org.etsi.mts.tdl.CompoundBehaviour
	 * @generated
	 */
	EClass getCompoundBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DefaultBehaviour <em>Default Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Default Behaviour</em>'.
	 * @see org.etsi.mts.tdl.DefaultBehaviour
	 * @generated
	 */
	EClass getDefaultBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.InterruptBehaviour <em>Interrupt Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interrupt Behaviour</em>'.
	 * @see org.etsi.mts.tdl.InterruptBehaviour
	 * @generated
	 */
	EClass getInterruptBehaviour();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Target <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Target</em>'.
	 * @see org.etsi.mts.tdl.Target
	 * @generated
	 */
	EClass getTarget();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Target#getTargetGate <em>Target Gate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Gate</em>'.
	 * @see org.etsi.mts.tdl.Target#getTargetGate()
	 * @see #getTarget()
	 * @generated
	 */
	EReference getTarget_TargetGate();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Target#getValueAssignment <em>Value Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value Assignment</em>'.
	 * @see org.etsi.mts.tdl.Target#getValueAssignment()
	 * @see #getTarget()
	 * @generated
	 */
	EReference getTarget_ValueAssignment();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.VerdictAssignment <em>Verdict Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Verdict Assignment</em>'.
	 * @see org.etsi.mts.tdl.VerdictAssignment
	 * @generated
	 */
	EClass getVerdictAssignment();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.VerdictAssignment#getVerdict <em>Verdict</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Verdict</em>'.
	 * @see org.etsi.mts.tdl.VerdictAssignment#getVerdict()
	 * @see #getVerdictAssignment()
	 * @generated
	 */
	EReference getVerdictAssignment_Verdict();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Assertion <em>Assertion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assertion</em>'.
	 * @see org.etsi.mts.tdl.Assertion
	 * @generated
	 */
	EClass getAssertion();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.Assertion#getOtherwise <em>Otherwise</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Otherwise</em>'.
	 * @see org.etsi.mts.tdl.Assertion#getOtherwise()
	 * @see #getAssertion()
	 * @generated
	 */
	EReference getAssertion_Otherwise();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.Assertion#getCondition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Condition</em>'.
	 * @see org.etsi.mts.tdl.Assertion#getCondition()
	 * @see #getAssertion()
	 * @generated
	 */
	EReference getAssertion_Condition();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Stop <em>Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stop</em>'.
	 * @see org.etsi.mts.tdl.Stop
	 * @generated
	 */
	EClass getStop();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Break <em>Break</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Break</em>'.
	 * @see org.etsi.mts.tdl.Break
	 * @generated
	 */
	EClass getBreak();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see org.etsi.mts.tdl.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.Assignment#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Variable</em>'.
	 * @see org.etsi.mts.tdl.Assignment#getVariable()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Variable();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.Assignment#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.etsi.mts.tdl.Assignment#getExpression()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Expression();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Assignment#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.Assignment#getParticipatingComponents()
	 * @generated
	 */
	EOperation getAssignment__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ActionBehaviour <em>Action Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Action Behaviour</em>'.
	 * @see org.etsi.mts.tdl.ActionBehaviour
	 * @generated
	 */
	EClass getActionBehaviour();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ActionBehaviour#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.ActionBehaviour#getComponentInstance()
	 * @see #getActionBehaviour()
	 * @generated
	 */
	EReference getActionBehaviour_ComponentInstance();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.ActionBehaviour#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.ActionBehaviour#getParticipatingComponents()
	 * @generated
	 */
	EOperation getActionBehaviour__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.InlineAction <em>Inline Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inline Action</em>'.
	 * @see org.etsi.mts.tdl.InlineAction
	 * @generated
	 */
	EClass getInlineAction();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.InlineAction#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body</em>'.
	 * @see org.etsi.mts.tdl.InlineAction#getBody()
	 * @see #getInlineAction()
	 * @generated
	 */
	EAttribute getInlineAction_Body();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ActionReference <em>Action Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Action Reference</em>'.
	 * @see org.etsi.mts.tdl.ActionReference
	 * @generated
	 */
	EClass getActionReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ActionReference#getAction <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Action</em>'.
	 * @see org.etsi.mts.tdl.ActionReference#getAction()
	 * @see #getActionReference()
	 * @generated
	 */
	EReference getActionReference_Action();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ActionReference#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Argument</em>'.
	 * @see org.etsi.mts.tdl.ActionReference#getArgument()
	 * @see #getActionReference()
	 * @generated
	 */
	EReference getActionReference_Argument();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.TestDescriptionReference <em>Test Description Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Description Reference</em>'.
	 * @see org.etsi.mts.tdl.TestDescriptionReference
	 * @generated
	 */
	EClass getTestDescriptionReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.TestDescriptionReference#getTestDescription <em>Test Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Test Description</em>'.
	 * @see org.etsi.mts.tdl.TestDescriptionReference#getTestDescription()
	 * @see #getTestDescriptionReference()
	 * @generated
	 */
	EReference getTestDescriptionReference_TestDescription();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.TestDescriptionReference#getComponentInstanceBinding <em>Component Instance Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component Instance Binding</em>'.
	 * @see org.etsi.mts.tdl.TestDescriptionReference#getComponentInstanceBinding()
	 * @see #getTestDescriptionReference()
	 * @generated
	 */
	EReference getTestDescriptionReference_ComponentInstanceBinding();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.TestDescriptionReference#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Argument</em>'.
	 * @see org.etsi.mts.tdl.TestDescriptionReference#getArgument()
	 * @see #getTestDescriptionReference()
	 * @generated
	 */
	EReference getTestDescriptionReference_Argument();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.TestDescriptionReference#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.TestDescriptionReference#getParticipatingComponents()
	 * @generated
	 */
	EOperation getTestDescriptionReference__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ComponentInstanceBinding <em>Component Instance Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Instance Binding</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstanceBinding
	 * @generated
	 */
	EClass getComponentInstanceBinding();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ComponentInstanceBinding#getFormalComponent <em>Formal Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Formal Component</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstanceBinding#getFormalComponent()
	 * @see #getComponentInstanceBinding()
	 * @generated
	 */
	EReference getComponentInstanceBinding_FormalComponent();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ComponentInstanceBinding#getActualComponent <em>Actual Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Actual Component</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstanceBinding#getActualComponent()
	 * @see #getComponentInstanceBinding()
	 * @generated
	 */
	EReference getComponentInstanceBinding_ActualComponent();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Interaction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interaction</em>'.
	 * @see org.etsi.mts.tdl.Interaction
	 * @generated
	 */
	EClass getInteraction();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Interaction#getSourceGate <em>Source Gate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source Gate</em>'.
	 * @see org.etsi.mts.tdl.Interaction#getSourceGate()
	 * @see #getInteraction()
	 * @generated
	 */
	EReference getInteraction_SourceGate();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Interaction#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target</em>'.
	 * @see org.etsi.mts.tdl.Interaction#getTarget()
	 * @see #getInteraction()
	 * @generated
	 */
	EReference getInteraction_Target();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Interaction#getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Participating Components</em>' operation.
	 * @see org.etsi.mts.tdl.Interaction#getParticipatingComponents()
	 * @generated
	 */
	EOperation getInteraction__GetParticipatingComponents();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message</em>'.
	 * @see org.etsi.mts.tdl.Message
	 * @generated
	 */
	EClass getMessage();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.Message#isIsTrigger <em>Is Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Trigger</em>'.
	 * @see org.etsi.mts.tdl.Message#isIsTrigger()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_IsTrigger();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.Message#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Argument</em>'.
	 * @see org.etsi.mts.tdl.Message#getArgument()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Argument();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.PredefinedFunction <em>Predefined Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Predefined Function</em>'.
	 * @see org.etsi.mts.tdl.PredefinedFunction
	 * @generated
	 */
	EClass getPredefinedFunction();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.PredefinedFunction#getReturnType <em>Return Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Return Type</em>'.
	 * @see org.etsi.mts.tdl.PredefinedFunction#getReturnType()
	 * @see #getPredefinedFunction()
	 * @generated
	 */
	EReference getPredefinedFunction_ReturnType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.MemberReference <em>Member Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member Reference</em>'.
	 * @see org.etsi.mts.tdl.MemberReference
	 * @generated
	 */
	EClass getMemberReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.MemberReference#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Member</em>'.
	 * @see org.etsi.mts.tdl.MemberReference#getMember()
	 * @see #getMemberReference()
	 * @generated
	 */
	EReference getMemberReference_Member();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.MemberReference#getCollectionIndex <em>Collection Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Collection Index</em>'.
	 * @see org.etsi.mts.tdl.MemberReference#getCollectionIndex()
	 * @see #getMemberReference()
	 * @generated
	 */
	EReference getMemberReference_CollectionIndex();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.PredefinedFunctionCall <em>Predefined Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Predefined Function Call</em>'.
	 * @see org.etsi.mts.tdl.PredefinedFunctionCall
	 * @generated
	 */
	EClass getPredefinedFunctionCall();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.PredefinedFunctionCall#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Function</em>'.
	 * @see org.etsi.mts.tdl.PredefinedFunctionCall#getFunction()
	 * @see #getPredefinedFunctionCall()
	 * @generated
	 */
	EReference getPredefinedFunctionCall_Function();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.PredefinedFunctionCall#getActualParameters <em>Actual Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Actual Parameters</em>'.
	 * @see org.etsi.mts.tdl.PredefinedFunctionCall#getActualParameters()
	 * @see #getPredefinedFunctionCall()
	 * @generated
	 */
	EReference getPredefinedFunctionCall_ActualParameters();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.PredefinedFunctionCall#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.PredefinedFunctionCall#resolveDataType()
	 * @generated
	 */
	EOperation getPredefinedFunctionCall__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.LocalExpression <em>Local Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Local Expression</em>'.
	 * @see org.etsi.mts.tdl.LocalExpression
	 * @generated
	 */
	EClass getLocalExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.LocalExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.etsi.mts.tdl.LocalExpression#getExpression()
	 * @see #getLocalExpression()
	 * @generated
	 */
	EReference getLocalExpression_Expression();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.LocalExpression#getComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Instance</em>'.
	 * @see org.etsi.mts.tdl.LocalExpression#getComponentInstance()
	 * @see #getLocalExpression()
	 * @generated
	 */
	EReference getLocalExpression_ComponentInstance();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ValueAssignment <em>Value Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value Assignment</em>'.
	 * @see org.etsi.mts.tdl.ValueAssignment
	 * @generated
	 */
	EClass getValueAssignment();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ValueAssignment#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Variable</em>'.
	 * @see org.etsi.mts.tdl.ValueAssignment#getVariable()
	 * @see #getValueAssignment()
	 * @generated
	 */
	EReference getValueAssignment_Variable();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ValueAssignment#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.ValueAssignment#getParameter()
	 * @see #getValueAssignment()
	 * @generated
	 */
	EReference getValueAssignment_Parameter();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ProcedureCall <em>Procedure Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Procedure Call</em>'.
	 * @see org.etsi.mts.tdl.ProcedureCall
	 * @generated
	 */
	EClass getProcedureCall();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ProcedureCall#getSignature <em>Signature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Signature</em>'.
	 * @see org.etsi.mts.tdl.ProcedureCall#getSignature()
	 * @see #getProcedureCall()
	 * @generated
	 */
	EReference getProcedureCall_Signature();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ProcedureCall#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Argument</em>'.
	 * @see org.etsi.mts.tdl.ProcedureCall#getArgument()
	 * @see #getProcedureCall()
	 * @generated
	 */
	EReference getProcedureCall_Argument();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.ProcedureCall#getReplyTo <em>Reply To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reply To</em>'.
	 * @see org.etsi.mts.tdl.ProcedureCall#getReplyTo()
	 * @see #getProcedureCall()
	 * @generated
	 */
	EReference getProcedureCall_ReplyTo();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ProcedureSignature <em>Procedure Signature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Procedure Signature</em>'.
	 * @see org.etsi.mts.tdl.ProcedureSignature
	 * @generated
	 */
	EClass getProcedureSignature();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.ProcedureSignature#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameter</em>'.
	 * @see org.etsi.mts.tdl.ProcedureSignature#getParameter()
	 * @see #getProcedureSignature()
	 * @generated
	 */
	EReference getProcedureSignature_Parameter();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ProcedureParameter <em>Procedure Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Procedure Parameter</em>'.
	 * @see org.etsi.mts.tdl.ProcedureParameter
	 * @generated
	 */
	EClass getProcedureParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.ProcedureParameter#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.etsi.mts.tdl.ProcedureParameter#getKind()
	 * @see #getProcedureParameter()
	 * @generated
	 */
	EAttribute getProcedureParameter_Kind();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.CollectionDataType <em>Collection Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Data Type</em>'.
	 * @see org.etsi.mts.tdl.CollectionDataType
	 * @generated
	 */
	EClass getCollectionDataType();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.CollectionDataType#getItemType <em>Item Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Item Type</em>'.
	 * @see org.etsi.mts.tdl.CollectionDataType#getItemType()
	 * @see #getCollectionDataType()
	 * @generated
	 */
	EReference getCollectionDataType_ItemType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.CollectionDataInstance <em>Collection Data Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Data Instance</em>'.
	 * @see org.etsi.mts.tdl.CollectionDataInstance
	 * @generated
	 */
	EClass getCollectionDataInstance();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.CollectionDataInstance#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Item</em>'.
	 * @see org.etsi.mts.tdl.CollectionDataInstance#getItem()
	 * @see #getCollectionDataInstance()
	 * @generated
	 */
	EReference getCollectionDataInstance_Item();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.CollectionDataInstance#getUnassignedMember <em>Unassigned Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unassigned Member</em>'.
	 * @see org.etsi.mts.tdl.CollectionDataInstance#getUnassignedMember()
	 * @see #getCollectionDataInstance()
	 * @generated
	 */
	EAttribute getCollectionDataInstance_UnassignedMember();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Extension <em>Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Extension</em>'.
	 * @see org.etsi.mts.tdl.Extension
	 * @generated
	 */
	EClass getExtension();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Extension#getExtending <em>Extending</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Extending</em>'.
	 * @see org.etsi.mts.tdl.Extension#getExtending()
	 * @see #getExtension()
	 * @generated
	 */
	EReference getExtension_Extending();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Extension#transitiveExtending() <em>Transitive Extending</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Transitive Extending</em>' operation.
	 * @see org.etsi.mts.tdl.Extension#transitiveExtending()
	 * @generated
	 */
	EOperation getExtension__TransitiveExtending();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.Extension#isExtending(org.etsi.mts.tdl.PackageableElement) <em>Is Extending</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Is Extending</em>' operation.
	 * @see org.etsi.mts.tdl.Extension#isExtending(org.etsi.mts.tdl.PackageableElement)
	 * @generated
	 */
	EOperation getExtension__IsExtending__PackageableElement();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.LiteralValueUse <em>Literal Value Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Value Use</em>'.
	 * @see org.etsi.mts.tdl.LiteralValueUse
	 * @generated
	 */
	EClass getLiteralValueUse();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.LiteralValueUse#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.LiteralValueUse#getValue()
	 * @see #getLiteralValueUse()
	 * @generated
	 */
	EAttribute getLiteralValueUse_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.LiteralValueUse#getIntValue <em>Int Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Int Value</em>'.
	 * @see org.etsi.mts.tdl.LiteralValueUse#getIntValue()
	 * @see #getLiteralValueUse()
	 * @generated
	 */
	EAttribute getLiteralValueUse_IntValue();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.LiteralValueUse#getBoolValue <em>Bool Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bool Value</em>'.
	 * @see org.etsi.mts.tdl.LiteralValueUse#getBoolValue()
	 * @see #getLiteralValueUse()
	 * @generated
	 */
	EAttribute getLiteralValueUse_BoolValue();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.LiteralValueUse#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.LiteralValueUse#getDataType()
	 * @see #getLiteralValueUse()
	 * @generated
	 */
	EReference getLiteralValueUse_DataType();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.LiteralValueUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.LiteralValueUse#resolveDataType()
	 * @generated
	 */
	EOperation getLiteralValueUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.ConstraintType <em>Constraint Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraint Type</em>'.
	 * @see org.etsi.mts.tdl.ConstraintType
	 * @generated
	 */
	EClass getConstraintType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.Constraint <em>Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraint</em>'.
	 * @see org.etsi.mts.tdl.Constraint
	 * @generated
	 */
	EClass getConstraint();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.Constraint#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.etsi.mts.tdl.Constraint#getType()
	 * @see #getConstraint()
	 * @generated
	 */
	EReference getConstraint_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.Constraint#getQuantifier <em>Quantifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Quantifier</em>'.
	 * @see org.etsi.mts.tdl.Constraint#getQuantifier()
	 * @see #getConstraint()
	 * @generated
	 */
	EReference getConstraint_Quantifier();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.EnumDataType <em>Enum Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Data Type</em>'.
	 * @see org.etsi.mts.tdl.EnumDataType
	 * @generated
	 */
	EClass getEnumDataType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.EnumDataType#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.EnumDataType#getValue()
	 * @see #getEnumDataType()
	 * @generated
	 */
	EReference getEnumDataType_Value();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.DataElementUse <em>Data Element Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Element Use</em>'.
	 * @see org.etsi.mts.tdl.DataElementUse
	 * @generated
	 */
	EClass getDataElementUse();

	/**
	 * Returns the meta object for the attribute '{@link org.etsi.mts.tdl.DataElementUse#getUnassignedMember <em>Unassigned Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unassigned Member</em>'.
	 * @see org.etsi.mts.tdl.DataElementUse#getUnassignedMember()
	 * @see #getDataElementUse()
	 * @generated
	 */
	EAttribute getDataElementUse_UnassignedMember();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.DataElementUse#getDataElement <em>Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Element</em>'.
	 * @see org.etsi.mts.tdl.DataElementUse#getDataElement()
	 * @see #getDataElementUse()
	 * @generated
	 */
	EReference getDataElementUse_DataElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.DataElementUse#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Item</em>'.
	 * @see org.etsi.mts.tdl.DataElementUse#getItem()
	 * @see #getDataElementUse()
	 * @generated
	 */
	EReference getDataElementUse_Item();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.DataElementUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.DataElementUse#resolveDataType()
	 * @generated
	 */
	EOperation getDataElementUse__ResolveDataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.CastDataUse <em>Cast Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cast Data Use</em>'.
	 * @see org.etsi.mts.tdl.CastDataUse
	 * @generated
	 */
	EClass getCastDataUse();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.CastDataUse#getDataUse <em>Data Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Data Use</em>'.
	 * @see org.etsi.mts.tdl.CastDataUse#getDataUse()
	 * @see #getCastDataUse()
	 * @generated
	 */
	EReference getCastDataUse_DataUse();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.CastDataUse#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.CastDataUse#getDataType()
	 * @see #getCastDataUse()
	 * @generated
	 */
	EReference getCastDataUse_DataType();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.CastDataUse#resolveDataType() <em>Resolve Data Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Resolve Data Type</em>' operation.
	 * @see org.etsi.mts.tdl.CastDataUse#resolveDataType()
	 * @generated
	 */
	EOperation getCastDataUse__ResolveDataType();

	/**
	 * Returns the meta object for enum '{@link org.etsi.mts.tdl.UnassignedMemberTreatment <em>Unassigned Member Treatment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Unassigned Member Treatment</em>'.
	 * @see org.etsi.mts.tdl.UnassignedMemberTreatment
	 * @generated
	 */
	EEnum getUnassignedMemberTreatment();

	/**
	 * Returns the meta object for enum '{@link org.etsi.mts.tdl.ComponentInstanceRole <em>Component Instance Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Component Instance Role</em>'.
	 * @see org.etsi.mts.tdl.ComponentInstanceRole
	 * @generated
	 */
	EEnum getComponentInstanceRole();

	/**
	 * Returns the meta object for enum '{@link org.etsi.mts.tdl.GateTypeKind <em>Gate Type Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Gate Type Kind</em>'.
	 * @see org.etsi.mts.tdl.GateTypeKind
	 * @generated
	 */
	EEnum getGateTypeKind();

	/**
	 * Returns the meta object for enum '{@link org.etsi.mts.tdl.TimeLabelUseKind <em>Time Label Use Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Time Label Use Kind</em>'.
	 * @see org.etsi.mts.tdl.TimeLabelUseKind
	 * @generated
	 */
	EEnum getTimeLabelUseKind();

	/**
	 * Returns the meta object for enum '{@link org.etsi.mts.tdl.ParameterKind <em>Parameter Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Parameter Kind</em>'.
	 * @see org.etsi.mts.tdl.ParameterKind
	 * @generated
	 */
	EEnum getParameterKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	tdlFactory gettdlFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ElementImpl <em>Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ElementImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getElement()
		 * @generated
		 */
		EClass ELEMENT = eINSTANCE.getElement();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT__COMMENT = eINSTANCE.getElement_Comment();

		/**
		 * The meta object literal for the '<em><b>Annotation</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT__ANNOTATION = eINSTANCE.getElement_Annotation();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ELEMENT__NAME = eINSTANCE.getElement_Name();

		/**
		 * The meta object literal for the '<em><b>Container</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ELEMENT___CONTAINER = eINSTANCE.getElement__Container();

		/**
		 * The meta object literal for the '<em><b>Get Parent Test Description</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ELEMENT___GET_PARENT_TEST_DESCRIPTION = eINSTANCE.getElement__GetParentTestDescription();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CommentImpl <em>Comment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CommentImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComment()
		 * @generated
		 */
		EClass COMMENT = eINSTANCE.getComment();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__BODY = eINSTANCE.getComment_Body();

		/**
		 * The meta object literal for the '<em><b>Commented Element</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMMENT__COMMENTED_ELEMENT = eINSTANCE.getComment_CommentedElement();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AnnotationImpl <em>Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AnnotationImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnnotation()
		 * @generated
		 */
		EClass ANNOTATION = eINSTANCE.getAnnotation();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION__VALUE = eINSTANCE.getAnnotation_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__KEY = eINSTANCE.getAnnotation_Key();

		/**
		 * The meta object literal for the '<em><b>Annotated Element</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__ANNOTATED_ELEMENT = eINSTANCE.getAnnotation_AnnotatedElement();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AnnotationTypeImpl <em>Annotation Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AnnotationTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnnotationType()
		 * @generated
		 */
		EClass ANNOTATION_TYPE = eINSTANCE.getAnnotationType();

		/**
		 * The meta object literal for the '<em><b>Extension</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_TYPE__EXTENSION = eINSTANCE.getAnnotationType_Extension();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.PackageableElementImpl <em>Packageable Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.PackageableElementImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPackageableElement()
		 * @generated
		 */
		EClass PACKAGEABLE_ELEMENT = eINSTANCE.getPackageableElement();

		/**
		 * The meta object literal for the '<em><b>Conforms To</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING = eINSTANCE.getPackageableElement__ConformsTo__String();

		/**
		 * The meta object literal for the '<em><b>Get Element Named</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING = eINSTANCE.getPackageableElement__GetElementNamed__String();

		/**
		 * The meta object literal for the '<em><b>Conforms To</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT = eINSTANCE.getPackageableElement__ConformsTo__PackageableElement();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.NamedElementImpl <em>Named Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.NamedElementImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getNamedElement()
		 * @generated
		 */
		EClass NAMED_ELEMENT = eINSTANCE.getNamedElement();

		/**
		 * The meta object literal for the '<em><b>Qualified Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NAMED_ELEMENT__QUALIFIED_NAME = eINSTANCE.getNamedElement_QualifiedName();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.PackageImpl <em>Package</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.PackageImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPackage()
		 * @generated
		 */
		EClass PACKAGE = eINSTANCE.getPackage();

		/**
		 * The meta object literal for the '<em><b>Packaged Element</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__PACKAGED_ELEMENT = eINSTANCE.getPackage_PackagedElement();

		/**
		 * The meta object literal for the '<em><b>Import</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__IMPORT = eINSTANCE.getPackage_Import();

		/**
		 * The meta object literal for the '<em><b>Nested Package</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__NESTED_PACKAGE = eINSTANCE.getPackage_NestedPackage();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ElementImportImpl <em>Element Import</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ElementImportImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getElementImport()
		 * @generated
		 */
		EClass ELEMENT_IMPORT = eINSTANCE.getElementImport();

		/**
		 * The meta object literal for the '<em><b>Imported Element</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT_IMPORT__IMPORTED_ELEMENT = eINSTANCE.getElementImport_ImportedElement();

		/**
		 * The meta object literal for the '<em><b>Imported Package</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT_IMPORT__IMPORTED_PACKAGE = eINSTANCE.getElementImport_ImportedPackage();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TestObjectiveImpl <em>Test Objective</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TestObjectiveImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestObjective()
		 * @generated
		 */
		EClass TEST_OBJECTIVE = eINSTANCE.getTestObjective();

		/**
		 * The meta object literal for the '<em><b>Objective URI</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEST_OBJECTIVE__OBJECTIVE_URI = eINSTANCE.getTestObjective_ObjectiveURI();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEST_OBJECTIVE__DESCRIPTION = eINSTANCE.getTestObjective_Description();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataInstanceImpl <em>Data Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataInstance()
		 * @generated
		 */
		EClass DATA_INSTANCE = eINSTANCE.getDataInstance();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_INSTANCE__DATA_TYPE = eINSTANCE.getDataInstance_DataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MappableDataElementImpl <em>Mappable Data Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MappableDataElementImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMappableDataElement()
		 * @generated
		 */
		EClass MAPPABLE_DATA_ELEMENT = eINSTANCE.getMappableDataElement();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataTypeImpl <em>Data Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataType()
		 * @generated
		 */
		EClass DATA_TYPE = eINSTANCE.getDataType();

		/**
		 * The meta object literal for the '<em><b>Constraint</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_TYPE__CONSTRAINT = eINSTANCE.getDataType_Constraint();

		/**
		 * The meta object literal for the '<em><b>All Constraints</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATA_TYPE___ALL_CONSTRAINTS = eINSTANCE.getDataType__AllConstraints();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataResourceMappingImpl <em>Data Resource Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataResourceMappingImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataResourceMapping()
		 * @generated
		 */
		EClass DATA_RESOURCE_MAPPING = eINSTANCE.getDataResourceMapping();

		/**
		 * The meta object literal for the '<em><b>Resource URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_RESOURCE_MAPPING__RESOURCE_URI = eINSTANCE.getDataResourceMapping_ResourceURI();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataElementMappingImpl <em>Data Element Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataElementMappingImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataElementMapping()
		 * @generated
		 */
		EClass DATA_ELEMENT_MAPPING = eINSTANCE.getDataElementMapping();

		/**
		 * The meta object literal for the '<em><b>Mappable Data Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_ELEMENT_MAPPING__MAPPABLE_DATA_ELEMENT = eINSTANCE.getDataElementMapping_MappableDataElement();

		/**
		 * The meta object literal for the '<em><b>Element URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_ELEMENT_MAPPING__ELEMENT_URI = eINSTANCE.getDataElementMapping_ElementURI();

		/**
		 * The meta object literal for the '<em><b>Data Resource Mapping</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_ELEMENT_MAPPING__DATA_RESOURCE_MAPPING = eINSTANCE.getDataElementMapping_DataResourceMapping();

		/**
		 * The meta object literal for the '<em><b>Parameter Mapping</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_ELEMENT_MAPPING__PARAMETER_MAPPING = eINSTANCE.getDataElementMapping_ParameterMapping();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ParameterMappingImpl <em>Parameter Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ParameterMappingImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterMapping()
		 * @generated
		 */
		EClass PARAMETER_MAPPING = eINSTANCE.getParameterMapping();

		/**
		 * The meta object literal for the '<em><b>Parameter URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER_MAPPING__PARAMETER_URI = eINSTANCE.getParameterMapping_ParameterURI();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER_MAPPING__PARAMETER = eINSTANCE.getParameterMapping_Parameter();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ParameterImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameter()
		 * @generated
		 */
		EClass PARAMETER = eINSTANCE.getParameter();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__DATA_TYPE = eINSTANCE.getParameter_DataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.SimpleDataTypeImpl <em>Simple Data Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.SimpleDataTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSimpleDataType()
		 * @generated
		 */
		EClass SIMPLE_DATA_TYPE = eINSTANCE.getSimpleDataType();

		/**
		 * The meta object literal for the '<em><b>Extension</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_DATA_TYPE__EXTENSION = eINSTANCE.getSimpleDataType_Extension();

		/**
		 * The meta object literal for the '<em><b>All Constraints</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SIMPLE_DATA_TYPE___ALL_CONSTRAINTS = eINSTANCE.getSimpleDataType__AllConstraints();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.SimpleDataInstanceImpl <em>Simple Data Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.SimpleDataInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSimpleDataInstance()
		 * @generated
		 */
		EClass SIMPLE_DATA_INSTANCE = eINSTANCE.getSimpleDataInstance();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.StructuredDataTypeImpl <em>Structured Data Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.StructuredDataTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStructuredDataType()
		 * @generated
		 */
		EClass STRUCTURED_DATA_TYPE = eINSTANCE.getStructuredDataType();

		/**
		 * The meta object literal for the '<em><b>Extension</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_DATA_TYPE__EXTENSION = eINSTANCE.getStructuredDataType_Extension();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_DATA_TYPE__MEMBER = eINSTANCE.getStructuredDataType_Member();

		/**
		 * The meta object literal for the '<em><b>All Members</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation STRUCTURED_DATA_TYPE___ALL_MEMBERS = eINSTANCE.getStructuredDataType__AllMembers();

		/**
		 * The meta object literal for the '<em><b>All Constraints</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation STRUCTURED_DATA_TYPE___ALL_CONSTRAINTS = eINSTANCE.getStructuredDataType__AllConstraints();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MemberImpl <em>Member</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MemberImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMember()
		 * @generated
		 */
		EClass MEMBER = eINSTANCE.getMember();

		/**
		 * The meta object literal for the '<em><b>Is Optional</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__IS_OPTIONAL = eINSTANCE.getMember_IsOptional();

		/**
		 * The meta object literal for the '<em><b>Constraint</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER__CONSTRAINT = eINSTANCE.getMember_Constraint();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.StructuredDataInstanceImpl <em>Structured Data Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.StructuredDataInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStructuredDataInstance()
		 * @generated
		 */
		EClass STRUCTURED_DATA_INSTANCE = eINSTANCE.getStructuredDataInstance();

		/**
		 * The meta object literal for the '<em><b>Member Assignment</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_DATA_INSTANCE__MEMBER_ASSIGNMENT = eINSTANCE.getStructuredDataInstance_MemberAssignment();

		/**
		 * The meta object literal for the '<em><b>Unassigned Member</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRUCTURED_DATA_INSTANCE__UNASSIGNED_MEMBER = eINSTANCE.getStructuredDataInstance_UnassignedMember();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MemberAssignmentImpl <em>Member Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MemberAssignmentImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMemberAssignment()
		 * @generated
		 */
		EClass MEMBER_ASSIGNMENT = eINSTANCE.getMemberAssignment();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_ASSIGNMENT__MEMBER = eINSTANCE.getMemberAssignment_Member();

		/**
		 * The meta object literal for the '<em><b>Member Spec</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_ASSIGNMENT__MEMBER_SPEC = eINSTANCE.getMemberAssignment_MemberSpec();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.StaticDataUseImpl <em>Static Data Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.StaticDataUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStaticDataUse()
		 * @generated
		 */
		EClass STATIC_DATA_USE = eINSTANCE.getStaticDataUse();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataUseImpl <em>Data Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataUse()
		 * @generated
		 */
		EClass DATA_USE = eINSTANCE.getDataUse();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_USE__ARGUMENT = eINSTANCE.getDataUse_Argument();

		/**
		 * The meta object literal for the '<em><b>Reduction</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_USE__REDUCTION = eINSTANCE.getDataUse_Reduction();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATA_USE___RESOLVE_DATA_TYPE = eINSTANCE.getDataUse__ResolveDataType();

		/**
		 * The meta object literal for the '<em><b>Is Effectively Static</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATA_USE___IS_EFFECTIVELY_STATIC = eINSTANCE.getDataUse__IsEffectivelyStatic();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ParameterBindingImpl <em>Parameter Binding</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ParameterBindingImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterBinding()
		 * @generated
		 */
		EClass PARAMETER_BINDING = eINSTANCE.getParameterBinding();

		/**
		 * The meta object literal for the '<em><b>Data Use</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER_BINDING__DATA_USE = eINSTANCE.getParameterBinding_DataUse();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER_BINDING__PARAMETER = eINSTANCE.getParameterBinding_Parameter();

		/**
		 * The meta object literal for the '<em><b>Reduction</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER_BINDING__REDUCTION = eINSTANCE.getParameterBinding_Reduction();

		/**
		 * The meta object literal for the '<em><b>Resolve Parameter Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PARAMETER_BINDING___RESOLVE_PARAMETER_TYPE = eINSTANCE.getParameterBinding__ResolveParameterType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ActionImpl <em>Action</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ActionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAction()
		 * @generated
		 */
		EClass ACTION = eINSTANCE.getAction();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ACTION__BODY = eINSTANCE.getAction_Body();

		/**
		 * The meta object literal for the '<em><b>Formal Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION__FORMAL_PARAMETER = eINSTANCE.getAction_FormalParameter();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.FormalParameterImpl <em>Formal Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.FormalParameterImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFormalParameter()
		 * @generated
		 */
		EClass FORMAL_PARAMETER = eINSTANCE.getFormalParameter();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.FunctionImpl <em>Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.FunctionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFunction()
		 * @generated
		 */
		EClass FUNCTION = eINSTANCE.getFunction();

		/**
		 * The meta object literal for the '<em><b>Return Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__RETURN_TYPE = eINSTANCE.getFunction_ReturnType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.FormalParameterUseImpl <em>Formal Parameter Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.FormalParameterUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFormalParameterUse()
		 * @generated
		 */
		EClass FORMAL_PARAMETER_USE = eINSTANCE.getFormalParameterUse();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FORMAL_PARAMETER_USE__PARAMETER = eINSTANCE.getFormalParameterUse_Parameter();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation FORMAL_PARAMETER_USE___RESOLVE_DATA_TYPE = eINSTANCE.getFormalParameterUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DynamicDataUseImpl <em>Dynamic Data Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DynamicDataUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDynamicDataUse()
		 * @generated
		 */
		EClass DYNAMIC_DATA_USE = eINSTANCE.getDynamicDataUse();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.VariableImpl <em>Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.VariableImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE = eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__DATA_TYPE = eINSTANCE.getVariable_DataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.FunctionCallImpl <em>Function Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.FunctionCallImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getFunctionCall()
		 * @generated
		 */
		EClass FUNCTION_CALL = eINSTANCE.getFunctionCall();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_CALL__FUNCTION = eINSTANCE.getFunctionCall_Function();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation FUNCTION_CALL___RESOLVE_DATA_TYPE = eINSTANCE.getFunctionCall__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.VariableUseImpl <em>Variable Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.VariableUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVariableUse()
		 * @generated
		 */
		EClass VARIABLE_USE = eINSTANCE.getVariableUse();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE_USE__COMPONENT_INSTANCE = eINSTANCE.getVariableUse_ComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE_USE__VARIABLE = eINSTANCE.getVariableUse_Variable();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation VARIABLE_USE___RESOLVE_DATA_TYPE = eINSTANCE.getVariableUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ComponentInstanceImpl <em>Component Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ComponentInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstance()
		 * @generated
		 */
		EClass COMPONENT_INSTANCE = eINSTANCE.getComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCE__TYPE = eINSTANCE.getComponentInstance_Type();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_INSTANCE__ROLE = eINSTANCE.getComponentInstance_Role();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ComponentTypeImpl <em>Component Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ComponentTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentType()
		 * @generated
		 */
		EClass COMPONENT_TYPE = eINSTANCE.getComponentType();

		/**
		 * The meta object literal for the '<em><b>Gate Instance</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__GATE_INSTANCE = eINSTANCE.getComponentType_GateInstance();

		/**
		 * The meta object literal for the '<em><b>Timer</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__TIMER = eINSTANCE.getComponentType_Timer();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__VARIABLE = eINSTANCE.getComponentType_Variable();

		/**
		 * The meta object literal for the '<em><b>Extension</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__EXTENSION = eINSTANCE.getComponentType_Extension();

		/**
		 * The meta object literal for the '<em><b>All Gates</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation COMPONENT_TYPE___ALL_GATES = eINSTANCE.getComponentType__AllGates();

		/**
		 * The meta object literal for the '<em><b>All Timers</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation COMPONENT_TYPE___ALL_TIMERS = eINSTANCE.getComponentType__AllTimers();

		/**
		 * The meta object literal for the '<em><b>All Variables</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation COMPONENT_TYPE___ALL_VARIABLES = eINSTANCE.getComponentType__AllVariables();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.GateInstanceImpl <em>Gate Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.GateInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateInstance()
		 * @generated
		 */
		EClass GATE_INSTANCE = eINSTANCE.getGateInstance();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GATE_INSTANCE__TYPE = eINSTANCE.getGateInstance_Type();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.GateTypeImpl <em>Gate Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.GateTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateType()
		 * @generated
		 */
		EClass GATE_TYPE = eINSTANCE.getGateType();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GATE_TYPE__DATA_TYPE = eINSTANCE.getGateType_DataType();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GATE_TYPE__KIND = eINSTANCE.getGateType_Kind();

		/**
		 * The meta object literal for the '<em><b>Extension</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GATE_TYPE__EXTENSION = eINSTANCE.getGateType_Extension();

		/**
		 * The meta object literal for the '<em><b>All Data Types</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation GATE_TYPE___ALL_DATA_TYPES = eINSTANCE.getGateType__AllDataTypes();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimerImpl <em>Timer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimerImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimer()
		 * @generated
		 */
		EClass TIMER = eINSTANCE.getTimer();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.OmitValueImpl <em>Omit Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.OmitValueImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getOmitValue()
		 * @generated
		 */
		EClass OMIT_VALUE = eINSTANCE.getOmitValue();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.SpecialValueUseImpl <em>Special Value Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.SpecialValueUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSpecialValueUse()
		 * @generated
		 */
		EClass SPECIAL_VALUE_USE = eINSTANCE.getSpecialValueUse();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SPECIAL_VALUE_USE___RESOLVE_DATA_TYPE = eINSTANCE.getSpecialValueUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AnyValueImpl <em>Any Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AnyValueImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnyValue()
		 * @generated
		 */
		EClass ANY_VALUE = eINSTANCE.getAnyValue();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANY_VALUE__DATA_TYPE = eINSTANCE.getAnyValue_DataType();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ANY_VALUE___RESOLVE_DATA_TYPE = eINSTANCE.getAnyValue__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AnyValueOrOmitImpl <em>Any Value Or Omit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AnyValueOrOmitImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAnyValueOrOmit()
		 * @generated
		 */
		EClass ANY_VALUE_OR_OMIT = eINSTANCE.getAnyValueOrOmit();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataInstanceUseImpl <em>Data Instance Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataInstanceUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataInstanceUse()
		 * @generated
		 */
		EClass DATA_INSTANCE_USE = eINSTANCE.getDataInstanceUse();

		/**
		 * The meta object literal for the '<em><b>Data Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_INSTANCE_USE__DATA_INSTANCE = eINSTANCE.getDataInstanceUse_DataInstance();

		/**
		 * The meta object literal for the '<em><b>Unassigned Member</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_INSTANCE_USE__UNASSIGNED_MEMBER = eINSTANCE.getDataInstanceUse_UnassignedMember();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_INSTANCE_USE__DATA_TYPE = eINSTANCE.getDataInstanceUse_DataType();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_INSTANCE_USE__ITEM = eINSTANCE.getDataInstanceUse_Item();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATA_INSTANCE_USE___RESOLVE_DATA_TYPE = eINSTANCE.getDataInstanceUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeImpl <em>Time</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTime()
		 * @generated
		 */
		EClass TIME = eINSTANCE.getTime();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeLabelImpl <em>Time Label</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeLabelImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabel()
		 * @generated
		 */
		EClass TIME_LABEL = eINSTANCE.getTimeLabel();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimerOperationImpl <em>Timer Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimerOperationImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerOperation()
		 * @generated
		 */
		EClass TIMER_OPERATION = eINSTANCE.getTimerOperation();

		/**
		 * The meta object literal for the '<em><b>Timer</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIMER_OPERATION__TIMER = eINSTANCE.getTimerOperation_Timer();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIMER_OPERATION__COMPONENT_INSTANCE = eINSTANCE.getTimerOperation_ComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TIMER_OPERATION___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getTimerOperation__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AtomicBehaviourImpl <em>Atomic Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AtomicBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAtomicBehaviour()
		 * @generated
		 */
		EClass ATOMIC_BEHAVIOUR = eINSTANCE.getAtomicBehaviour();

		/**
		 * The meta object literal for the '<em><b>Time Constraint</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATOMIC_BEHAVIOUR__TIME_CONSTRAINT = eINSTANCE.getAtomicBehaviour_TimeConstraint();

		/**
		 * The meta object literal for the '<em><b>Time Label</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATOMIC_BEHAVIOUR__TIME_LABEL = eINSTANCE.getAtomicBehaviour_TimeLabel();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getAtomicBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.BehaviourImpl <em>Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.BehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBehaviour()
		 * @generated
		 */
		EClass BEHAVIOUR = eINSTANCE.getBehaviour();

		/**
		 * The meta object literal for the '<em><b>Test Objective</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOUR__TEST_OBJECTIVE = eINSTANCE.getBehaviour_TestObjective();

		/**
		 * The meta object literal for the '<em><b>Is Tester Input Event</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation BEHAVIOUR___IS_TESTER_INPUT_EVENT = eINSTANCE.getBehaviour__IsTesterInputEvent();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeConstraintImpl <em>Time Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeConstraintImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeConstraint()
		 * @generated
		 */
		EClass TIME_CONSTRAINT = eINSTANCE.getTimeConstraint();

		/**
		 * The meta object literal for the '<em><b>Time Constraint Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIME_CONSTRAINT__TIME_CONSTRAINT_EXPRESSION = eINSTANCE.getTimeConstraint_TimeConstraintExpression();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimerStartImpl <em>Timer Start</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimerStartImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerStart()
		 * @generated
		 */
		EClass TIMER_START = eINSTANCE.getTimerStart();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIMER_START__PERIOD = eINSTANCE.getTimerStart_Period();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimerStopImpl <em>Timer Stop</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimerStopImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimerStop()
		 * @generated
		 */
		EClass TIMER_STOP = eINSTANCE.getTimerStop();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeOutImpl <em>Time Out</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeOutImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeOut()
		 * @generated
		 */
		EClass TIME_OUT = eINSTANCE.getTimeOut();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeOperationImpl <em>Time Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeOperationImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeOperation()
		 * @generated
		 */
		EClass TIME_OPERATION = eINSTANCE.getTimeOperation();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIME_OPERATION__COMPONENT_INSTANCE = eINSTANCE.getTimeOperation_ComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIME_OPERATION__PERIOD = eINSTANCE.getTimeOperation_Period();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TIME_OPERATION___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getTimeOperation__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.WaitImpl <em>Wait</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.WaitImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getWait()
		 * @generated
		 */
		EClass WAIT = eINSTANCE.getWait();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.QuiescenceImpl <em>Quiescence</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.QuiescenceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getQuiescence()
		 * @generated
		 */
		EClass QUIESCENCE = eINSTANCE.getQuiescence();

		/**
		 * The meta object literal for the '<em><b>Gate Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUIESCENCE__GATE_REFERENCE = eINSTANCE.getQuiescence_GateReference();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation QUIESCENCE___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getQuiescence__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.GateReferenceImpl <em>Gate Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.GateReferenceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateReference()
		 * @generated
		 */
		EClass GATE_REFERENCE = eINSTANCE.getGateReference();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GATE_REFERENCE__COMPONENT = eINSTANCE.getGateReference_Component();

		/**
		 * The meta object literal for the '<em><b>Gate</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GATE_REFERENCE__GATE = eINSTANCE.getGateReference_Gate();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TimeLabelUseImpl <em>Time Label Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TimeLabelUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabelUse()
		 * @generated
		 */
		EClass TIME_LABEL_USE = eINSTANCE.getTimeLabelUse();

		/**
		 * The meta object literal for the '<em><b>Time Label</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIME_LABEL_USE__TIME_LABEL = eINSTANCE.getTimeLabelUse_TimeLabel();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIME_LABEL_USE__KIND = eINSTANCE.getTimeLabelUse_Kind();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TIME_LABEL_USE___RESOLVE_DATA_TYPE = eINSTANCE.getTimeLabelUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TestConfigurationImpl <em>Test Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TestConfigurationImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestConfiguration()
		 * @generated
		 */
		EClass TEST_CONFIGURATION = eINSTANCE.getTestConfiguration();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_CONFIGURATION__COMPONENT_INSTANCE = eINSTANCE.getTestConfiguration_ComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Connection</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_CONFIGURATION__CONNECTION = eINSTANCE.getTestConfiguration_Connection();

		/**
		 * The meta object literal for the '<em><b>Compatible With</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TEST_CONFIGURATION___COMPATIBLE_WITH__TESTCONFIGURATION_ELIST = eINSTANCE.getTestConfiguration__CompatibleWith__TestConfiguration_EList();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ConnectionImpl <em>Connection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ConnectionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConnection()
		 * @generated
		 */
		EClass CONNECTION = eINSTANCE.getConnection();

		/**
		 * The meta object literal for the '<em><b>End Point</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONNECTION__END_POINT = eINSTANCE.getConnection_EndPoint();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TestDescriptionImpl <em>Test Description</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TestDescriptionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestDescription()
		 * @generated
		 */
		EClass TEST_DESCRIPTION = eINSTANCE.getTestDescription();

		/**
		 * The meta object literal for the '<em><b>Test Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION__TEST_CONFIGURATION = eINSTANCE.getTestDescription_TestConfiguration();

		/**
		 * The meta object literal for the '<em><b>Formal Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION__FORMAL_PARAMETER = eINSTANCE.getTestDescription_FormalParameter();

		/**
		 * The meta object literal for the '<em><b>Behaviour Description</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION = eINSTANCE.getTestDescription_BehaviourDescription();

		/**
		 * The meta object literal for the '<em><b>Test Objective</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION__TEST_OBJECTIVE = eINSTANCE.getTestDescription_TestObjective();

		/**
		 * The meta object literal for the '<em><b>Is Locally Ordered</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEST_DESCRIPTION__IS_LOCALLY_ORDERED = eINSTANCE.getTestDescription_IsLocallyOrdered();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.BehaviourDescriptionImpl <em>Behaviour Description</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.BehaviourDescriptionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBehaviourDescription()
		 * @generated
		 */
		EClass BEHAVIOUR_DESCRIPTION = eINSTANCE.getBehaviourDescription();

		/**
		 * The meta object literal for the '<em><b>Behaviour</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOUR_DESCRIPTION__BEHAVIOUR = eINSTANCE.getBehaviourDescription_Behaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.BlockImpl <em>Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.BlockImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBlock()
		 * @generated
		 */
		EClass BLOCK = eINSTANCE.getBlock();

		/**
		 * The meta object literal for the '<em><b>Behaviour</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BLOCK__BEHAVIOUR = eINSTANCE.getBlock_Behaviour();

		/**
		 * The meta object literal for the '<em><b>Guard</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BLOCK__GUARD = eINSTANCE.getBlock_Guard();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation BLOCK___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getBlock__GetParticipatingComponents();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components Excluding</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation BLOCK___GET_PARTICIPATING_COMPONENTS_EXCLUDING__BEHAVIOUR = eINSTANCE.getBlock__GetParticipatingComponentsExcluding__Behaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CombinedBehaviourImpl <em>Combined Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CombinedBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCombinedBehaviour()
		 * @generated
		 */
		EClass COMBINED_BEHAVIOUR = eINSTANCE.getCombinedBehaviour();

		/**
		 * The meta object literal for the '<em><b>Periodic</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMBINED_BEHAVIOUR__PERIODIC = eINSTANCE.getCombinedBehaviour_Periodic();

		/**
		 * The meta object literal for the '<em><b>Exceptional</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMBINED_BEHAVIOUR__EXCEPTIONAL = eINSTANCE.getCombinedBehaviour_Exceptional();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.PeriodicBehaviourImpl <em>Periodic Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.PeriodicBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPeriodicBehaviour()
		 * @generated
		 */
		EClass PERIODIC_BEHAVIOUR = eINSTANCE.getPeriodicBehaviour();

		/**
		 * The meta object literal for the '<em><b>Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERIODIC_BEHAVIOUR__BLOCK = eINSTANCE.getPeriodicBehaviour_Block();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERIODIC_BEHAVIOUR__PERIOD = eINSTANCE.getPeriodicBehaviour_Period();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PERIODIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getPeriodicBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ExceptionalBehaviourImpl <em>Exceptional Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ExceptionalBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getExceptionalBehaviour()
		 * @generated
		 */
		EClass EXCEPTIONAL_BEHAVIOUR = eINSTANCE.getExceptionalBehaviour();

		/**
		 * The meta object literal for the '<em><b>Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCEPTIONAL_BEHAVIOUR__BLOCK = eINSTANCE.getExceptionalBehaviour_Block();

		/**
		 * The meta object literal for the '<em><b>Guarded Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCEPTIONAL_BEHAVIOUR__GUARDED_COMPONENT = eINSTANCE.getExceptionalBehaviour_GuardedComponent();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation EXCEPTIONAL_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getExceptionalBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AlternativeBehaviourImpl <em>Alternative Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AlternativeBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAlternativeBehaviour()
		 * @generated
		 */
		EClass ALTERNATIVE_BEHAVIOUR = eINSTANCE.getAlternativeBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MultipleCombinedBehaviourImpl <em>Multiple Combined Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MultipleCombinedBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMultipleCombinedBehaviour()
		 * @generated
		 */
		EClass MULTIPLE_COMBINED_BEHAVIOUR = eINSTANCE.getMultipleCombinedBehaviour();

		/**
		 * The meta object literal for the '<em><b>Block</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MULTIPLE_COMBINED_BEHAVIOUR__BLOCK = eINSTANCE.getMultipleCombinedBehaviour_Block();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation MULTIPLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getMultipleCombinedBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ParallelBehaviourImpl <em>Parallel Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ParallelBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParallelBehaviour()
		 * @generated
		 */
		EClass PARALLEL_BEHAVIOUR = eINSTANCE.getParallelBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.BoundedLoopBehaviourImpl <em>Bounded Loop Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.BoundedLoopBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBoundedLoopBehaviour()
		 * @generated
		 */
		EClass BOUNDED_LOOP_BEHAVIOUR = eINSTANCE.getBoundedLoopBehaviour();

		/**
		 * The meta object literal for the '<em><b>Num Iteration</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BOUNDED_LOOP_BEHAVIOUR__NUM_ITERATION = eINSTANCE.getBoundedLoopBehaviour_NumIteration();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.SingleCombinedBehaviourImpl <em>Single Combined Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.SingleCombinedBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getSingleCombinedBehaviour()
		 * @generated
		 */
		EClass SINGLE_COMBINED_BEHAVIOUR = eINSTANCE.getSingleCombinedBehaviour();

		/**
		 * The meta object literal for the '<em><b>Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SINGLE_COMBINED_BEHAVIOUR__BLOCK = eINSTANCE.getSingleCombinedBehaviour_Block();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SINGLE_COMBINED_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getSingleCombinedBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.OptionalBehaviourImpl <em>Optional Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.OptionalBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getOptionalBehaviour()
		 * @generated
		 */
		EClass OPTIONAL_BEHAVIOUR = eINSTANCE.getOptionalBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.UnboundedLoopBehaviourImpl <em>Unbounded Loop Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.UnboundedLoopBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getUnboundedLoopBehaviour()
		 * @generated
		 */
		EClass UNBOUNDED_LOOP_BEHAVIOUR = eINSTANCE.getUnboundedLoopBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ConditionalBehaviourImpl <em>Conditional Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ConditionalBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConditionalBehaviour()
		 * @generated
		 */
		EClass CONDITIONAL_BEHAVIOUR = eINSTANCE.getConditionalBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CompoundBehaviourImpl <em>Compound Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CompoundBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCompoundBehaviour()
		 * @generated
		 */
		EClass COMPOUND_BEHAVIOUR = eINSTANCE.getCompoundBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DefaultBehaviourImpl <em>Default Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DefaultBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDefaultBehaviour()
		 * @generated
		 */
		EClass DEFAULT_BEHAVIOUR = eINSTANCE.getDefaultBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.InterruptBehaviourImpl <em>Interrupt Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.InterruptBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInterruptBehaviour()
		 * @generated
		 */
		EClass INTERRUPT_BEHAVIOUR = eINSTANCE.getInterruptBehaviour();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TargetImpl <em>Target</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TargetImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTarget()
		 * @generated
		 */
		EClass TARGET = eINSTANCE.getTarget();

		/**
		 * The meta object literal for the '<em><b>Target Gate</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TARGET__TARGET_GATE = eINSTANCE.getTarget_TargetGate();

		/**
		 * The meta object literal for the '<em><b>Value Assignment</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TARGET__VALUE_ASSIGNMENT = eINSTANCE.getTarget_ValueAssignment();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.VerdictAssignmentImpl <em>Verdict Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.VerdictAssignmentImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getVerdictAssignment()
		 * @generated
		 */
		EClass VERDICT_ASSIGNMENT = eINSTANCE.getVerdictAssignment();

		/**
		 * The meta object literal for the '<em><b>Verdict</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERDICT_ASSIGNMENT__VERDICT = eINSTANCE.getVerdictAssignment_Verdict();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AssertionImpl <em>Assertion</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AssertionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAssertion()
		 * @generated
		 */
		EClass ASSERTION = eINSTANCE.getAssertion();

		/**
		 * The meta object literal for the '<em><b>Otherwise</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSERTION__OTHERWISE = eINSTANCE.getAssertion_Otherwise();

		/**
		 * The meta object literal for the '<em><b>Condition</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSERTION__CONDITION = eINSTANCE.getAssertion_Condition();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.StopImpl <em>Stop</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.StopImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getStop()
		 * @generated
		 */
		EClass STOP = eINSTANCE.getStop();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.BreakImpl <em>Break</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.BreakImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getBreak()
		 * @generated
		 */
		EClass BREAK = eINSTANCE.getBreak();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.AssignmentImpl <em>Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.AssignmentImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT = eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__VARIABLE = eINSTANCE.getAssignment_Variable();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__EXPRESSION = eINSTANCE.getAssignment_Expression();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ASSIGNMENT___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getAssignment__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ActionBehaviourImpl <em>Action Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ActionBehaviourImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getActionBehaviour()
		 * @generated
		 */
		EClass ACTION_BEHAVIOUR = eINSTANCE.getActionBehaviour();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION_BEHAVIOUR__COMPONENT_INSTANCE = eINSTANCE.getActionBehaviour_ComponentInstance();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ACTION_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getActionBehaviour__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.InlineActionImpl <em>Inline Action</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.InlineActionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInlineAction()
		 * @generated
		 */
		EClass INLINE_ACTION = eINSTANCE.getInlineAction();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INLINE_ACTION__BODY = eINSTANCE.getInlineAction_Body();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ActionReferenceImpl <em>Action Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ActionReferenceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getActionReference()
		 * @generated
		 */
		EClass ACTION_REFERENCE = eINSTANCE.getActionReference();

		/**
		 * The meta object literal for the '<em><b>Action</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION_REFERENCE__ACTION = eINSTANCE.getActionReference_Action();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION_REFERENCE__ARGUMENT = eINSTANCE.getActionReference_Argument();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.TestDescriptionReferenceImpl <em>Test Description Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.TestDescriptionReferenceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTestDescriptionReference()
		 * @generated
		 */
		EClass TEST_DESCRIPTION_REFERENCE = eINSTANCE.getTestDescriptionReference();

		/**
		 * The meta object literal for the '<em><b>Test Description</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION_REFERENCE__TEST_DESCRIPTION = eINSTANCE.getTestDescriptionReference_TestDescription();

		/**
		 * The meta object literal for the '<em><b>Component Instance Binding</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION_REFERENCE__COMPONENT_INSTANCE_BINDING = eINSTANCE.getTestDescriptionReference_ComponentInstanceBinding();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_DESCRIPTION_REFERENCE__ARGUMENT = eINSTANCE.getTestDescriptionReference_Argument();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation TEST_DESCRIPTION_REFERENCE___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getTestDescriptionReference__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ComponentInstanceBindingImpl <em>Component Instance Binding</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ComponentInstanceBindingImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstanceBinding()
		 * @generated
		 */
		EClass COMPONENT_INSTANCE_BINDING = eINSTANCE.getComponentInstanceBinding();

		/**
		 * The meta object literal for the '<em><b>Formal Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCE_BINDING__FORMAL_COMPONENT = eINSTANCE.getComponentInstanceBinding_FormalComponent();

		/**
		 * The meta object literal for the '<em><b>Actual Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_INSTANCE_BINDING__ACTUAL_COMPONENT = eINSTANCE.getComponentInstanceBinding_ActualComponent();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.InteractionImpl <em>Interaction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.InteractionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getInteraction()
		 * @generated
		 */
		EClass INTERACTION = eINSTANCE.getInteraction();

		/**
		 * The meta object literal for the '<em><b>Source Gate</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERACTION__SOURCE_GATE = eINSTANCE.getInteraction_SourceGate();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERACTION__TARGET = eINSTANCE.getInteraction_Target();

		/**
		 * The meta object literal for the '<em><b>Get Participating Components</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation INTERACTION___GET_PARTICIPATING_COMPONENTS = eINSTANCE.getInteraction__GetParticipatingComponents();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MessageImpl <em>Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MessageImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMessage()
		 * @generated
		 */
		EClass MESSAGE = eINSTANCE.getMessage();

		/**
		 * The meta object literal for the '<em><b>Is Trigger</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__IS_TRIGGER = eINSTANCE.getMessage_IsTrigger();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__ARGUMENT = eINSTANCE.getMessage_Argument();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.PredefinedFunctionImpl <em>Predefined Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.PredefinedFunctionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPredefinedFunction()
		 * @generated
		 */
		EClass PREDEFINED_FUNCTION = eINSTANCE.getPredefinedFunction();

		/**
		 * The meta object literal for the '<em><b>Return Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PREDEFINED_FUNCTION__RETURN_TYPE = eINSTANCE.getPredefinedFunction_ReturnType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.MemberReferenceImpl <em>Member Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.MemberReferenceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getMemberReference()
		 * @generated
		 */
		EClass MEMBER_REFERENCE = eINSTANCE.getMemberReference();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_REFERENCE__MEMBER = eINSTANCE.getMemberReference_Member();

		/**
		 * The meta object literal for the '<em><b>Collection Index</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_REFERENCE__COLLECTION_INDEX = eINSTANCE.getMemberReference_CollectionIndex();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.PredefinedFunctionCallImpl <em>Predefined Function Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.PredefinedFunctionCallImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getPredefinedFunctionCall()
		 * @generated
		 */
		EClass PREDEFINED_FUNCTION_CALL = eINSTANCE.getPredefinedFunctionCall();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PREDEFINED_FUNCTION_CALL__FUNCTION = eINSTANCE.getPredefinedFunctionCall_Function();

		/**
		 * The meta object literal for the '<em><b>Actual Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PREDEFINED_FUNCTION_CALL__ACTUAL_PARAMETERS = eINSTANCE.getPredefinedFunctionCall_ActualParameters();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PREDEFINED_FUNCTION_CALL___RESOLVE_DATA_TYPE = eINSTANCE.getPredefinedFunctionCall__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.LocalExpressionImpl <em>Local Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.LocalExpressionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getLocalExpression()
		 * @generated
		 */
		EClass LOCAL_EXPRESSION = eINSTANCE.getLocalExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOCAL_EXPRESSION__EXPRESSION = eINSTANCE.getLocalExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Component Instance</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOCAL_EXPRESSION__COMPONENT_INSTANCE = eINSTANCE.getLocalExpression_ComponentInstance();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ValueAssignmentImpl <em>Value Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ValueAssignmentImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getValueAssignment()
		 * @generated
		 */
		EClass VALUE_ASSIGNMENT = eINSTANCE.getValueAssignment();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VALUE_ASSIGNMENT__VARIABLE = eINSTANCE.getValueAssignment_Variable();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VALUE_ASSIGNMENT__PARAMETER = eINSTANCE.getValueAssignment_Parameter();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ProcedureCallImpl <em>Procedure Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ProcedureCallImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureCall()
		 * @generated
		 */
		EClass PROCEDURE_CALL = eINSTANCE.getProcedureCall();

		/**
		 * The meta object literal for the '<em><b>Signature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCEDURE_CALL__SIGNATURE = eINSTANCE.getProcedureCall_Signature();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCEDURE_CALL__ARGUMENT = eINSTANCE.getProcedureCall_Argument();

		/**
		 * The meta object literal for the '<em><b>Reply To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCEDURE_CALL__REPLY_TO = eINSTANCE.getProcedureCall_ReplyTo();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ProcedureSignatureImpl <em>Procedure Signature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ProcedureSignatureImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureSignature()
		 * @generated
		 */
		EClass PROCEDURE_SIGNATURE = eINSTANCE.getProcedureSignature();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCEDURE_SIGNATURE__PARAMETER = eINSTANCE.getProcedureSignature_Parameter();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ProcedureParameterImpl <em>Procedure Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ProcedureParameterImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getProcedureParameter()
		 * @generated
		 */
		EClass PROCEDURE_PARAMETER = eINSTANCE.getProcedureParameter();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCEDURE_PARAMETER__KIND = eINSTANCE.getProcedureParameter_Kind();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CollectionDataTypeImpl <em>Collection Data Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CollectionDataTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCollectionDataType()
		 * @generated
		 */
		EClass COLLECTION_DATA_TYPE = eINSTANCE.getCollectionDataType();

		/**
		 * The meta object literal for the '<em><b>Item Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLLECTION_DATA_TYPE__ITEM_TYPE = eINSTANCE.getCollectionDataType_ItemType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CollectionDataInstanceImpl <em>Collection Data Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CollectionDataInstanceImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCollectionDataInstance()
		 * @generated
		 */
		EClass COLLECTION_DATA_INSTANCE = eINSTANCE.getCollectionDataInstance();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLLECTION_DATA_INSTANCE__ITEM = eINSTANCE.getCollectionDataInstance_Item();

		/**
		 * The meta object literal for the '<em><b>Unassigned Member</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COLLECTION_DATA_INSTANCE__UNASSIGNED_MEMBER = eINSTANCE.getCollectionDataInstance_UnassignedMember();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ExtensionImpl <em>Extension</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ExtensionImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getExtension()
		 * @generated
		 */
		EClass EXTENSION = eINSTANCE.getExtension();

		/**
		 * The meta object literal for the '<em><b>Extending</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTENSION__EXTENDING = eINSTANCE.getExtension_Extending();

		/**
		 * The meta object literal for the '<em><b>Transitive Extending</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation EXTENSION___TRANSITIVE_EXTENDING = eINSTANCE.getExtension__TransitiveExtending();

		/**
		 * The meta object literal for the '<em><b>Is Extending</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation EXTENSION___IS_EXTENDING__PACKAGEABLEELEMENT = eINSTANCE.getExtension__IsExtending__PackageableElement();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.LiteralValueUseImpl <em>Literal Value Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.LiteralValueUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getLiteralValueUse()
		 * @generated
		 */
		EClass LITERAL_VALUE_USE = eINSTANCE.getLiteralValueUse();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LITERAL_VALUE_USE__VALUE = eINSTANCE.getLiteralValueUse_Value();

		/**
		 * The meta object literal for the '<em><b>Int Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LITERAL_VALUE_USE__INT_VALUE = eINSTANCE.getLiteralValueUse_IntValue();

		/**
		 * The meta object literal for the '<em><b>Bool Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LITERAL_VALUE_USE__BOOL_VALUE = eINSTANCE.getLiteralValueUse_BoolValue();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LITERAL_VALUE_USE__DATA_TYPE = eINSTANCE.getLiteralValueUse_DataType();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation LITERAL_VALUE_USE___RESOLVE_DATA_TYPE = eINSTANCE.getLiteralValueUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ConstraintTypeImpl <em>Constraint Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ConstraintTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConstraintType()
		 * @generated
		 */
		EClass CONSTRAINT_TYPE = eINSTANCE.getConstraintType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.ConstraintImpl <em>Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.ConstraintImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getConstraint()
		 * @generated
		 */
		EClass CONSTRAINT = eINSTANCE.getConstraint();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSTRAINT__TYPE = eINSTANCE.getConstraint_Type();

		/**
		 * The meta object literal for the '<em><b>Quantifier</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSTRAINT__QUANTIFIER = eINSTANCE.getConstraint_Quantifier();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.EnumDataTypeImpl <em>Enum Data Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.EnumDataTypeImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getEnumDataType()
		 * @generated
		 */
		EClass ENUM_DATA_TYPE = eINSTANCE.getEnumDataType();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENUM_DATA_TYPE__VALUE = eINSTANCE.getEnumDataType_Value();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.DataElementUseImpl <em>Data Element Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.DataElementUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getDataElementUse()
		 * @generated
		 */
		EClass DATA_ELEMENT_USE = eINSTANCE.getDataElementUse();

		/**
		 * The meta object literal for the '<em><b>Unassigned Member</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_ELEMENT_USE__UNASSIGNED_MEMBER = eINSTANCE.getDataElementUse_UnassignedMember();

		/**
		 * The meta object literal for the '<em><b>Data Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_ELEMENT_USE__DATA_ELEMENT = eINSTANCE.getDataElementUse_DataElement();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_ELEMENT_USE__ITEM = eINSTANCE.getDataElementUse_Item();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATA_ELEMENT_USE___RESOLVE_DATA_TYPE = eINSTANCE.getDataElementUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.impl.CastDataUseImpl <em>Cast Data Use</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.impl.CastDataUseImpl
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getCastDataUse()
		 * @generated
		 */
		EClass CAST_DATA_USE = eINSTANCE.getCastDataUse();

		/**
		 * The meta object literal for the '<em><b>Data Use</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAST_DATA_USE__DATA_USE = eINSTANCE.getCastDataUse_DataUse();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAST_DATA_USE__DATA_TYPE = eINSTANCE.getCastDataUse_DataType();

		/**
		 * The meta object literal for the '<em><b>Resolve Data Type</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation CAST_DATA_USE___RESOLVE_DATA_TYPE = eINSTANCE.getCastDataUse__ResolveDataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.UnassignedMemberTreatment <em>Unassigned Member Treatment</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.UnassignedMemberTreatment
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getUnassignedMemberTreatment()
		 * @generated
		 */
		EEnum UNASSIGNED_MEMBER_TREATMENT = eINSTANCE.getUnassignedMemberTreatment();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.ComponentInstanceRole <em>Component Instance Role</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.ComponentInstanceRole
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getComponentInstanceRole()
		 * @generated
		 */
		EEnum COMPONENT_INSTANCE_ROLE = eINSTANCE.getComponentInstanceRole();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.GateTypeKind <em>Gate Type Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.GateTypeKind
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getGateTypeKind()
		 * @generated
		 */
		EEnum GATE_TYPE_KIND = eINSTANCE.getGateTypeKind();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.TimeLabelUseKind <em>Time Label Use Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.TimeLabelUseKind
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getTimeLabelUseKind()
		 * @generated
		 */
		EEnum TIME_LABEL_USE_KIND = eINSTANCE.getTimeLabelUseKind();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.ParameterKind <em>Parameter Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.ParameterKind
		 * @see org.etsi.mts.tdl.impl.tdlPackageImpl#getParameterKind()
		 * @generated
		 */
		EEnum PARAMETER_KIND = eINSTANCE.getParameterKind();

	}

} //tdlPackage
