package org.etsi.mts.tdl.constraints.helper;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.etsi.mts.tdl.document.model.Content;
import org.etsi.mts.tdl.document.model.Document;

public class DocumentHandler {
	public static Document loadDocument(String filename) {
		Document doc = new Document();
		try {
			if (!filename.endsWith(".docx") && !filename.startsWith("~$")) {
				return null;
			}

			File file = new File(filename);
			FileInputStream fis = new FileInputStream(file.getAbsolutePath());
			XWPFDocument document = new XWPFDocument(fis);
	
			List<IBodyElement> bodyElements = document.getBodyElements();

			int currentLevel = 0;
			
			doc.setFilename(filename);
			doc.setTitle(document.getProperties().getCoreProperties().getTitle());
			Content p = doc;
			Content toc = null;
			for (IBodyElement e : bodyElements) {
				if (e instanceof XWPFParagraph) {
					String text = ((XWPFParagraph) e).getText().trim();
//					System.out.println(text);
//					if (text.startsWith("8.2.1")) {
//						System.out.println("hit");
//					}
					if (((XWPFParagraph) e).getStyle()!=null
					  && (document.getStyles().getStyle(((XWPFParagraph) e).getStyleID()).getName().startsWith("heading")
					  || document.getStyles().getStyle(((XWPFParagraph) e).getStyleID()).getName().matches("[Hh]\\d"))
					) {
						XWPFStyle style = document.getStyles().getStyle(((XWPFParagraph) e).getStyleID());
						String level =
								style.getName()
									.replaceAll("heading", "")
									.replaceAll("h", "")
									.replaceAll("H", "")
									.trim();
						int l = Integer.parseInt(level);
						if (l == 8 && text.startsWith("Annex")) {
							l = 1;
						}
//						if (l == 6) {
//							System.out.println(text);
//						}
						
						if (l > currentLevel) {
			    			p = new Content(p, text);
						} else if (l < currentLevel) {
							ArrayList<Content> parents = new ArrayList<>();
							Content nextParent = p.getParent();
							while (nextParent!=null) {
								parents.add(nextParent);
								nextParent = nextParent.getParent();
							}
//							if (text.startsWith("8.2.2")) {
//								System.out.println("hit");
//								System.out.println(parents);
//							}
							p = parents.get(parents.size()-l-1);
							
//							for (int i = currentLevel; i > l; i--) {
//								if (p.getParent().getParent()!=null) {
////									System.out.println(p);
//									p = p.getParent();
////									System.out.println(p);
//								}
//							}
			    			p = new Content(p.getParent(), text);
			    			p.setText(text);
						} else {
			    			p = new Content(p.getParent(), text);
						}
						currentLevel = l;
					} else {
						if (!text.isEmpty()) {
							XWPFParagraph paragraph = (XWPFParagraph)e;
							if (paragraph.getStyle()!=null) {
								XWPFStyle style = paragraph.getDocument().getStyles().getStyle(paragraph.getStyleID());
								if (style.getName().startsWith("toc")) {
									String tocToken = ":Table of Contents:";
									if (toc == null) {
										toc = new Content(doc, tocToken);
									}
									Content txt = new Content(toc, text);
								} else {
									Content txt = new Content(p, text);
								}
							} else {
								Content txt = new Content(p, text);
							}

						}
					}
				} else if (e instanceof XWPFTable) {     
					XWPFTable table = (XWPFTable) e;
					String text = table.getText();
					for (String l:text.split("\n")) {
						Content txt = new Content(p, l);
					}
					//getAttributes(table, p.getParent()); 
			    } else {
			    }
			}
			
			document.close();
			fis.close();
	    } catch (Exception e) {
	        e.printStackTrace();
	    }
		return doc;
	}

}
