/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.poi.openxml4j.util.ZipArchiveFakeEntry;
import org.apache.poi.openxml4j.util.ZipArchiveThresholdInputStream;
import org.apache.poi.openxml4j.util.ZipEntrySource;

public class ZipInputStreamZipEntrySource
implements ZipEntrySource {
    private final Map<String, ZipArchiveFakeEntry> zipEntries = new HashMap<String, ZipArchiveFakeEntry>();

    public ZipInputStreamZipEntrySource(ZipArchiveThresholdInputStream inp) throws IOException {
        ZipArchiveEntry zipEntry;
        while ((zipEntry = inp.getNextEntry()) != null) {
            this.zipEntries.put(zipEntry.getName(), new ZipArchiveFakeEntry(zipEntry, inp));
        }
    }

    @Override
    public Enumeration<? extends ZipArchiveEntry> getEntries() {
        return IteratorUtils.asEnumeration(this.zipEntries.values().iterator());
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry zipEntry) {
        assert (zipEntry instanceof ZipArchiveFakeEntry);
        return ((ZipArchiveFakeEntry)zipEntry).getInputStream();
    }

    @Override
    public void close() {
        this.zipEntries.clear();
    }

    @Override
    public boolean isClosed() {
        return this.zipEntries.isEmpty();
    }

    @Override
    public ZipArchiveEntry getEntry(String path) {
        String normalizedPath = path.replace('\\', '/');
        ZipArchiveEntry ze = this.zipEntries.get(normalizedPath);
        if (ze != null) {
            return ze;
        }
        for (Map.Entry<String, ZipArchiveFakeEntry> fze : this.zipEntries.entrySet()) {
            if (!normalizedPath.equalsIgnoreCase(fze.getKey())) continue;
            return fze.getValue();
        }
        return null;
    }
}

