# Generated Documentation

## Requirements

### API: Examples for RESTful API guide

| Identifier | Reference  | Type | Applicability | Requirement  | Context |
| ---------- | ---------- | ---- | ------------- | ------------ | ------- |
| RQ_RESOURCE_ID_GET_001 | Path: /resource/{id} | M | RESOURCE_ID | Read a resource; Read full contents of a resource with specific ID | getResource |
| RQ_RESOURCE_POST_001 | Path: /resource | M | RESOURCE | Create new resource;  | postResource |
| RQ_RESOURCE_ID_FILE_PUT_001 | Path: /resource/{id}/file | M | RESOURCE_ID_FILE | Upload a file for a resource;  | uploadResourceFile |
| RQ_SEARCH_GET_001 | Path: /search | M | SEARCH | Search resource;  | searchResource |
| RQ_SUBSCRIPTION_POST_001 | Path: /subscription | M | SUBSCRIPTION | Subscribe to authenticated notifications;  | subscribeNotifications |
| RQ_SERVICE_GET_001 | Path: /service | M | SERVICE |  | getService |
[Table X.Y: Extracted requirements]{custom-style="FL"}

## Implementation Conformance Statements

#### Detail

| ID | Resource  | Reference | Method | Type  | Request | Response |
| -- | --------- | --------- | ------ | ----- | ------- | -------- |
| D_RESOURCE_ID_GET_200_001 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200 |
| D_RESOURCE_ID_GET_401_002 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 401 |
| D_RESOURCE_ID_GET_404_003 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 404 |
| D_RESOURCE_POST_204_001 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| D_RESOURCE_ID_FILE_PUT_204_001 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| D_SEARCH_GET_200_001 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| D_SUBSCRIPTION_POST_201_001 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| D_SERVICE_GET_200_001 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
[Table X.Y: Extracted ICS (Detail)]{custom-style="FL"}

#### Method

| ID | Resource  | Reference | Method | Type  | Request | Response |
| -- | --------- | --------- | ------ | ----- | ------- | -------- |
| M1 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200,401,404 |
| M2 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| M3 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| M4 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| M5 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| M6 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
[Table X.Y: Extracted ICS (Method)]{custom-style="FL"}

#### Path

| ID | Resource  | Reference | Method | Type  | Request | Response |
| -- | --------- | --------- | ------ | ----- | ------- | -------- |
| P1 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200,401,404 |
| P2 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| P3 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| P4 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| P5 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| P6 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
[Table X.Y: Extracted ICS (Path)]{custom-style="FL"}

#### Hierarchical

| ID | Resource  | Reference | Method | Type  | Request | Response |
| -- | --------- | --------- | ------ | ----- | ------- | -------- |
| P1 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200,401,404 |
| P1_M1 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200,401,404 |
| P1_M1_R1 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 200 |
| P1_M1_R2 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 401 |
| P1_M1_R3 | /resource/{id} | Path: /resource/{id} : getResource | GET | M | (fill in request) | 404 |
| P2 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| P2_M1 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| P2_M1_R1 | /resource | Path: /resource : postResource | POST | M | (fill in request) | 204 |
| P3 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| P3_M1 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| P3_M1_R1 | /resource/{id}/file | Path: /resource/{id}/file : uploadResourceFile | PUT | M | (fill in request) | 204 |
| P4 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| P4_M1 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| P4_M1_R1 | /search | Path: /search : searchResource | GET | M | (fill in request) | 200 |
| P5 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| P5_M1 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| P5_M1_R1 | /subscription | Path: /subscription : subscribeNotifications | POST | M | (fill in request) | 201 |
| P6 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
| P6_M1 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
| P6_M1_R1 | /service | Path: /service : getService | GET | M | (fill in request) | 200 |
[Table X.Y: Extracted ICS (Hierarchical)]{custom-style="FL"}

## Test Suite Structure

* API: Examples for RESTful API guide
  * RESOURCE_ID
    * GET
      * GET_200
      * GET_401
      * GET_404
  * RESOURCE
    * POST
      * POST_204
  * RESOURCE_ID_FILE
    * PUT
      * PUT_204
  * SEARCH
    * GET
      * GET_200
  * SUBSCRIPTION
    * POST
      * POST_201
  * SERVICE
    * GET
      * GET_200
