/**
 */
package org.etsi.mts.tdl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Unassigned Member Treatment</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.tdlPackage#getUnassignedMemberTreatment()
 * @model
 * @generated
 */
public enum UnassignedMemberTreatment implements Enumerator
{
	/**
	 * The '<em><b>Undefined</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNDEFINED_VALUE
	 * @generated
	 * @ordered
	 */
	UNDEFINED(0, "undefined", "undefined"),

	/**
	 * The '<em><b>Any Value</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ANY_VALUE_VALUE
	 * @generated
	 * @ordered
	 */
	ANY_VALUE(1, "AnyValue", "AnyValue"),

	/**
	 * The '<em><b>Any Value Or Omit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ANY_VALUE_OR_OMIT_VALUE
	 * @generated
	 * @ordered
	 */
	ANY_VALUE_OR_OMIT(2, "AnyValueOrOmit", "AnyValueOrOmit");

	/**
	 * The '<em><b>Undefined</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNDEFINED
	 * @model name="undefined"
	 * @generated
	 * @ordered
	 */
	public static final int UNDEFINED_VALUE = 0;

	/**
	 * The '<em><b>Any Value</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ANY_VALUE
	 * @model name="AnyValue"
	 * @generated
	 * @ordered
	 */
	public static final int ANY_VALUE_VALUE = 1;

	/**
	 * The '<em><b>Any Value Or Omit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ANY_VALUE_OR_OMIT
	 * @model name="AnyValueOrOmit"
	 * @generated
	 * @ordered
	 */
	public static final int ANY_VALUE_OR_OMIT_VALUE = 2;

	/**
	 * An array of all the '<em><b>Unassigned Member Treatment</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final UnassignedMemberTreatment[] VALUES_ARRAY =
		new UnassignedMemberTreatment[]
		{
			UNDEFINED,
			ANY_VALUE,
			ANY_VALUE_OR_OMIT,
		};

	/**
	 * A public read-only list of all the '<em><b>Unassigned Member Treatment</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<UnassignedMemberTreatment> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Unassigned Member Treatment</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static UnassignedMemberTreatment get(String literal)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i)
		{
			UnassignedMemberTreatment result = VALUES_ARRAY[i];
			if (result.toString().equals(literal))
			{
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Unassigned Member Treatment</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static UnassignedMemberTreatment getByName(String name)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i)
		{
			UnassignedMemberTreatment result = VALUES_ARRAY[i];
			if (result.getName().equals(name))
			{
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Unassigned Member Treatment</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static UnassignedMemberTreatment get(int value)
	{
		switch (value)
		{
			case UNDEFINED_VALUE: return UNDEFINED;
			case ANY_VALUE_VALUE: return ANY_VALUE;
			case ANY_VALUE_OR_OMIT_VALUE: return ANY_VALUE_OR_OMIT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private UnassignedMemberTreatment(int value, String name, String literal)
	{
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue()
	{
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName()
	{
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral()
	{
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString()
	{
		return literal;
	}
	
} //UnassignedMemberTreatment
