/*
 * generated by Xtext 2.27.0
 */
package org.etsi.mts.tdl.ui.wizard


import org.eclipse.xtext.ui.wizard.template.FileTemplate
import org.eclipse.xtext.ui.wizard.template.IFileGenerator
import org.eclipse.xtext.ui.wizard.template.IFileTemplateProvider
import org.etsi.mts.tdl.openapi2tdl.next.ConverterNext
import org.eclipse.core.runtime.preferences.InstanceScope
import org.eclipse.ui.preferences.ScopedPreferenceStore
import org.etsi.mts.tdl.ui.wizard.TemplateHelper.Libraries

/**
 * Create a list with all file templates to be shown in the template new file wizard.
 * 
 * Each template is able to generate one or more files.
 */
class TDLtxFileTemplateProvider implements IFileTemplateProvider {
	override getFileTemplates() {
		#[
			new TDLtxFile, 
			new TDLtxFileFromOpenAPI,
			new TDLtxLibrary
		]
	}
}

@FileTemplate(label="TDLtx", icon="file_template.png", description="Create a new package for TDLtx.")
final class TDLtxFile {
	//TODO: make it more sensible
	val packageName = text("Package Name:", "EmptyPackage", "The name of the package")

    //TODO: reuse?
	override generateFiles(IFileGenerator generator) {
		generator.generate('''«folder»/«name».tdltx''', '''
			/*
			 * This is an example model
			 */
			Package «packageName» {
			    
			}
		''')
//        generator.generate('''«folder»/«packageName».tdltx''', TemplateContent.Example)
	}
}

@FileTemplate(label="TDLtx Library", icon="file_template.png", description="Add library for TDL.")
final class TDLtxLibrary {
	//TODO: make it more sensible
	//TODO: name should not be asked for...
	val name = text("Name:", "TDL")
	val packageName = combo("Library:", #["TDL", "HTTP"], "The library to be added.")
	var validated = false

	override protected updateVariables() {
		validated = true
		super.updateVariables()
	}

    //TODO: reuse?
	override generateFiles(IFileGenerator generator) {
		//TODO: use enum values?
		if (validated) {
			generator.generate('''«folder»/«name».tdltx''', TemplateHelper.getLibrary(packageName.value))
		}		
	}
}


@FileTemplate(label="Data definitions import from OpenAPI", icon="file_template.png", description="Create a new package for TDLtx from OpenAPI data definitions.")
final class TDLtxFileFromOpenAPI {
    //TODO: more modern way?
	val s = new ScopedPreferenceStore(new InstanceScope(), "org.etsi.mts.tdl.tx.ui.template.data.openapi")
    val lastUsed = "LAST_USED"
    //TODO: file prompt?
    val dataDefinitionsPath = text("Data Definitions Path:", s.getString(lastUsed), "The data definitions path to import from")
    val sourceMapping = text("Source mapping tag:", "SOURCE_MAPPING", "The source mapping tag to be used for the data mappings")
    val targetMapping = text("Target mapping tag:", "TARGET_MAPPING", "The target mapping tag to be used for the data mappings")
	    
	var validated = false
	
	override protected updateVariables() {
		validated = true
		s.setValue(lastUsed, dataDefinitionsPath.value)
		s.save()
		super.updateVariables()
	}
	
    override generateFiles(IFileGenerator generator) {
		//NOTE: this is triggered on every key stroke.. -> lock until second screen
		if (validated) {
			generator.generate('''«folder»/«name».tdltx''', 
				ConverterNext.processToString(dataDefinitionsPath.value, 
					folder+"/"+name+".tdltx", 
					sourceMapping.value, 
					targetMapping.value
			))
		}
    }
	
}
