package org.etsi.mts.tdl.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class TdlNature implements IProjectNature {
	
    public static final String NATURE_ID = "org.etsi.mts.tdl.nature";
   
	public static void setTdlProjectNature(IProject project) throws CoreException {
		IProjectDescription desc = project.getDescription();
		String[] ids = desc.getNatureIds();

		String[] newIds = new String[ids.length + 1];
		System.arraycopy(ids, 0, newIds, 1, ids.length);
		newIds[0] = NATURE_ID;
		desc.setNatureIds(newIds);
		project.setDescription(desc, null);
	}
	
	public static boolean isTdl(IProject prj) throws CoreException {
		if (!prj.exists() || !prj.isOpen())
			return false;
		try {
			for (String nature: prj.getDescription().getNatureIds())
				if (NATURE_ID.equals(nature))
					return true;
		} catch (Exception e) {
			String msg = e.getMessage();
			if (msg == null ||!msg.endsWith("does not exist."))
				throw new CoreException(Status.warning("Failed to detect natures of project " + prj, e));
			else
				throw new CoreException(Status.warning(msg, e));
		}
		return false;
	}

	@Override
	public void configure() throws CoreException {
		// TODO Auto-generated method stub

	}

	@Override
	public void deconfigure() throws CoreException {
		// TODO Auto-generated method stub

	}

	@Override
	public IProject getProject() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setProject(IProject project) {
		// TODO Auto-generated method stub

	}

}
