package org.etsi.mts.tdl.execution.java.tri;

import java.util.Collection;
import java.util.List;

/**
 * Representation of a TDL model element of class <i>DataInstance</i> or
 * <i>DataUse</i> and their sub-classes.
 */
public interface Value extends NamedElement {
	/**
	 * If this value is a structure.
	 * 
	 * @return <b>true</b> if the type of this value represents a
	 *         <i>StructureDataType</i> element.
	 */
	boolean isStructure();

	/**
	 * If this value is a collection.
	 * 
	 * @return <b>true</b> if the type of this value represents a
	 *         <i>CollectionDataType</i> element.
	 */
	boolean isCollection();

	/**
	 * Get the data mapping chosen for the runtime. The mapping that is chosen is
	 * implementation specific.
	 * 
	 * @return A <code>Mapping</code> representing a <i>DataElementMapping</i>
	 *         element.
	 */
	Mapping getMapping();

	/**
	 * Get the primitive or special value of this value object.
	 * 
	 * @return A <code>String</code>, a <code>Boolean</code> or any other boxed
	 *         primitive value or an instance of {@link SpecialValue SpecialValue}.
	 */
	Object getValue();

	/**
	 * Get the names of members of the structured type of this value. Only returns
	 * the parameters that have a value assigned.
	 * 
	 * @return Collection of names from the <i>MemberAssignment</i> or
	 *         <i>ParameterBinding</i> elements contained in the corresponding
	 *         <i>DataInstance</i> or <i>DataUse</i> element.
	 */
	Collection<String> getParameters();

	/**
	 * Get the value data of a parameter.
	 * 
	 * @param parameterName Name of the parameter as returned by
	 *                      {@link #getParameters() getParameters()}.
	 * @return The <code>Value</code> of the parameter wrapped in <code>Data</code>
	 *         object.
	 */
	Data<Type, Value> getParameter(String parameterName);

	/**
	 * Get the values contained in this collection value.
	 * 
	 * @return The <code>Value</code>s of the items wrapped in <code>Data</code>
	 *         objects.
	 */
	List<Data<Type, Value>> getItems();
}
