package org.etsi.mts.tdl.execution.java.rt.core;

import org.etsi.mts.tdl.execution.java.tri.Connection;
import org.etsi.mts.tdl.execution.java.tri.GateReference;

public class ConnectionImpl extends ElementImpl implements Connection {


	private final GateReference[] endPoints = new GateReference[2];

	public ConnectionImpl(String name, GateReference sourceGate, GateReference targetGate) {
		super(name);
		getEndPoints()[0] = sourceGate;
		getEndPoints()[1] = targetGate;
	}
	
	public GateReference[] getEndPoints() {
		return endPoints;
	}

	@Override
	public String toString() {
		if (name != null)
			return name;
		return getEndPoints()[0].toString() + " :: " + getEndPoints()[1].toString();
	}
}
