# TDL Constraint Helper

This project extracts OCL constraints from the TDL specifications (in `.docx` format) and transforms them into EVL and OCL specifications. To use, place the TDL specifications under `resources` and indicate the path in the `main` method. It may be adapted to take the filename as argument in the future. There also the desired output format can be selected.

This tool is intended to help with the maintenance, implementation, and validation of the constraints. The generated EVL or OCL specifications are used in the constraints implementation. The generated EVL or OCL files can be adapted to fix errors or address other issues and the adapted files can then be compared to identify issues that need to be backported to the specification. Ideally, the constraints extracted and transformed from the specification shall word directly, but typos or other issues may get in the way.

The extraction and transformation relies on correct and consistent formatting, therefore it is important to address such issues first and make sure that all constraints are identified, extracted, and transformed correctly. Tracked changes may need to be accepted first. In the future, some preliminary validation to ensure that the documents are suitable for processing may be added.

The implementation of the tool makes use of the Apache POI and related libraries to process the Word versions of the specifications. 