/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.view.SVTableUtils;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class SVTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Color black = SVTableUtils.getAWTColor(HSSFColor.HSSFColorPredefined.BLACK);
    private static final Color white = SVTableUtils.getAWTColor(HSSFColor.HSSFColorPredefined.WHITE);
    private static final POILogger logger = POILogFactory.getLogger(SVTableCellEditor.class);
    private HSSFWorkbook wb;
    private JTextField editor;

    public SVTableCellEditor(HSSFWorkbook wb) {
        this.wb = wb;
        this.editor = new JTextField();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean startCellEditing(EventObject anEvent) {
        logger.log(3, new Object[]{"Start Cell Editing"});
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        logger.log(3, new Object[]{"Stop Cell Editing"});
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        logger.log(3, new Object[]{"Cancel Cell Editing"});
        this.fireEditingCanceled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.log(3, new Object[]{"Action performed"});
        this.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        logger.log(3, new Object[]{"GetCellEditorValue"});
        return this.editor.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        logger.log(3, new Object[]{"GetTableCellEditorComponent"});
        HSSFCell cell = (HSSFCell)value;
        if (cell != null) {
            int fontheight;
            HSSFCellStyle style = cell.getCellStyle();
            HSSFFont f = this.wb.getFontAt(style.getFontIndexAsInt());
            boolean isbold = f.getBold();
            boolean isitalics = f.getItalic();
            int fontstyle = 0;
            if (isbold) {
                fontstyle = 1;
            }
            if (isitalics) {
                fontstyle |= 2;
            }
            if ((fontheight = f.getFontHeightInPoints()) == 9) {
                fontheight = 10;
            }
            Font font = new Font(f.getFontName(), fontstyle, fontheight);
            this.editor.setFont(font);
            if (style.getFillPattern() == FillPatternType.SOLID_FOREGROUND) {
                this.editor.setBackground(SVTableUtils.getAWTColor(style.getFillForegroundColor(), white));
            } else {
                this.editor.setBackground(white);
            }
            this.editor.setForeground(SVTableUtils.getAWTColor(f.getColor(), black));
            switch (cell.getCellType()) {
                case BLANK: {
                    this.editor.setText("");
                    break;
                }
                case BOOLEAN: {
                    if (cell.getBooleanCellValue()) {
                        this.editor.setText("true");
                        break;
                    }
                    this.editor.setText("false");
                    break;
                }
                case NUMERIC: {
                    this.editor.setText(Double.toString(cell.getNumericCellValue()));
                    break;
                }
                case STRING: {
                    this.editor.setText(cell.getRichStringCellValue().getString());
                    break;
                }
                default: {
                    this.editor.setText("?");
                }
            }
            switch (style.getAlignment()) {
                case LEFT: 
                case JUSTIFY: 
                case FILL: {
                    this.editor.setHorizontalAlignment(2);
                    break;
                }
                case CENTER: 
                case CENTER_SELECTION: {
                    this.editor.setHorizontalAlignment(0);
                    break;
                }
                case GENERAL: 
                case RIGHT: {
                    this.editor.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    this.editor.setHorizontalAlignment(2);
                }
            }
        }
        return this.editor;
    }
}

