package org.etsi.mts.tdl.tools.rt.ui.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;

import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour;
import org.etsi.mts.tdl.structuredobjectives.FinalConditions;
import org.etsi.mts.tdl.structuredobjectives.InitialConditions;
import org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 */
public class TranslationHandler extends AbstractHandler {
	LinkedHashMap<String, String> targetFormats = new LinkedHashMap<>();

	public static String translationTarget = "TDL XF (Part 3, XMI)";
	
	private IWorkbenchWindow window;

	/**
	 * The constructor.
	 */
	public TranslationHandler() {
		init();
	}

	private void init() {
		//TODO: do not reload after first init
		if (!targetFormats.isEmpty()) {
//			return;
		}
		targetFormats.clear();
		targetFormats.put("TDL XF (Part 3, XMI)", "tdl");
		loadTargetFormat("org.etsi.mts.tdl.tx", "TDL TX (Part 8, Braces)", "tdltx");
		loadTargetFormat("org.etsi.mts.tdl.txi", "TDL TX (Part 8, Indentation)", "tdltxi");
		loadTargetFormat("org.etsi.mts.tdl.TDLan2", "TDLan2 (Part 1, Annex B)", "tdlan2");
		loadTargetFormat("org.etsi.mts.tdl.TPLan2", "TPLan2 (Part 4, Annex B)", "tplan2");
	}

	private void loadTargetFormat(String bundleName, String label, String extension) {
		if (Platform.getBundle(bundleName) != null) {
			targetFormats.put(label, extension);
		}
	}

	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		init();
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		IEditorInput input = HandlerUtil.getActiveEditorInput(event);
		IFile file = null;
		if (input != null && input instanceof FileEditorInput) {
			file = ((FileEditorInput) input).getFile();
		} else if (selection !=null && selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			Object firstElement = structuredSelection.getFirstElement();
			if (firstElement instanceof IFile) {
				file = (IFile) firstElement;
			}
		}
		
		if (file !=null) {
			URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
			Injector injector = Guice.createInjector();
			XtextResourceSet resourceSet = injector.getInstance(XtextResourceSet.class);
//			ResourceSet rs = new ResourceSetImpl();
			XtextResourceSet rs = resourceSet;
			Resource r = rs.getResource(uri, true);
			EcoreUtil.resolveAll(r);

			ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), new LabelProvider());
			dialog.setTitle("Translation Configuration");
			dialog.setMessage("Translating "+file.getName()
								+"\n\nSelect the target format");
			dialog.setElements(targetFormats.keySet().toArray());
			
			dialog.setInitialElementSelections(Arrays.asList(new String[] {TranslationHandler.translationTarget}));

			// user pressed cancel
			if (dialog.open() != Window.OK) {
				return false;
			} else {
//				Injector injector = Guice.createInjector();
				Object[] result = dialog.getResult();
				String selected = (String)result[0];
				TranslationHandler.translationTarget = selected;
				String extension = targetFormats.get(selected);
				URI targetURI = URI.createURI(uri.toString()+"."+extension);
//				XtextResourceSet resourceSet = injector.getInstance(XtextResourceSet.class);
//				resourceSet = rs;
				Resource tr = resourceSet.createResource(targetURI);
				
				tr.getContents().addAll(EcoreUtil.copyAll(r.getContents()));
//				tr.getContents().addAll(r.getContents());
//				tr.getContents().add(EcoreUtil2.cloneWithProxies(r.getContents().get(0)));
				
				//post-process StructuredTestObjectives
				if (file.getName().endsWith("tplan2") && extension.startsWith("tdltx")) {
					//TODO: clean-up "string" identifiers -> need general way to handle.. 
					//		individual keywords do-able, more sophisticated shall be concatenated with _ 
					List<NamedElement> elements = EcoreUtil2.eAllOfType(tr.getContents().get(0), NamedElement.class);
					for (NamedElement e : elements) {
						e.setName(e.getName()
								.replaceAll("\"", "")
								.replaceAll("\\s", "_")
								.replaceAll("[,\\.-]", "_")
								.replaceAll("^(\\d)", "_$1")
								);
					}

					//TODO: extract
					//TODO: annotation types be imported ideally
					//TODO: reverse for backward compatibility?
					processElements("Initial conditions", tr, InitialConditions.class);
					processElements("Expected behaviour", tr, ExpectedBehaviour.class);
					processElements("Final conditions", tr, FinalConditions.class);
					
				}
				
				try {
					EcoreUtil.resolveAll(tr);
//					EcoreUtil2.resolveAll(r, null);
//				    HashMap<Object,Object> options = Maps.newHashMap();
//				    options.put(XtextResource.OPTION_RESOLVE_ALL, true);
					tr.save(null);
				} catch (Exception e1) {
					System.err.println("  Translation: "+e1.getMessage());
					e1.printStackTrace();
					//TODO: provide an error dialog, fall back to XF, indicate approximate location based on error message / details
				}
			}
		}
		return null;
	}
	
	private <T extends Element> void processElements(String annotationType, Resource tr, Class<T> type) {
		AnnotationType at = getAnnotationType(tr, annotationType);
		List<T> elements = EcoreUtil2.eAllOfType(tr.getContents().get(0), type);
		for (T e : elements) {
			Annotation a = tdlFactory.eINSTANCE.createAnnotation();
			a.setKey(at);
			e.getAnnotation().add(a);
			e.setName(null);
		}
		
	}

	private AnnotationType getAnnotationType(Resource tr, String annotationType) {
		AnnotationType aType;
		Optional<AnnotationType> optional = EcoreUtil2
				.eAllOfType(tr.getContents().get(0), AnnotationType.class)
				.stream()
				.filter(at -> at.getName().equals(annotationType)).findFirst();
		if (optional.isEmpty()) {
			aType = createAnnotationType(tr, annotationType);
		} else {
			aType = optional.get();
		}
		return aType;
	}

	private AnnotationType createAnnotationType(Resource tr, String annotationType) {
		AnnotationType at = tdlFactory.eINSTANCE.createAnnotationType();
		at.setName(annotationType);
		((Package) tr.getContents().get(0)).getPackagedElement().add(0, at);
		return at;
	}
	
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}

}
