package org.etsi.mts.tdl.constraints.ui.handlers;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class ScrollableMessageDialog extends MessageDialog {

    private String scrollableText;

	public ScrollableMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage,
			int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String scrolledText) {
		super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, dialogButtonLabels);
		scrollableText = scrolledText;
	}
	
    @Override
	protected Control createCustomArea(Composite parent) {
        Text scrollable = new Text(parent, SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        GridData layoutData = new GridData(GridData.FILL_BOTH);
        layoutData.widthHint = 800;
		scrollable.setLayoutData(layoutData);
        scrollable.setText(scrollableText);
        scrollable.setEditable(false);
        scrollable.setSize(800, 800);
        return scrollable;
    }

    @Override
    protected boolean isResizable() {
        return true; // Allow the user to change the dialog size!
    }
}