/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;

public final class CopyCompare {
    private CopyCompare() {
    }

    public static void main(String[] args) throws UnsupportedEncodingException, IOException {
        String originalFileName = null;
        String copyFileName = null;
        if (args.length == 1) {
            originalFileName = args[0];
            File f = TempFile.createTempFile((String)"CopyOfPOIFileSystem-", (String)".ole2");
            f.deleteOnExit();
            copyFileName = f.getAbsolutePath();
        } else if (args.length == 2) {
            originalFileName = args[0];
            copyFileName = args[1];
        } else {
            System.err.println("Usage: " + CopyCompare.class.getName() + "originPOIFS [copyPOIFS]");
            System.exit(1);
        }
        POIFSReader r = new POIFSReader();
        CopyFile cf = new CopyFile(copyFileName);
        r.registerListener((POIFSReaderListener)cf);
        r.setNotifyEmptyDirectories(true);
        r.read(new File(originalFileName));
        cf.close();
        try (POIFSFileSystem opfs = new POIFSFileSystem(new File(originalFileName));
             POIFSFileSystem cpfs = new POIFSFileSystem(new File(copyFileName));){
            DirectoryNode oRoot = opfs.getRoot();
            DirectoryNode cRoot = cpfs.getRoot();
            System.out.println(EntryUtils.areDirectoriesIdentical((DirectoryEntry)oRoot, (DirectoryEntry)cRoot) ? "Equal" : "Not equal");
        }
    }

    static class CopyFile
    implements POIFSReaderListener {
        private String dstName;
        private OutputStream out;
        private POIFSFileSystem poiFs;
        private final Map<String, DirectoryEntry> paths = new HashMap<String, DirectoryEntry>();

        CopyFile(String dstName) {
            this.dstName = dstName;
            this.poiFs = new POIFSFileSystem();
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            Throwable t;
            String name;
            POIFSDocumentPath path;
            block6: {
                path = event.getPath();
                name = event.getName();
                DocumentInputStream stream = event.getStream();
                t = null;
                try {
                    if (stream != null && PropertySet.isPropertySetStream((InputStream)stream)) {
                        PropertySet ps = null;
                        try {
                            ps = PropertySetFactory.create((InputStream)stream);
                        }
                        catch (NoPropertySetStreamException noPropertySetStreamException) {
                            // empty catch block
                        }
                        this.copy(this.poiFs, path, name, ps);
                        break block6;
                    }
                    this.copy(this.poiFs, path, name, stream);
                }
                catch (IOException | MarkUnsupportedException | WritingNotSupportedException ex) {
                    t = ex;
                }
            }
            if (t != null) {
                throw new HPSFRuntimeException("Could not read file \"" + path + "/" + name, t);
            }
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, PropertySet ps) throws WritingNotSupportedException, IOException {
            Object mps;
            DirectoryEntry de = this.getPath(poiFs, path);
            try {
                mps = ps instanceof DocumentSummaryInformation ? new DocumentSummaryInformation(ps) : (ps instanceof SummaryInformation ? new SummaryInformation(ps) : new PropertySet(ps));
            }
            catch (UnexpectedPropertySetTypeException e) {
                throw new IOException(e);
            }
            de.createDocument(name, mps.toInputStream());
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, DocumentInputStream stream) throws IOException {
            int c;
            DirectoryEntry de = this.getPath(poiFs, path);
            if (stream == null || name == null) {
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                out.write(c);
            }
            stream.close();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            de.createDocument(name, (InputStream)in);
        }

        public void close() throws IOException {
            this.out = new FileOutputStream(this.dstName);
            this.poiFs.writeFilesystem(this.out);
            this.out.close();
        }

        public DirectoryEntry getPath(POIFSFileSystem poiFs, POIFSDocumentPath path) {
            try {
                String s = path.toString();
                DirectoryEntry de = this.paths.get(s);
                if (de != null) {
                    return de;
                }
                int l = path.length();
                if (l == 0) {
                    de = poiFs.getRoot();
                } else {
                    de = this.getPath(poiFs, path.getParent());
                    de = de.createDirectory(path.getComponent(path.length() - 1));
                }
                this.paths.put(s, de);
                return de;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

