/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate();

    public abstract SemanticContext getGatedPredicateContext();

    public abstract StringTemplate genExpr(CodeGenerator var1, StringTemplateGroup var2, DFA var3);

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar g) {
    }

    public static SemanticContext and(SemanticContext a, SemanticContext b) {
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        return new AND(a, b);
    }

    public static SemanticContext or(SemanticContext a, SemanticContext b) {
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null) {
            return a;
        }
        if (a instanceof TruePredicate) {
            return a;
        }
        if (b instanceof TruePredicate) {
            return b;
        }
        if (a instanceof NOT && b instanceof Predicate) {
            NOT n = (NOT)a;
            if (n.ctx.equals(b)) {
                return new TruePredicate();
            }
        } else if (b instanceof NOT && a instanceof Predicate) {
            NOT n = (NOT)b;
            if (n.ctx.equals(a)) {
                return new TruePredicate();
            }
        } else if (a.equals(b)) {
            return a;
        }
        return new OR(a, b);
    }

    public static SemanticContext not(SemanticContext a) {
        return new NOT(a);
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext ctx) {
            this.ctx = ctx;
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("notPredicate") : new StringTemplate("?!($pred$)");
            eST.setAttribute("pred", this.ctx.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext p = this.ctx.getGatedPredicateContext();
            if (p == null) {
                return null;
            }
            return new NOT(p);
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            this.ctx.trackUseOfSyntacticPredicates(g);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    public static class OR
    extends SemanticContext {
        protected Set operands = new HashSet();

        public OR(SemanticContext a, SemanticContext b) {
            if (a instanceof OR) {
                this.operands.addAll(((OR)a).operands);
            } else if (a != null) {
                this.operands.add(a);
            }
            if (b instanceof OR) {
                this.operands.addAll(((OR)b).operands);
            } else if (b != null) {
                this.operands.add(b);
            }
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("orPredicates") : new StringTemplate("($first(operands)$$rest(operands):{o | ||$o$}$)");
            for (SemanticContext semctx : this.operands) {
                eST.setAttribute("operands", semctx.genExpr(generator, templates, dfa));
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext result = null;
            for (SemanticContext semctx : this.operands) {
                SemanticContext gatedPred = semctx.getGatedPredicateContext();
                if (gatedPred == null) continue;
                result = OR.or(result, gatedPred);
            }
            return result;
        }

        public boolean isSyntacticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            for (SemanticContext semctx : this.operands) {
                semctx.trackUseOfSyntacticPredicates(g);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            int i = 0;
            for (SemanticContext semctx : this.operands) {
                if (i > 0) {
                    buf.append("||");
                }
                buf.append(semctx.toString());
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    public static class AND
    extends SemanticContext {
        protected SemanticContext left;
        protected SemanticContext right;

        public AND(SemanticContext a, SemanticContext b) {
            this.left = a;
            this.right = b;
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("andPredicates") : new StringTemplate("($left$&&$right$)");
            eST.setAttribute("left", this.left.genExpr(generator, templates, dfa));
            eST.setAttribute("right", this.right.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext gatedLeft = this.left.getGatedPredicateContext();
            SemanticContext gatedRight = this.right.getGatedPredicateContext();
            if (gatedLeft == null) {
                return gatedRight;
            }
            if (gatedRight == null) {
                return gatedLeft;
            }
            return new AND(gatedLeft, gatedRight);
        }

        public boolean isSyntacticPredicate() {
            return this.left.isSyntacticPredicate() || this.right.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            this.left.trackUseOfSyntacticPredicates(g);
            this.right.trackUseOfSyntacticPredicates(g);
        }

        public String toString() {
            return "(" + this.left + "&&" + this.right + ")";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            this.constantValue = 1;
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("true");
            }
            return new StringTemplate("true");
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public GrammarAST predicateAST;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -1;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = 1;
        protected int constantValue = -1;

        public Predicate() {
            this.predicateAST = new GrammarAST();
            this.gated = false;
        }

        public Predicate(GrammarAST predicate) {
            this.predicateAST = predicate;
            this.gated = predicate.getType() == 35 || predicate.getType() == 36;
            this.synpred = predicate.getType() == 36 || predicate.getType() == 37;
        }

        public Predicate(Predicate p) {
            this.predicateAST = p.predicateAST;
            this.gated = p.gated;
            this.synpred = p.synpred;
            this.constantValue = p.constantValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Predicate)) {
                return false;
            }
            return this.predicateAST.getText().equals(((Predicate)o).predicateAST.getText());
        }

        public int hashCode() {
            if (this.predicateAST == null) {
                return 0;
            }
            return this.predicateAST.getText().hashCode();
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            if (templates != null) {
                if (this.synpred) {
                    eST = templates.getInstanceOf("evalSynPredicate");
                } else {
                    eST = templates.getInstanceOf("evalPredicate");
                    generator.grammar.decisionsWhoseDFAsUsesSemPreds.add(dfa);
                }
                String predEnclosingRuleName = this.predicateAST.enclosingRuleName;
                if (generator != null) {
                    eST.setAttribute("pred", generator.translateAction(predEnclosingRuleName, this.predicateAST));
                }
            } else {
                eST = new StringTemplate("$pred$");
                eST.setAttribute("pred", this.toString());
                return eST;
            }
            if (generator != null) {
                String description = generator.target.getTargetStringLiteralFromString(this.toString());
                eST.setAttribute("description", description);
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean isSyntacticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 36 || this.predicateAST.getType() == 37);
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            if (this.synpred) {
                g.synPredNamesUsedInDFA.add(this.predicateAST.getText());
            }
        }

        public String toString() {
            if (this.predicateAST == null) {
                return "<nopred>";
            }
            return this.predicateAST.getText();
        }
    }
}

