package org.etsi.mts.tdl.execution.java.tri;

/**
 * The exception that is thrown when the test execution should be stopped. It is
 * distinct from runtime exceptions as it indicates a normal completion of the
 * test execution. If the <code>verdict</code> is set then it passed to
 * {@link Validator#setVerdict(Verdict) Validator.setVerdict()} function.
 * <p>
 * This can be thrown by a {@link Validator#matches(Data, Data)
 * Validator.matches()} when the final verdict of the test case has already been
 * determined, for example. It is also thrown for TDL stop and timeout
 * behaviours.
 *
 */
@SuppressWarnings("serial")
public abstract class StopException extends Exception {

	public StopException(String message) {
		super(message);
	}
	
	@Override
	public String getMessage() {
		return super.getMessage();
	}

	/**
	 * Optional final verdict.
	 */
	public abstract Verdict getVerdict();
}
