package org.etsi.mts.tdl.execution.java.tri;

import java.util.List;

/**
 * Generic class for encapsulating information about model elements. The
 * concrete type of the element is specified by a sub-class or the context where
 * the element is used. Note that the element does not always represent a TDL
 * meta-class.
 *
 */
public interface Element {

	/**
	 * The name of the element as specified in TDL model.
	 */
	String getName();

	/**
	 * The annotations assigned to the element as specified in TDL model.
	 */
	List<ElementAnnotation> getAnnotations();

}
