package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.etsi.mts.tdl.execution.java.tri.Data;
import org.etsi.mts.tdl.execution.java.tri.Mapping;
import org.etsi.mts.tdl.execution.java.tri.Type;
import org.etsi.mts.tdl.execution.java.tri.Value;

public class TypeImpl extends NamedElementImpl implements Type, TriImpl<TypeImpl, TypeImpl> {
	private boolean structure = false;
	private boolean collection = false;
	private boolean enumerated = false;

	private Map<String, TypeImpl> parameters = new Hashtable<String, TypeImpl>();
	private TypeImpl itemType = null;
	private List<Data<Type, Value>> enumLiterals = new ArrayList<Data<Type,Value>>();

	private MappingImpl mapping;

	public TypeImpl setIsStructure(boolean structure) {
		this.structure = structure;
		return this;
	}

	public TypeImpl setIsCollection(boolean collection) {
		this.collection = collection;
		return this;
	}
	
	public TypeImpl setIsEnum(boolean enumerated) {
		this.enumerated = enumerated;
		return this;
	}

	@Override
	public boolean isStructure() {
		return this.structure;
	}

	@Override
	public boolean isCollection() {
		return this.collection;
	}
	
	@Override
	public boolean isEnum() {
		return this.enumerated;
	}

	public TypeImpl setMapping(Mapping mapping) {
		this.mapping = (MappingImpl) mapping;
		return this;
	}

	@Override
	public MappingImpl getMapping() {
		return mapping;
	}

	@Override
	public TypeImpl setParameter(String name, TypeImpl type) {
		this.parameters.put(name, type);
		return this;
	}

	@Override
	public TypeImpl getParameterType(String name) {
		return this.parameters.get(name);
	}

	@Override
	public Collection<String> getParameters() {
		return this.parameters.keySet();
	}

	public TypeImpl setItemType(TypeImpl itemType) {
		this.itemType = itemType;
		return this;
	}

	@Override
	public TypeImpl getItemType() {
		return this.itemType;
	}
	
	@Override
	public List<Data<Type, Value>> getEnumLiterals() {
		return this.enumLiterals;
	}
	
	public TypeImpl addEnumLiteral(ValueImpl literal) {
		this.enumLiterals.add(new DataImpl<Type, Value>(this, literal));
		return this;
	}

	@Override
	public TypeImpl setName(String name, String qualifiedName) {
		this.name = name;
		this.setQualifiedName(qualifiedName);
		return this;
	}

	@Override
	public TypeImpl addAnnotation(String key, String value) {
		super.addAnnotation(key, value);
		return this;	
	}

}
