package org.etsi.mts.tdl.execution.java.rt.core;

import org.etsi.mts.tdl.execution.java.tri.Data;

public class ArgumentImpl<T, V> extends DataImpl<T, V> {
	private String parameterName;

	public ArgumentImpl(T type, V value, String parameterName) {
		super(type, value);
		this.parameterName = parameterName;
	}

	public ArgumentImpl(Data<T, V> data, String parameterName) {
		super(data.getType(), data.getValue());
		this.parameterName = parameterName;
	}

	public String getParameterName() {
		return parameterName;
	}
}
