package org.etsi.mts.tdl.execution.java.tri;

/**
 * Interface for providing custom data matching and verdict management.
 *
 */
public interface Validator {

	/**
	 * Performs environment specific comparison of <code>actual</code> data received
	 * from the system under test and the data <code>expected</code> by the test
	 * description.
	 * 
	 * @return <code>True</code> when the objects match.
	 * @throws AssertionError When actual data does not match with expected data.
	 */
	boolean matches(Data expected, Data actual) throws AssertionError;

	/**
	 * Updates the current verdict of the test description execution.
	 */
	void setVerdict(Verdict verdict);
}
